!== Sample program for gt4_history/gt4f90io
!
! Authors::   Yasuhiro MORIKAWA, Eizi TOYODA
! Version::   $Id: histget.f90,v 1.13 2006/09/09 08:26:57 morikawa Exp $
! Tag Name::  $Name: gt4f90io-20061118 $
! Copyright:: Copyright (C) GFD Dennou Club, 2000-2005. All rights reserved.
! License::   See COPYRIGHT[link:../COPYRIGHT]
!

program histget
  ! histget.f90 - Sample program for gt4_history/gt4f90io.
  !               Test Program for "HistoryGet".
  !

  use dc_trace,   only: SetDebug, DataDump
  use dc_message, only: MessageNotify
  use dc_types,   only: STRING, DP
  use dc_string,  only: StoA, toChar
  use gt4_history
  implicit none
  integer             :: i,j,k,l                        ! ѿ
  integer,  parameter :: nx=3, ny=4, nz=5               ! åɿ
  integer,  parameter :: time_period=3                  ! 
  real,     parameter :: x(nx)=(/(1.0*(i-1),i=1,nx)/)   ! xɸѿ
  real(DP), parameter :: y(ny)=(/(10.0*(i-1),i=1,ny)/)  ! yɸѿ
  real(DP), parameter :: z(nz)=(/(100.0*(i-1),i=1,nz)/) ! zɸѿ

  real                :: u           ! ̵
  real(DP)            :: v(nx)       !  1 
  real(DP)            :: v2(nz)      !  1 󤽤2
  real                :: w(nx,ny)    !  2 
  real(DP)            :: q(nx,ny,nz) !  3 

  real,     pointer   :: up       =>null() ! ̵ݥ
  real(DP), pointer   :: vp(:)    =>null() !  1 ݥ
  real,     pointer   :: wp(:,:)  =>null() !  2 ݥ
  real(DP), pointer   :: qp(:,:,:)=>null() !  3 ݥ

  real,     pointer   :: xp(:) =>null()    !  xɸݥ
  real(DP), pointer   :: yp(:) =>null()    !  yɸݥ
  real(DP), pointer   :: zp(:) =>null()    !  zɸݥ

  real(DP), pointer   :: vp_range     =>null() ! range Ǥϥƥ
  real(DP), pointer   :: qp_range(:,:)=>null() ! range Ǥϥƥ

  character(string), parameter  :: subname = 'histget'
continue

  call SetDebug

  !-----------------------------------------------------------------
  ! ޤѤΥե
  !-----------------------------------------------------------------

  call HistoryCreate(file='xhistget/xhistget1.nc', &
    & title='gt4_history HistoryGet test 1', &
    & source='gt4f90io/Fortran library test kit', &
    & institution='GFD Dennou Club', &
    & dims=StoA('x','y','z','t'), &
    & dimsizes=(/nx,ny,nz,0/), &
    & longnames=StoA('X-coordinate','Y-coordinate', 'Z-coordinate','time'), &
    & units=StoA('m','m','m','s'), &
    & origin=0.0, interval=0.2, &
    & xtypes=StoA('real','double','double','real'))

  call HistoryPut('x',x)   ! ѿ
  call HistoryPut('y',y)   ! ѿ
  call HistoryPut('z',z)   ! ѿ

  call HistoryAddVariable('u', dims=(/'t'/), &
    & longname='Non Dimensional any quantity', &
    & units='non-dimensional')
  call HistoryAddVariable('v', dims=(/'x','t'/), &
    & longname='1 Dimensional any quantity', &
    & units='1-dimensional any unit', xtype='double')
  call HistoryAddVariable('v2', dims=(/'z','t'/), &
    & longname='1 Dimensional any quantity II', &
    & units='1-dimensional any unit', xtype='double')
  call HistoryAddVariable('w', dims=(/'x','y','t'/), &
    & longname='2 Dimensional any quantity', &
    & units='2-dimensional any unit')
  call HistoryAddVariable('q', dims=(/'x','y','z','t'/), &
    & longname='3 Dimensional any quantity', &
    & units='3-dimensional any unit', xtype='double')

  do, l = 1, time_period
    u = real(l)*0.100000001
    do i = 1, nx
      v(i) = dble(l)*0.100000001d0+dble(i)*10.0000001d0
      do j = 1, ny
        w(i,j) = real(l)*0.100000001 + real(i)*10.0000001 &
          & + real(j)*1000.00001
        do k = 1, nz
          q(i,j,k) = dble(l)*0.100000001d0     &
            & + dble(i)*10.0000001d0  &
            & + dble(j)*1000.00001d0  &
            & + dble(k)*100000.001d0

          v2(k) = dble(k)*100000.001d0 + dble(l)
        enddo
      enddo
    enddo
    call HistoryPut('t', real(l)*0.2)
    call HistoryPut('u', u)
    call HistoryPut('v', v)
    call HistoryPut('v2', v2)
    call HistoryPut('w', w)
    call HistoryPut('q', q)

  enddo

  call DataDump('v', v, strlen=10)
  call DataDump('w', dble(w), strlen=60)
  call DataDump('q(1,1,', q(1,1,:))

  call HistoryClose

  call MessageNotify('M', subname, 'Input file <%c> is generated.', &
    & c1='xhistget/xhistget1.nc')

  !-----------------------------------------------------------------
  ! Ĺˤϥƥ (ʺˡ)
  !-----------------------------------------------------------------

  call MessageNotify('M', subname, 'Getting by Fixed-Length Array.')

  call HistoryCreate(file='xhistget/xhistget2.nc', &
    & title='gt4_history HistoryGet test 1', &
    & source='gt4f90io/Fortran library test kit', &
    & institution='GFD Dennou Club', &
    & dims=(/'x','y','z','t'/), &
    & dimsizes=(/nx,ny,nz,0/), &
    & longnames=(/'X-coordinate','Y-coordinate', &
    &  'Z-coordinate','time        '/), &
    & units=(/'m','m','m','s'/), &
    & origin=0.0, interval=0.2, &
    & xtypes=(/'real  ','double','double','real  '/))

  call HistoryPut('x',x)   ! ѿ
  call HistoryPut('y',y)   ! ѿ
  call HistoryPut('z',z)   ! ѿ

  call HistoryAddVariable('u', dims=(/'t'/), &
    & longname='Non Dimensional any quantity', &
    & units='non-dimensional')
  call HistoryAddVariable('v', dims=(/'x','t'/), &
    & longname='1 Dimensional any quantity', &
    & units='1-dimensional any unit', xtype='double')
  call HistoryAddVariable('v2', dims=(/'z','t'/), &
    & longname='1 Dimensional any quantity II', &
    & units='1-dimensional any unit', xtype='double')
  call HistoryAddVariable('w', dims=(/'x','y','t'/), &
    & longname='2 Dimensional any quantity', &
    & units='2-dimensional any unit')
  call HistoryAddVariable('q', dims=(/'x','y','z','t'/), &
    & longname='3 Dimensional any quantity', &
    & units='3-dimensional any unit', xtype='double')

  do, l = 1, time_period - 1
    call HistoryPut('t', real(l)*0.2)
    call HistoryGet(file='xhistget/xhistget1.nc', varname='u', & 
      &          array=u, time=real(l)*0.2)
    call HistoryPut('u', u)
    call HistoryGet('xhistget/xhistget1.nc', 'v', v, dble(l)*0.2d0)
    call HistoryPut('v', v)
    call HistoryGet('xhistget/xhistget1.nc', 'v2', v2, range='t=^'//toChar(l))
    call HistoryPut('v2', v2)
    call HistoryGet('xhistget/xhistget1.nc', 'w', w, range='^'//toChar(l))
    call HistoryPut('w', w)
    call HistoryGet('xhistget/xhistget1.nc', 'q', q, '^'//toChar(l))
    call HistoryPut('q', q)
  enddo

  ! ֤μưȽ̤Υƥ
  l = time_period
  call HistoryPut('t', real(l)*0.2)
  call HistoryGet(file='xhistget/xhistget1.nc', varname='u', array=u)
  call HistoryPut('u', u)
  call HistoryGet('xhistget/xhistget1.nc', 'v', v)
  call HistoryPut('v', v)
  call HistoryGet('xhistget/xhistget1.nc', 'v2', v2, range='^'//toChar(l))
  call HistoryPut('v2', v2)
  call HistoryGet('xhistget/xhistget1.nc', 'w', w)
  call HistoryPut('w', w)
  call HistoryGet('xhistget/xhistget1.nc', 'q', q, '^'//toChar(l))
  call HistoryPut('q', q)

  call HistoryClose


  !-----------------------------------------------------------------
  !   ݥˤϥƥ (ʺˡ)
  !-----------------------------------------------------------------


  call HistoryCreate(file='xhistget/xhistget3.nc', &
    & title='gt4_history HistoryGet test 1', &
    & source='gt4f90io/Fortran library test kit', &
    & institution='GFD Dennou Club', &
    & dims=(/'x','y','z','t'/), &
    & dimsizes=(/nx,ny,nz,0/), &
    & longnames=(/'X-coordinate','Y-coordinate', &
    &  'Z-coordinate','time        '/), &
    & units=(/'m','m','m','s'/), &
    & origin=0.0, interval=0.2, &
    & xtypes=(/'real  ','double','double','real  '/))

  call HistoryPut('x',x)   ! ѿ
  call HistoryPut('y',y)   ! ѿ
  call HistoryPut('z',z)   ! ѿ

  call HistoryAddVariable('u', dims=(/'t'/), &
    & longname='Non Dimensional any quantity', &
    & units='non-dimensional')
  call HistoryAddVariable('v', dims=(/'x','t'/), &
    & longname='1 Dimensional any quantity', &
    & units='1-dimensional any unit', xtype='double')
  call HistoryAddVariable('v2', dims=(/'z','t'/), &
    & longname='1 Dimensional any quantity II', &
    & units='1-dimensional any unit', xtype='double')
  call HistoryAddVariable('w', dims=(/'x','y','t'/), &
    & longname='2 Dimensional any quantity', &
    & units='2-dimensional any unit')
  call HistoryAddVariable('q', dims=(/'x','y','z','t'/), &
    & longname='3 Dimensional any quantity', &
    & units='3-dimensional any unit', xtype='double')

  do, l = 1, time_period - 1
    call HistoryPut('t', real(l)*0.2)
    call HistoryGetPointer(file='xhistget/xhistget1.nc', varname='u', & 
      &          array=up, time=real(l)*0.2)
    call HistoryPut('u', up)
    if (associated(vp)) deallocate(vp)
    call HistoryGetPointer('xhistget/xhistget1.nc', 'v', vp, dble(l)*0.2d0)
    call HistoryPut('v', vp)
    if (associated(vp)) deallocate(vp)
    call HistoryGetPointer('xhistget/xhistget1.nc', 'v2', vp, range='^'//toChar(l))
    call HistoryPut('v2', vp)
    call HistoryGetPointer('xhistget/xhistget1.nc', 'w', wp, range='^'//toChar(l))
    call HistoryPut('w', wp)
    call HistoryGetPointer('xhistget/xhistget1.nc', 'q', qp, '^'//toChar(l))
    call HistoryPut('q', qp)
  enddo

  ! ֤μưȽ̤Υƥ
  l = time_period
  call HistoryPut('t', real(l)*0.2)
  call HistoryGetPointer(file='xhistget/xhistget1.nc', varname='u', array=up)
  call HistoryPut('u', up)
  if (associated(vp)) deallocate(vp)
  call HistoryGetPointer('xhistget/xhistget1.nc', 'v', vp)
  call HistoryPut('v', vp)
  if (associated(vp)) deallocate(vp)
  call HistoryGetPointer('xhistget/xhistget1.nc', 'v2', vp, dble(l)*0.2d0)
  call HistoryPut('v2', vp)
  call HistoryGetPointer('xhistget/xhistget1.nc', 'w', wp)
  call HistoryPut('w', wp)
  call HistoryGetPointer('xhistget/xhistget1.nc', 'q', qp, '^'//toChar(l))
  call HistoryPut('q', qp)

  call HistoryClose

  !-----------------------------------------------------------------
  !   ǡϥƥ (ʺˡ)
  !-----------------------------------------------------------------
  call MessageNotify('M', subname, 'Getting by Various Forms.')

  call HistoryCreate(file='xhistget/xhistget4.nc', &
    & title='gt4_history HistoryGet test 1', &
    & source='gt4f90io/Fortran library test kit', &
    & institution='GFD Dennou Club', &
    & dims=(/'x','y','z','t'/), &
    & dimsizes=(/nx,ny,nz,0/), &
    & longnames=(/'X-coordinate','Y-coordinate', &
    &  'Z-coordinate','time        '/), &
    & units=(/'m','m','m','s'/), &
    & origin=0.0, interval=0.2, &
    & xtypes=(/'real  ','double','double','real  '/))

  ! ǡϤ
  call HistoryGetPointer('xhistget/xhistget1.nc', 'x' ,xp)   ! x 
  call HistoryGetPointer('xhistget/xhistget1.nc', 'y' ,yp)   ! y 
  call HistoryGetPointer(file='xhistget/xhistget1.nc', varname='z' ,array=zp)   ! z 

  call HistoryPut('x',xp)   ! ѿ
  call HistoryPut('y',yp)   ! ѿ
  call HistoryPut('z',zp)   ! ѿ

  call HistoryAddVariable('u', dims=(/'t'/), &
    & longname='Non Dimensional any quantity', &
    & units='non-dimensional')
  call HistoryAddVariable('v', dims=(/'x','t'/), &
    & longname='1 Dimensional any quantity', &
    & units='1-dimensional any unit', xtype='double')
  call HistoryAddVariable('v2', dims=(/'z','t'/), &
    & longname='1 Dimensional any quantity II', &
    & units='1-dimensional any unit', xtype='double')
  call HistoryAddVariable('w', dims=(/'x','y','t'/), &
    & longname='2 Dimensional any quantity', &
    & units='2-dimensional any unit')
  call HistoryAddVariable('q', dims=(/'x','y','z','t'/), &
    & longname='3 Dimensional any quantity', &
    & units='3-dimensional any unit', xtype='double')

  do, l = 1, time_period
    call HistoryPut('t', real(l)*0.2)
    call HistoryGetPointer(file='xhistget/xhistget1.nc', varname='u', & 
      &          array=up, time=real(l)*0.2)
    call HistoryPut('u', up)
    if (associated(vp)) deallocate(vp)
    call HistoryGetPointer('xhistget/xhistget1.nc', 'v', vp, dble(l)*0.2d0)
    call HistoryPut('v', vp)
    if (associated(vp)) deallocate(vp)
    call HistoryGetPointer('xhistget/xhistget1.nc', 'v2', vp, range='^'//toChar(l))
    call HistoryPut('v2', vp)
    call HistoryGetPointer('xhistget/xhistget1.nc', 'w', wp, range='^'//toChar(l))
    call HistoryPut('w', wp)
    call HistoryGetPointer('xhistget/xhistget1.nc', 'q', qp, '^'//toChar(l))
    call HistoryPut('q', qp)
  enddo

  call HistoryClose



  !-----------------------------------------------------------------
  !   range ץΥƥ
  !-----------------------------------------------------------------
  call MessageNotify('M', subname, 'Getting with range option. (take a long time ...)')

  call HistoryCreate(file='xhistget/xhistget5.nc', &
    & title='gt4_history HistoryGet test 1', &
    & source='gt4f90io/Fortran library test kit', &
    & institution='GFD Dennou Club', &
    & dims=(/'x','y','z','t'/), &
    & dimsizes=(/nx,ny,nz,0/), &
    & longnames=(/'X-coordinate','Y-coordinate', &
    &  'Z-coordinate','time        '/), &
    & units=(/'m','m','m','s'/), &
    & origin=0.0, interval=0.2, &
    & xtypes=(/'real  ','double','double','real  '/))

  call HistoryPut('x',xp)   ! ѿ
  call HistoryPut('y',yp)   ! ѿ
  call HistoryPut('z',zp)   ! ѿ

  call HistoryAddVariable('u', dims=(/'t'/), &
    & longname='Non Dimensional any quantity', &
    & units='non-dimensional')
  call HistoryAddVariable('v', dims=(/'x','t'/), &
    & longname='1 Dimensional any quantity', &
    & units='1-dimensional any unit', xtype='double')
  call HistoryAddVariable('v2', dims=(/'z','t'/), &
    & longname='1 Dimensional any quantity II', &
    & units='1-dimensional any unit', xtype='double')
  call HistoryAddVariable('w', dims=(/'x','y','t'/), &
    & longname='2 Dimensional any quantity', &
    & units='2-dimensional any unit')
  call HistoryAddVariable('q', dims=(/'x','y','z','t'/), &
    & longname='3 Dimensional any quantity', &
    & units='3-dimensional any unit', xtype='double')

  do, l = 1, time_period - 1
    call HistoryPut('t', real(l)*0.2)
    call HistoryGet(file='xhistget/xhistget1.nc', varname='u', & 
      &          array=u, time=real(l)*0.2 + 0.05)
    call HistoryPut('u', u)

    do i = 1, size(xp)
      call HistoryGet('xhistget/xhistget1.nc', 'v', v(i), &
        & range='t=' // trim(toChar(real(l)*0.2 - 0.05)) // &
        &       ',x=' // trim(toChar(xp(i))) )
    end do
    call HistoryPut('v', v)

    do k = 1, size(zp)
      if (associated(vp_range)) deallocate(vp_range)
      call HistoryGetPointer('xhistget/xhistget1.nc', &
        & 'v2', vp_range, &
        & range='t=' // trim(toChar(real(l)*0.2)) // &
        &       ',z=' // trim(toChar(zp(k))) )
      v2(k) = vp_range
    end do
    call HistoryPut('v2', v2)

    do j = 1, size(yp)
      call HistoryGet('xhistget/xhistget1.nc', 'w', w(:,j), &
        & range='t=^' // trim(toChar(l)) // &
        &       ',y=' // trim(toChar(yp(j))) )
    end do
    call HistoryPut('w', w)

    do i = 1, size(xp)
      if (associated(qp_range)) deallocate(qp_range)
      call HistoryGetPointer('xhistget/xhistget1.nc', 'q', &
        & qp_range, &
        & range='t=^' // trim(toChar(l)) // &
        &       ',x=' // trim(toChar(xp(i))) )
      q(i,:,:) = qp_range(:,:)
    end do
    call HistoryPut('q', q)
  enddo

  ! ֤μưȽ̤Υƥ
  l = time_period
  call HistoryPut('t', real(l)*0.2)
  call HistoryGet(file='xhistget/xhistget1.nc', varname='u', array=u)
  call HistoryPut('u', u)
  do i = 1, size(xp)
    call HistoryGet('xhistget/xhistget1.nc', 'v', v(i), &
      & range='x=' // trim(toChar(xp(i))) )
  end do
  call HistoryPut('v', v)
  call HistoryGet('xhistget/xhistget1.nc', 'v2', v2, range='^'//toChar(l))
  call HistoryPut('v2', v2)
  do j = 1, size(yp)
    call HistoryGet('xhistget/xhistget1.nc', 'w', w(:,j), &
      & range='y=' // trim(toChar(yp(j))) )
  end do
  call HistoryPut('w', w)
  call HistoryGet('xhistget/xhistget1.nc', 'q', q, '^'//toChar(l))
  call HistoryPut('q', q)

  call HistoryClose

end program histget
