!== dc_url.f90 - ѿ URL ʸ
!
! Authors::   Yasuhiro MORIKAWA, Eizi TOYODA
! Version::   $Id: dc_url.f90,v 1.7 2006/07/17 15:19:21 morikawa Exp $
! Tag Name::  $Name: gt4f90io-20061118 $
! Copyright:: Copyright (C) GFD Dennou Club, 2000-2005. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
! This file provides dc_url
!

module dc_url
  !
  !== Overview
  !
  ! Υ⥸塼 gtool4 ѿ URL ʸ
  ! Ԥμ³󶡤ޤ
  !
  ! gtool4 ѿν񼰤˴ؤƤ,
  ! {gtool4 netCDF }[link:../xref.htm#label-6]
  ! Ρ5. Ƽʸ񼰡פ򻲾Ȥ
  !
  !== Procedures Summary
  !
  ! ³
  !
  ! UrlSplit         :: ѿ URL ʬ򤷥ե̾ѿ̾
  !                     °̾ϰϻФ
  ! UrlMerge         :: ե̾ѿ̾°̾ϰϻ
  !                     Ϣ뤷ѿ URL 
  ! UrlResolve       :: ѿ URL 䴰
  ! Url_Chop_IOrange :: ѿ URL  iorange 
  ! UrlSearchIORange :: ѿ URL  iorange , 뼡˴ؤ
  !                     ϰϻͤ
  ! dc_url#operator(.OnTheSameFile.) :: 2 Ĥѿ URL
  !                                     ƱեؤɤȽ
  !
  ! Υ⥸塼 gtool4 ѿˤ̤̤
  ! ʸΥˡ˥å󶡤ޤgtool4 ѿϤκݤˤϡ
  ! ľʸѤΤǤϤʤ󶡤ѿ
  ! (GT_ATMARK ) ѤƤ
  !


  implicit none
  private

  public:: Url_Chop_IOrange
  public:: operator(.OnTheSameFile.)

  public:: UrlMerge
  interface UrlMerge
!    module procedure url_merge_v_vvv
    module procedure url_merge_cc
    module procedure url_merge_cccc
    module procedure url_merge_cccca
  end interface

  public:: UrlSplit
  interface UrlSplit
!    module procedure url_split_v
    module procedure url_split_c
  end interface

  public:: UrlResolve
  interface UrlResolve
    module procedure url_resolve_c
  end interface

  public:: UrlSearchIORange
  interface UrlSearchIORange
    module procedure url_search_iorange
  end interface

  interface operator(.OnTheSameFile.)
    module procedure UrlOnTheSameFile
  end interface

  character, public, parameter:: GT_ATMARK = "@"
                                 ! ե̾ѿ̾ζڤѤޤ
  character, public, parameter:: GT_QUESTION = "?"
                                 ! ե̾ѿ̾ζڤѤޤ
  character, public, parameter:: GT_COLON = ":"
                                 ! ѿ°򼨤Ѥޤ
  character, public, parameter:: GT_COMMA = ","
                                 ! ϰϤθѤޤ
  character, public, parameter:: GT_EQUAL = "="
                                 ! ϰϤθѤޤ
  character, public, parameter:: GT_CIRCUMFLEX = "^"
                                 ! ɸΰ֤ͤǤϤʤ
                                 ! ʻֹǻꤹѤޤ
  character, public, parameter:: GT_PLUS = "+"
                                 ! °ιƬˤʸĤ硢°򼨤ޤ

contains

  ! ANUrlMerge - ѿ URL ι
  ! ʸʬϤʤȤߤʤ롣

!  type(VSTRING) function &
!    & url_merge_v_vvv(file, var, attr, iorange) result(result) !:nodoc:
!    use dcstring_base, only: VSTRING, operator(.cat.), operator(/=), &
!      & extract, operator(==) !:nodoc:
!    implicit none
!    type(VSTRING), intent(in):: file
!    type(VSTRING), intent(in), optional:: var
!    type(VSTRING), intent(in), optional:: attr
!    type(VSTRING), intent(in), optional:: iorange
!    result = file .cat. GT_ATMARK
!    if (present(var)) result = result .cat. var
!    if (present(attr)) then
!      if (attr /= "") result = result .cat. GT_COLON .cat. attr
!    endif
!    if (present(iorange)) then
!      if (extract(iorange, 1, 1) == GT_COMMA) then
!        result = result .cat. iorange
!      else if (iorange /= "") then
!        result = result .cat. GT_COMMA .cat. iorange
!      endif
!    endif
!  end function

  function url_merge_cc(file, var) result(result)
    !
    ! ե̾ fileѿ̾ var 礷 relsult Ȥ֤ޤ
    !
    use dc_types, only: STRING
    character(len = STRING):: result
    character(len = *), intent(in):: file
    character(len = *), intent(in):: var
  continue
    result = url_merge_cccc(file, var, "", "")
  end function url_merge_cc

  function url_merge_cccca(file, var, attr, iorange) result(result)
    !
    ! ե̾ fileѿ̾ var° attr
    ! ϰ iorange 礷 relsult Ȥ֤ޤ
    ! iorange ˤʸͿޤʸΤ줾Ǥ
    ! GT_COMMA Ϣ뤵Ƥ礵ޤ
    !
    use dc_types, only: STRING
    character(len = STRING):: result
    character(len = *), intent(in):: file
    character(len = *), intent(in):: var
    character(len = *), intent(in):: attr
    character(len = *), intent(in):: iorange(:)
    integer:: i
  continue
    if (file /= "") then
      result = trim(file) // gt_atmark
    else
      result = gt_atmark
    endif
    if (var /= "") result = trim(result) // var
    if (attr /= "") then
      result = trim(result) // gt_colon // attr
    endif
    do i = 1, size(iorange)
      if (iorange(i) /= "") then
        if (iorange(i)(1:1) == gt_comma) then
          result = trim(result) // trim(iorange(i))
        else
          result = trim(result) // gt_comma // trim(iorange(i))
        endif
      endif
    end do
  end function url_merge_cccca

  function url_merge_cccc(file, var, attr, iorange) result(result)
    !
    ! ե̾ fileѿ̾ var° attr
    ! ϰ iorange 礷 relsult Ȥ֤ޤ
    !
    use dc_types, only: STRING
    character(len = STRING):: result
    character(len = *), intent(in):: file
    character(len = *), intent(in):: var
    character(len = *), intent(in):: attr
    character(len = *), intent(in):: iorange
  continue
    if (trim(file) /= "") then
      result = trim(file) // gt_atmark
    else
      result = gt_atmark
    endif
    if (trim(var) /= "") result = trim(result) // var
    if (trim(attr) /= "") then
      result = trim(result) // gt_colon // attr
    endif
    if (trim(iorange) /= "") then
      if (iorange(1:1) == gt_comma) then
        result = trim(result) // iorange
      else
        result = trim(result) // gt_comma // iorange
      endif
    endif
  end function url_merge_cccc

  subroutine Url_Chop_IOrange(fullname, iorange, remainder)
    !
    ! fullname Ϳѿ URL ϰϻʬ
    ! ĤʬȤʬΥ줾 iorange  remainder ֤ޤ
    !
    use dc_types, only: STRING
    character(len = *), intent(in):: fullname
    character(len = *), intent(out):: iorange   ! ϰϻʬ
    character(len = *), intent(out):: remainder ! Ĥʬ
    character(STRING):: file, var, attr
    call urlsplit(fullname, file=file, var=var, attr=attr, iorange=iorange)
    remainder = url_merge_cccc(file=file, var=var, attr=attr, iorange="")
  end subroutine url_chop_iorange

  function url_search_iorange(fullname, dimvar) result(result)
    !
    ! ѿ URL *fullname* ,  *dimvar* ˴ؤ
    ! ϰϻͤޤ
    !
    ! fullname ˤ gtool4 ѿΤޤϰϻʬͤͿޤ
    ! dimvar ˤϰϻʬ˴ޤޤ뼡ѿ̾Ϳޤ
    ! dimvar б뼡ѿ¸ߤ硢֤ͤޤ
    ! dimvar б뼡ѿ¸ߤʤ硢ʸ֤ޤ
    !
    use dc_types, only: STRING
    use dc_string, only: Split
    character(len = *), intent(in):: fullname
    character(len = *), intent(in):: dimvar
    character(len = STRING):: result
    character(STRING):: file, var, attr, iorange
    character(STRING), pointer :: ioranges_slice(:) => null()
    integer :: i, eqpos, atmark
  continue
    result = ""
    ! @ ޤ ? ޤޤƤʤ urlsplit ʬΥ
    atmark = index(fullname, GT_QUESTION)
    if (atmark == 0) atmark = index(fullname, GT_ATMARK)
    if (atmark /= 0) then
      call urlsplit(fullname, file=file, var=var, attr=attr, iorange=iorange)
    else
      iorange = fullname
    end if
    call Split(iorange, ioranges_slice, GT_COMMA)
    do i = 1, size(ioranges_slice)
      eqpos = index(ioranges_slice(i), GT_EQUAL)
      if (ioranges_slice(i)(1:eqpos-1) == trim(dimvar)) then
        result = trim(ioranges_slice(i)(eqpos+1:))
        exit
      end if
    end do
    deallocate(ioranges_slice)
  end function url_search_iorange

  subroutine url_split_c(fullname, file, var, attr, iorange)
    !
    ! fullname Ϳѿ URL 򡢥ե̾ file ѿ̾ var
    ! °̾ attrϰϻ iorange ʬ򤷤֤ޤ
    ! Ĥʤʬˤ϶ʸޤ
    !
    use dc_types, only: STRING
    character(len = *), intent(in):: fullname
    character(len = *), intent(out), optional:: file, var, attr, iorange
    character(len = STRING):: varpart
    integer:: atmark, colon, comma
    character(len = *), parameter:: VARNAME_SET &
      = "0123456789eEdD+-=^,.:_" &
      // "ABCDEFGHIJKLMNOPQRSTUVWXYZ" &
      // "abcdefghijklmnopqrstuvwxyz"
  continue
    ! ޤ URL ѿ° (? ޤ @ ʹ) ʬΥ롣
    ! URL  @ ޤߤ뤿ᡢǸ @ ʹߤФѿ°
    ! ȤƵʤʸŵŪˤ '/'ˤޤޤƤ
    !  @  URL ΰȤߤʤ
    atmark = index(fullname, GT_QUESTION)
    if (atmark == 0) then
      atmark = index(fullname, GT_ATMARK, back=.TRUE.)
      if (atmark /= 0) then
        if (verify(trim(fullname(atmark+1: )), VARNAME_SET) /= 0) then
          atmark = 0
        endif
      endif
    endif
    if (atmark == 0) then
      ! ѿ°Ϥʤä
      if (present(file)) file = fullname
      if (present(var)) var = ''
      if (present(attr)) attr = ''
      if (present(iorange)) iorange = ''
      return
    endif
    varpart = fullname(atmark+1: )
    ! ѿ°꤬ä
    if (present(file)) file = fullname(1: atmark - 1)
    ! ϰϻõ롣
    comma = index(varpart, GT_COMMA)
    if (comma /= 0) then
      ! ϰϻ꤬ߤĤä
      if (present(var)) var = varpart(1: comma - 1)
      if (present(attr)) attr = ''
      if (present(iorange)) iorange = varpart(comma + 1: )
      return
    endif
    if (present(iorange)) iorange = ''
    ! ϰϻ꤬ʤäΤǡ°̾θ򤹤롣
    colon = index(varpart, GT_COLON)
    if (colon == 0) then
      if (present(var)) var = varpart
      if (present(attr)) attr = ''
      varpart = ''
      return
    endif
    if (present(var)) var = varpart(1: colon - 1)
    if (present(attr)) attr = varpart(colon + 1: )
    varpart = ''
  end subroutine url_split_c

!  subroutine url_split_v(fullname, file, var, attr, iorange) !:nodoc:
!    use dcstring_base, only: VSTRING, operator(.cat.), operator(/=), &
!      & extract, operator(==) !:nodoc:
!    use dc_string
!    implicit none
!    type(VSTRING), intent(in):: fullname
!    type(VSTRING), intent(out), optional::        file, var, attr, iorange
!    type(VSTRING):: varpart
!    integer:: atmark, colon, comma
!    character(len = *), parameter:: VARNAME_SET &
!      = "0123456789eEdD+-=^,.:_" &
!      // "ABCDEFGHIJKLMNOPQRSTUVWXYZ" &
!      // "abcdefghijklmnopqrstuvwxyz"
!  continue
!    ! ޤ URL ѿ° (? ޤ @ ʹ) ʬΥ롣
!    ! URL  @ ޤߤ뤿ᡢǸ @ ʹߤФѿ°
!    ! ȤƵʤʸŵŪˤ '/'ˤޤޤƤ
!    !  @  URL ΰȤߤʤ
!    atmark = vindex(fullname, GT_QUESTION)
!    if (atmark == 0) then
!      atmark = vindex(fullname, GT_ATMARK, .TRUE.)
!      if (atmark /= 0) then
!        varpart = extract(fullname, atmark + 1)
!        if (vverify(varpart, VARNAME_SET) /= 0) then
!          atmark = 0
!        endif
!      endif
!    endif
!    if (atmark == 0) then
!      ! ѿ°Ϥʤä
!      if (present(file)) file = fullname
!      if (present(var)) var = ''
!      if (present(attr)) attr = ''
!      if (present(iorange)) iorange = ''
!      return
!    endif
!    varpart = extract(fullname, atmark + 1)
!    ! ѿ°꤬ä
!    if (present(file)) file = extract(fullname, 1, atmark - 1)
!    ! ϰϻõ롣
!    comma = vindex(varpart, GT_COMMA)
!    if (comma /= 0) then
!      ! ϰϻ꤬ߤĤä
!      if (present(var)) var = extract(varpart, 1, comma - 1)
!      if (present(attr)) attr = ''
!      if (present(iorange)) iorange = extract(varpart, comma + 1)
!      return
!    endif
!    if (present(iorange)) iorange = ''
!    ! ϰϻ꤬ʤäΤǡ°̾θ򤹤롣
!    colon = vindex(varpart, GT_COLON)
!    if (colon == 0) then
!      if (present(var)) var = varpart
!      if (present(attr)) attr = ''
!      varpart = ''
!      return
!    endif
!    if (present(var)) var = extract(varpart, 1, colon - 1)
!    if (present(attr)) attr = extract(varpart, colon + 1)
!    varpart = ''
!  end subroutine url_split_v

  !
  ! === Ʊե˺ܤäƤ뤫ɤȽ ===
  !

  logical function UrlOnTheSameFile(url_a, url_b) result(result)
    !
    ! 1 ܤΰͿѿ URL  2 ܤΰͿ
    ! ѿ URL ȤƱեؤƤ뤫ɤȽꤷޤ
    ! ⤷ƱեǤ <b><tt>.true.</tt></b> 
    ! ۤʤեǤ <b><tt>.false.</tt></b> ֤ޤ
    !
    use dc_string
    use dc_types, only: STRING
    character(len = *), intent(in) :: url_a
    character(len = *), intent(in) :: url_b
    character(len = STRING)        :: filepart_a
    character(len = STRING)        :: filepart_b
    call UrlSplit(url_a, file=filepart_a)
    call UrlSplit(url_b, file=filepart_b)
    result = (filepart_a == filepart_b)
  end function UrlOnTheSameFile

  !
  ! === Х󥯤 ===
  !

  function url_resolve_c(relative, base) result(result)
    !
    ! relative Ϳѿ URL Ǥʤ (ե̾ ѿ̾
    ! °̾ϰϻΤɤ줫̵) ˡ base
    ! 䴰ޤ
    !
    use dc_string, only: StrHead
    use dc_types, only: STRING
    use dc_trace, only: BeginSub, EndSub, DbgMessage
    implicit none
    character(len = *), intent(in):: relative
    character(len = *), intent(in):: base
    character(len = STRING):: result
    integer, parameter:: FILE = 1, VAR = 2, ATTR = 3, IOR = 4
    character(len = STRING):: rel(FILE:IOR), bas(FILE:IOR)
    character(3), parameter:: PATHDELIM = "/:" // achar(94)
    integer:: idir_r, idir_b
  continue
    call BeginSub('urlresolve', 'rel=<%c> base=<%c>', c1=relative, c2=base)
    call UrlSplit(trim(relative), file=rel(FILE), var=rel(VAR), &
      & attr=rel(ATTR), iorange=rel(IOR))
    call DbgMessage('rel -> file=<%c> var=<%c> attr=<%c>', &
      & c1=trim(rel(FILE)), c2=trim(rel(VAR)), &
      & c3=(trim(rel(ATTR)) // '> ior=<' // trim(rel(IOR))))
    call UrlSplit(base, file=bas(FILE), var=bas(VAR), &
      & attr=bas(ATTR), iorange=bas(IOR))
    call DbgMessage('base -> file=<%s> var=<%s> attr=<%s> ior=<%s>', &
      & c1=trim(bas(FILE)), c2=trim(bas(VAR)), &
      & c3=(trim(bas(ATTR)) // '> ior=<' // trim(bas(IOR))))
    ! --- ե̾礯Фñ䤦 ---
    if (rel(FILE) == "") then
      rel(FILE) = bas(FILE)
      if (rel(VAR) == "") &
        & rel(VAR) = bas(VAR)
      result = UrlMerge(file=rel(FILE), var=rel(VAR), &
        & attr=rel(ATTR), iorange=rel(IOR))
      call EndSub('urlresolve', '1 result=%c', c1=trim(result))
      return
    endif
    ! --- Хѥ (ȸ) ե̾ϤΤޤ޻ ---
    if (StrHead(rel(FILE), "file:") &
      & .OR. StrHead(rel(FILE), "http:") &
      & .OR. StrHead(rel(FILE), "ftp:") &
      & .OR. StrHead(rel(FILE), "news:") &
      & .OR. StrHead(rel(FILE), "www") &
      & .OR. StrHead(rel(FILE), "/") &
      & .OR. StrHead(rel(FILE), achar(94)) &
      & .OR. rel(FILE)(2:2) == ":" &
      ) then
      result = relative
      call EndSub('urlresolve', '2 result=%c', c1=trim(result))
      return
    endif
    ! ǥ쥯ȥ̾μФ
    idir_b = scan(bas(FILE), PATHDELIM, back=.TRUE.) 
    if (idir_b == 0) then
      ! ǤʤСʥ顼Ȥ٤⤷̤
      ! Хѥ򤽤Τޤ޻
      result = relative
      call EndSub('urlresolve', '3 result=%c', c1=trim(result))
      return
    endif
    ! ХѥΤۤΥǥ쥯ȥ̾μФ
    idir_r = scan(rel(FILE), PATHDELIM, back=.TRUE.)
    if (idir_r == 0) then
      ! ǤʤΤ
      idir_r = 1
    endif
    result = base(1: idir_b) // relative(idir_r: )
    call EndSub('urlresolve', '4 result=%c', c1=trim(result))
  end function url_resolve_c

end module
