program dc_string_test
  use dc_types, only: STRING
  use dc_string, only: Split, StoA, CPrintf, StriEq, StrInclude
  use dc_trace, only: SetDebug
  use dc_test, only: Compare
  implicit none

  character(STRING), pointer :: carray(:) =>null()
  character(STRING) :: char
  logical :: strieq_check
continue

  call SetDebug

  !
  ! Test for "Split"
  !
  call Split('time=0.0', carray, '=')
  call Compare('Split Test 1', (/'time', '0.0 '/), carray)
  deallocate(carray)

  call Split('  time = 0.0  ', carray, '')
  call Compare('Split Test 2', (/'    ', 'time', '=   ', '0.0 '/), carray)
  deallocate(carray)

  call Split('time=0.0 ||$ x=1.0 ||$ y=hogehoge ', carray, '||$')
  call Compare('Split Test 3', &
    & (/'time=0.0   ', &
    &   ' x=1.0     ', &
    &   ' y=hogehoge'/), &
    & carray)
  deallocate(carray)

  call Split('  time = 0.0  ', carray, '', 2)
  call Compare('Split Test 4', &
    & (/'          ', &
    &   'time = 0.0'/), &
    & carray)
  deallocate(carray)

  call Split('time=0.0,x=1.0,y=0.1,z=10,m=8,l=9 ', carray, ',', 3)
  call Compare('Split Test 5', &
    & (/'time=0.0          ', &
    &   'x=1.0             ', &
    &   'y=0.1,z=10,m=8,l=9'/), &
    & carray)
  deallocate(carray)



  !
  ! Test for "StoA"
  !

  allocate(carray(3))
  carray = StoA('hogehoge', 'foo', 'hero')
  call Compare('StoA Test', &
    & (/'hogehoge', &
    &   'foo     ', &
    &   'hero    '/), &
    & carray)
  deallocate(carray)

  char = CPrintf('%a, %a, %a, %a, %a, %a', &
    & ca=StoA("hogehoge", "foo", "hero", "uni"))
  call Compare('CPrintf Test 1', 'hogehoge, foo, hero, uni, ,', char)

  char = CPrintf('%*a', &
    & ca=StoA("hogehoge", "foo", "hero", "uni"), n=(/4/))
  call Compare('CPrintf Test 2', 'hogehoge, foo, hero, uni', char)

  char = CPrintf('%*d', i=(/1, 2, 4/), n=(/2/))
  call Compare('CPrintf Test 3', '1, 2', char)

  char = CPrintf('%*r', r=(/(/1.0, 2.0, 4.0/)/), n=(/5/))
  call Compare('CPrintf Test 4', '1., 2., 4.,', char)

  char = CPrintf('%*r %*a', r=(/1.0, 2.0, 4.0/), &
    & ca=StoA('hogehoge', 'foo', 'hero', 'uni'), n=(/2,3/))
  call Compare('CPrintf Test 5', '1., 2. hogehoge, foo, hero', char)

  !
  ! Test for "StriEq"
  !
  strieq_check = StriEq('hogehoge', 'HogeHoge')
  call Compare('StriEq Test 1', .true., strieq_check)

  strieq_check = StriEq('foo', 'HogeHoge')
  call Compare('StriEq Test 2', .false., strieq_check)

  !
  ! Test for "StrInclude"
  !
  strieq_check = StrInclude(StoA('aaa', 'BBB', 'ccc'), 'bbb')
  call Compare('StrInclude Test 1', .true., strieq_check)

  strieq_check = StrInclude(StoA('aaa', 'BBB', 'ccc'), 'DDD')
  call Compare('StrInclude Test 2', .false., strieq_check)

end program dc_string_test
