#
#== Fortran90 code generator as macro
#
#Authors::   Yasuhiro MORIKAWA
#Version::   $Id: macro.rb,v 1.6 2006/02/05 08:07:57 morikawa Exp $
#Tag Name::  $Name: gt4f90io-20060908 $
#Copyright:: Copyright (C) GFD Dennou Club, 2005. All rights reserved.
#License::   See link:../COPYRIGHT
#
#These functions are used to generate f90 code files from Ruby code 
#files. They are expected to help ruby code approximates f90 code for
#as long as possible.
#
#[JAPANESE]
#
#δؿ Ruby ǵҤ줿ե뤫 F90 ե
#뤿δؿǤ. δؿˤ, Ǥ F90 ɤ
#ᤤ Ruby Υɤ򵭽ҤǤ뤳ȤԤޤ.
#

#
#== Header Comment
#
def rb2f90_header_comment
  mess = <<-"__EOF__"
! *** Caution!! ***
! 
! This file is generated from "#{File.basename($0.to_s)}" by Ruby #{RUBY_VERSION}.
! Please do not edit this file directly.
!
! [JAPANESE]
!
!  !!! 
!
! Υե "#{File.basename($0.to_s)}"  Ruby #{RUBY_VERSION}
! ˤäƼư줿եǤ.
! ΥեľԽޤ褦ꤤפޤ.
!
__EOF__

  return mess
end

#
#== Local variable section in emacs
#
def rb2f90_emacs_readonly
  mess = "!Local Variables:\n"
  mess << <<-"__EOF__"
!mode: f90
!buffer-read-only: t
!End:
__EOF__
  return mess
end

#
#== An imitation of the ifelse function of m4.
#
#=== Usage
#
#   ifelse(string-1, string-2, equal, [not-equal])
#   ifelse(string-1, string-2, equal, [string-3, string-4, equal, ... [not-equal]])
#
# [JA]
#
#== m4  ifelse ؿϤؿ
#
#=== Ȥ
#
#    ifelse(string-1, string-2, equal, [not-equal])
#    ifelse(string-1, string-2, equal, [string-3, string-4, equal, ... [not-equal]])
# string-1  string-2 , equal ֤. ʤˤ
# not-equal ֤. not-equal ꤵʤˤϲ֤ʤ.
#
# ˤ˾ʬդä뤳ȤǽǤ.
# 3 ܤǤ, string-3  4 ꤵƤ.
# string-1  2 ۤʤ,  string-3  string-4 Ӥ,
# ˤϤθ equal ֤. ʤˤ
# ˸ΰϤ.
#
def ifelse(*all)
  entire = Array.new
  count = -1
  one_set = Array.new(3)
  body = ""
  #  (?)
  # 3 ܿ + 2 ξ, Ǹ1ĤϼΤƤ
  if all.size.modulo(3) == 2 then
    all.pop
  end
  # 3 ܿ + 1 ξ, Ǹ1ĤӻäƤ
  lastitem = Array.new
  if all.size.modulo(3) == 1 then
    lastitem << all.pop
  end
  # ǡ
  all.each{ |item|
    count += 1
    one_set[count.modulo(3)] = item
    if count.modulo(3) == 2 then
      entire << one_set.clone
      one_set.clear
      next
    end
  }
  if !lastitem.empty? then
    entire << lastitem
  end
  entire.each{ |set|
    if set.size == 1 then
      body << set[0].sub(/^\n/, '').chomp
      break
    end
    if set[0] == set[1] then
      body << set[2].sub(/^\n/, '').chomp
      break
    end
  }
  return body.chomp
end

#
#== An imitation of the forloop function in m4-doc.
#
#=== Usage
#
#   forloop(string-1, first, last, string-2)
#
# [JA]
#
#== m4-doc ǾҲ𤵤 forloop ؿϤؿ
#
#=== Ȥ
#
#   forloop(str, first, last, body)
#
# first, last ˤ.
# body  last - first ʸȿ֤. 
# κ, body   str Ʊʸִͤ.
# ִͤ first  last ؤ 1 ĤŤäͤǤ.
#
def forloop(str, first, last, body)
  rbody = ""
  repeated = nil
  for i in first..last
    rbody << "\n" if repeated
    rbody << body.sub(/^\n/, '').gsub(/#{str}/, i.to_s).chomp
    repeated = true
  end
  return rbody.chomp
end

#
#== Function as "for" for macro
#
#=== Usage
#
#   foreach(string-1, first, last, string-2)
#
# [JA]
#
#== ޥŪѤǤ for ؿ
#
#=== Ȥ
#
#   forloop(string-1, first, last, string-2)
#
# first, last ˤ.
# string-2  last - first ʸȿ֤. 
# κ, string-2  string-1 Ʊʸִͤ.
# ִͤ first  last ؤ 1 ĤŤäͤǤ.
#
def foreach(str, *words)
  return if words.size < 2
  body = "#{words[words.size - 1]}"
  words.pop
  rbody = ""
  repeated = nil
  words.each{ |word|
    rbody << "\n" if repeated
    rbody << body.sub(/^\n/, '').gsub(/#{str}/, word.to_s).chomp
    repeated = true
  }
  return rbody.chomp
end

#
#== Output (:), or (:,:) or ... in array definition
#
#=== Usage
#
#   array_colon(num)
#
# [JA]
#
#== κݤ (:), (:,:), ... Ϥؿ
#
#=== Ȥ
#
#   array_colon(num)
#
# num . 0 ʤвϤ, 1 ʤ (:), 
# 2 ʤ (:,:), ... ȽϤ.
#
def array_colon(num)
  return unless num
  int = num.to_i
  return if int < 1
  return "(:)" if int < 2
  int -= 1
  body = "(:"
  int.times{
    body << ",:"
  }
  body << ")"
  return body
end
