!
!= ʸ°
!
! Authors::   Eizi TOYODA, Yasuhiro MORIKAWA
! Version::   $Id: gtvargetattrsc.f90,v 1.4 2006/07/17 15:46:47 morikawa Exp $
! Tag Name::  $Name: gt4f90io-20060908 $
! Copyright:: Copyright (C) GFD Dennou Club, 2000-2005. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
! ʲΥ֥롼, ؿ gtdata_generic 󶡤ޤ
!

subroutine GTVarGetAttrCC(var, name, value, default)
  !--
  ! character Ǽ̾ʸƱ͡
  ! ¦ѿĹ˹碌ڤΤơԤ
  ! °¸ߤʤ default ͤȤ
  !++

  use gtdata_types, only: GT_VARIABLE
  use gt_map, only: var_class, vtb_class_netcdf, vtb_class_memory
  use an_generic, only: get_attr, an_variable
  use gt_mem, only: mem_variable, get_attr
  use dc_trace, only: beginsub, endsub
  use dc_types, only: string
  implicit none
  type(GT_VARIABLE), intent(in):: var
  character(len = *), intent(in):: name
  character(len = *), intent(out):: value
  character(len = *), intent(in), optional:: default
  logical:: err
  integer:: class, cid, stat
  character(len = string):: p_default
  character(len = *), parameter:: subnam = "gtvargetattrcc"
continue
  call beginsub(subnam)
  call var_class(var, class, cid)
  p_default = ""
  if (present(default)) p_default = default
  if (class == vtb_class_netcdf) then
    call get_attr(an_variable(cid), name, value, p_default, stat)
  else if (class == vtb_class_memory) then
    call get_attr(mem_variable(cid), name, value, err)
    if (err) value = p_default
  endif
  call endsub(subnam, "%d:%d:%c = %c", i=(/class, cid/), &
    & c1=trim(name), c2=trim(value))
end subroutine GTVarGetAttrCC


!subroutine GTVarGetAttrSC(var, name, value, default)
!  use dc_string, only: VSTRING, assignment(=), vchar, len
!  use dc_types, only: STRING
!  use gtdata_types, only: GT_VARIABLE
!  use gt_map, only: var_class, vtb_class_netcdf, vtb_class_memory
!  use an_generic, only: get_attr, an_variable
!  use gt_mem, only: mem_variable, get_attr
!  use dc_trace, only: beginsub, endsub
!  implicit none
!  type(GT_VARIABLE), intent(in):: var
!  character(len = *), intent(in):: name
!  type(VSTRING), intent(out):: value
!  character(len = *), intent(in), optional:: default
!  logical:: err
!  integer:: class, cid, stat
!  character(len = string):: buffer
!  character(len = string):: p_default
!  character(len = *), parameter:: subnam = "gtvargetattrsc"
!continue
!  call beginsub(subnam)
!  call var_class(var, class, cid)
!  p_default = ""
!  if (present(default)) p_default = default
!  if (class == vtb_class_netcdf) then
!    call get_attr(an_variable(cid), name, buffer, p_default, stat)
!  else if (class == vtb_class_memory) then
!    call get_attr(mem_variable(cid), name, buffer, err)
!    if (err) buffer = p_default
!  endif
!  value = trim(buffer)
!  call endsub(subnam, "%d:%d:%c = %c", i=(/class, cid/), &
!    & c1=trim(name), c2=trim(buffer))
!end subroutine GTVarGetAttrSC

