!------------------------------------------------------------------------
! Copyright (c) 2005-2011 SPMODEL Development Group. All rights reserved.
!------------------------------------------------------------------------
!
!ɽ  ee_module ƥȥץ (䥳ӥ׻)
!
!  2005/07/19  ݹ
!      2007/11/09  ݹ  顼åɲ
!      2011/02/15  ʿ dc_test Ȥ褦ѹ
!
program ee_test_jacobian

  use dc_message, only : MessageNotify
  use dc_test, only : AssertEqual
  use ee_module
  implicit none

 !---- ֲ ----
  integer, parameter :: im=16, jm=16            ! ʻ(X,Y)
  integer, parameter :: km=5, lm=5              ! ȿ(X,Y)

 !---- ѿ ----
  real(8)            :: yx_A(0:jm-1,0:im-1)     ! ʻҥǡ
  real(8)            :: yx_B(0:jm-1,0:im-1)     ! ʻҥǡ
  real(8)            :: yx_Jacob(0:jm-1,0:im-1)  ! ʻҥǡ

  integer            :: k=4,l=2

 !---- ɸѿʤ ----
  real(8), parameter :: xmin = -1.0d0, xmax=1.0d0
  real(8), parameter :: ymin = -1.0d0, ymax=1.0d0

  real(8), parameter :: pi=3.1415926535897932385D0
  ! Ƚ
  integer, parameter :: check_digits = 10
  integer, parameter :: ignore = -11

  call MessageNotify('M','ee_test_jacobian', &
       'ee_module jacobian function tests')

 !---------------- ɸͤ ---------------------
  call ee_initial(im,jm,km,lm,xmin,xmax,ymin,ymax)    ! ڥȥ

 !-------------------  ----------------------

!!$  write(6,*) '  Input wavenumbers of the grid data, k and l :'
!!$  read(5,*) k,l
!!$  write(6,*) '  k,l = ', k,l

  yx_A = sin(k*pi*yx_X)
  yx_B = sin(l*pi*yx_Y)
  yx_Jacob = k*pi*cos(k*pi*yx_X) * l*pi*cos(l*pi*yx_Y)

  call check2d(yx_ee(ee_Jacobian_ee_ee(ee_yx(yx_A),ee_yx(yx_B))), yx_Jacob, &
    'Jacob(sin(k*pi*X),sin(l*pi*Y))')

  yx_A = cos(k*pi*yx_X)
  yx_B = cos(l*pi*yx_Y)
  yx_Jacob = k*pi*sin(k*pi*yx_X) * l*pi*sin(l*pi*yx_Y)

  call check2d(yx_ee(ee_Jacobian_ee_ee(ee_yx(yx_A),ee_yx(yx_B))), yx_Jacob, &
    'Jacob(cos(k*pi*X),cos(l*pi*Y))')

  yx_A = sin(k*pi*yx_X)
  yx_B = cos(l*pi*yx_Y)
  yx_Jacob = - k*pi*cos(k*pi*yx_X) * l*pi*sin(l*pi*yx_Y)

  call check2d(yx_ee(ee_Jacobian_ee_ee(ee_yx(yx_A),ee_yx(yx_B))), yx_Jacob, &
    'Jacob(sin(k*pi*X),cos(l*pi*Y))')

  yx_A = cos(k*pi*yx_X)
  yx_B = sin(l*pi*yx_Y)
  yx_Jacob = - k*pi*sin(k*pi*yx_X) * l*pi*cos(l*pi*yx_Y)

  call check2d(yx_ee(ee_Jacobian_ee_ee(ee_yx(yx_A),ee_yx(yx_B))), yx_Jacob, &
    'Jacob(cos(k*pi*X),sin(l*pi*Y))')

  call MessageNotify('M','ee_test_derivative', &
       'ee_module jacobian function tests succeeded!')

contains

  subroutine check2d(var,sol,funcname) ! ͤ eps ʾ var Ǥ
    real(8) :: var(:,:)                ! Ƚꤹ
    real(8) :: sol(:,:)
    character(len=*) :: funcname

    call AssertEqual(     &
      message = funcname, &
      answer = sol,       &
      check = var,        &
      significant_digits = check_digits, ignore_digits = ignore     )

  end subroutine check2d

end program ee_test_jacobian
