!--
!----------------------------------------------------------------------
!     Copyright (c) 2002 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!ɽ  w_integral_module
!
!  spml/w_integral_module ⥸塼ϵ̾Ǥ 2 ήαư
!  ĴȡѤڥȥˡˤäƿͷ׻뤿 
!  ⥸塼 w_module β⥸塼Ǥ, 
!  ʬʿѷ׻Τ Fortran90 ؿ󶡤. 
!
!   ISPACK  SPPACK  SNPACK  Fortran77 ֥롼ƤǤ. 
!  ڥȥǡӳʻǡγǼˡѴξܤ׻ˡ
!  ĤƤ ISPACK/SNPACK,SPPACK Υޥ˥奢򻲾Ȥ줿.
!
!
!  2002/05/25  ݹ 
!      2006/03/08  ݹ  Ȥ RDoc Ѥ˽
!      2008/02/23  ʿ ʻǡ(im,jm) 
!                             (0:im-1, 0:jm-1)ѹ.
!      2008/06/25  ʿ ʻǡ(0:im-1,0:jm-1) 
!                             (0:im-1, 1:jm)ѹ.
!      2008/07/01  ʿ Ȥ RDoc Ѥ
!      2009/01/29  ʿ Ȥ RDoc Ѥ
!
!--
module w_integral_module
  !
  != w_integral_module
  !
  ! Authors:: Shin-ichi Takehiro, Youhei SASAKI
  ! Version:: $Id: w_integral_module.f90 590 2013-08-19 08:48:21Z uwabami $
  ! Copyright&License:: See COPYRIGHT[link:../COPYRIGHT]
  !
  !== 
  !
  ! spml/w_integral_module ⥸塼ϵ̾Ǥ 2 ήαư
  ! ĴȡѤڥȥˡˤäƿͷ׻뤿 
  ! ⥸塼 w_module β⥸塼Ǥ, 
  ! ʬʿѷ׻Τ Fortran90 ؿ󶡤. 
  !
  !  ISPACK  SPPACK  SNPACK  Fortran77 ֥롼ƤǤ. 
  ! ڥȥǡӳʻǡγǼˡѴξܤ׻ˡ
  ! ĤƤ ISPACK/SNPACK,SPPACK Υޥ˥奢򻲾Ȥ줿.
  !
  use w_base_module, only : im, jm, x_Lon_Weight, y_Lat_Weight

  implicit none

  private
 
  public IntLonLat_xy                      ! ٷʬ
  public y_IntLon_xy, IntLon_x             ! ʬ    
  public x_IntLat_xy, IntLat_y             ! ʬ    
  public AvrLonLat_xy                      ! ٷʿ
  public y_AvrLon_xy, AvrLon_x             ! ʿ    
  public x_AvrLat_xy, AvrLat_y             ! ʿ    

  contains

  !--------------- ʬ׻ -----------------
    function IntLat_y(y_data)
      !
      ! 1 (Y)ʻǡ Y ʬ(1 ).
      !
      ! ºݤˤϳʻǡ y_Y_Weight 򤫤¤׻Ƥ. 
      !
      real(8), intent(in) :: y_data(1:jm)  !(in)  1 (Y)ʻǡ
      real(8)             :: IntLat_y        !(out) ʬ

      IntLat_y = sum(y_data * y_Lat_weight)

    end function IntLat_y

    function IntLon_x(x_data)
      !
      ! 1 (X)ʻǡ X ʬ(1 ).
      !
      ! ºݤˤϳʻǡ x_X_Weight 򤫤¤׻Ƥ.
      !
      real(8), intent(in) :: x_data(0:im-1)   !(in)  1 (X)ʻǡ
      real(8)             :: IntLon_x     !(out) ʬ

      IntLon_x = sum(x_data * x_Lon_weight)

    end function IntLon_x

    function x_IntLat_xy(xy_data)
      !
      ! 2 ٷٳʻǡΰ(Y)ʬ(1 ).
      !
      ! ºݤˤϳʻǡ y_Y_Weight 򤫤¤׻Ƥ. 
      !
      real(8), intent(in) :: xy_data(0:im-1,1:jm)           
      !(in) 2 ٰٳʻǡ(0:im-1,1:jm)

      real(8)             :: x_IntLat_xy(0:im-1) 
      !(out) ʬ줿 1 (X)ʻǡ

      integer :: j

      x_IntLat_xy = 0.0D0
      do j=1,jm
         x_IntLat_xy = x_IntLat_xy + xy_data(:,j) * y_Lat_weight(j)
      enddo

    end function x_IntLat_xy

    function y_IntLon_xy(xy_data)
      !
      ! 2 ٷٳʻǡη(X)ʬ(1 ).
      !
      ! ºݤˤϳʻǡ x_X_Weight 򤫤¤׻Ƥ. 
      !
      real(8), intent(in) :: xy_data(0:im-1,1:jm)
      !(in) 2 ٰٳʻǡ(0:im-1,1:jm)

      real(8)             :: y_IntLon_xy(1:jm)
      !(out) ʬ줿 1 (Y)ʻǡ

      integer :: i

      y_IntLon_xy = 0.0D0
      do i=0,im-1
         y_IntLon_xy = y_IntLon_xy + xy_data(i,:) * x_Lon_weight(i)
      enddo

    end function y_IntLon_xy

    function IntLonLat_xy(xy_data)
      !
      ! 2 ٷٳʻǡΰʬ(1 ). 
      !
      ! ºݤˤϳʻǡ x_X_Weight, y_Y_Weight 򤫤
      ! ¤׻Ƥ. 
      !
      real(8), intent(in)   :: xy_data(0:im-1,1:jm)         
      !(in) 2 ٰٳʻǡ(0:im-1,1:jm)

      real(8) :: IntLonLat_xy                         
      !(out) ʬ

      IntLonLat_xy = IntLon_x(x_IntLat_xy(xy_data))

    end function IntLonLat_xy

  !--------------- ʿѷ׻ -----------------
    function AvrLat_y(y_data)
      !
      ! 1 (Y)ʻǡΰ(Y)ʿ(1 ).
      !
      ! ºݤˤϳʻǡ y_Y_Weight 򤫤¤׻, 
      ! y_Y_Weight ¤ǳ뤳ȤʿѤƤ. 
      !
      real(8), intent(in) :: y_data(1:jm)         
      !(in)  1 ٳʻǡ
      real(8)             :: AvrLat_y            
      !(out) ʿ

      AvrLat_y = IntLat_y(y_data)/sum(y_Lat_weight)

    end function AvrLat_y

    function AvrLon_x(x_data)
      !
      ! 1 (X)ʻǡη(X)ʿ(1 ).
      !
      ! ºݤˤϳʻǡ x_X_Weight 򤫤¤׻, 
      ! x_X_Weight ¤ǳ뤳ȤʿѤƤ. 
      !
      real(8), intent(in) :: x_data(0:im-1)
      !(in)  1 (X)ʻǡ
      real(8)             :: AvrLon_x       
      !(out) ʿ

      AvrLon_x = IntLon_x(x_data)/sum(x_Lon_weight)

    end function AvrLon_x


    function x_AvrLat_xy(xy_data)
      !
      ! 2 ٷٳʻǡΰ(Y)ʿ(1 ).
      !
      ! ºݤˤϳʻǡ y_Y_Weight 򤫤¤׻, 
      ! y_Y_Weight ¤ǳ뤳ȤʿѤƤ. 
      !
      real(8), intent(in) :: xy_data(0:im-1,1:jm)
      !(in) 2 ٰٳʻǡ(0:im-1,1:jm)
      real(8)             :: x_AvrLat_xy(im)
      !(out) ʿѤ줿 1 (X)ʻǡ

      x_AvrLat_xy = x_IntLat_xy(xy_data)/sum(y_Lat_weight)

    end function x_AvrLat_xy

    function y_AvrLon_xy(xy_data)
      !
      ! 2 ٷٳʻǡη(X)ʿ(1 ).
      !
      ! ºݤˤϳʻǡ x_X_Weight 򤫤¤׻, 
      ! x_X_Weight ¤ǳ뤳ȤʿѤƤ. 
      !
      real(8), intent(in) :: xy_data(0:im-1,1:jm)
      !(in) 2 ٰٳʻǡ(0:im-1,1:jm)
      real(8)             :: y_AvrLon_xy(1:jm)
      !(out) ʿѤ줿 1 (Y)ʻ

      y_AvrLon_xy = y_IntLon_xy(xy_data)/sum(x_Lon_weight)

    end function y_AvrLon_xy


    function AvrLonLat_xy(xy_data)
      !
      ! 2 ٷٳʻǡΰʿ(1 ).
      !
      ! ºݤˤϳʻǡ x_X_Weight, y_Y_Weight 򤫤
      ! ¤׻, x_X_Weight*y_Y_Weight ¤ǳ뤳ȤʿѤƤ. 
      !
      real(8), intent(in)   :: xy_data(0:im-1,1:jm)
      !(in) 2 ٰٳʻǡ

      real(8) :: AvrLonLat_xy
      !(out) ʿ

      AvrLonLat_xy = AvrLon_x(x_AvrLat_xy(xy_data))

    end function AvrLonLat_xy


  end module w_integral_module
