!----------------------------------------------------------------------
!     Copyright (c) 2011--2012 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  wq_module_sjpack ƥȥץ
!
!      ȥݥƥ󥷥ζ
!
!  2011/09/09  ݹ   wq_module_torvelbc_test.f90  MPI 
!      2011/09/12  ݹ   wtq_mpi_module Ѥ˲¤
!      2012/04/02  ݹ   wtq_mpi_module_sjpack Ѥ˲¤
!      2012/04/03  ݹ   wtq_module_sjpack Ѥ˲¤
!
program wtq_module_sjpack_torvelbc_wq

  use dc_message, only : MessageNotify
  use dc_test, only : AssertEqual
  use wtq_module_sjpack

  implicit none

  integer,parameter  :: im=32, jm=16         ! ʻ(, , ư)
  integer,parameter  :: kmo=16, kmi=10       ! ʻ(ư, ư)
  integer,parameter  :: nm=10                ! ȿ(ʿ)
  integer,parameter  :: lmo=10, lmi=16       ! ȿ(ư, ư)
  real(8),parameter  :: ri=0.5, ro=1.5       ! ⳰Ⱦ

  real(8), dimension(0:im-1,1:jm,kmi)       :: xyr_TorVel0
  real(8), dimension(0:im-1,1:jm,kmi)       :: xyr_TorVel
  real(8), dimension((nm+1)*(nm+1),0:lmi)   :: wq_TorVel
  real(8), dimension((nm+1)*(nm+1),0:lmi)   :: wq_TorVel0
  real(8), dimension((nm+1)*(nm+1),kmi)     :: wr_TorVel
  character(len=1), dimension(2),parameter :: BCond=(/'F','R'/)

  real(8), dimension(0:im-1,1:jm,kmi)       :: xyr_True
  real(8), dimension(0:im-1,1:jm,kmi)       :: xyr_Zero=0.0D0

  ! Ƚ
  integer, parameter :: check_digits = 12
  integer, parameter :: ignore = -13

  integer :: ll

  call MessageNotify('M','wtq_module_sjpack_torvelbc_wq_test', &
       'wtq_module_sjpack wq_TorvelBoundary subroutine test')

  call wtq_Initial(im,jm,kmi,kmo,nm,lmi,lmo,ri,ro)

  do ll=1,2

     ! P_10
     !xyr_TorVel = sin(xyr_lat) * cos( pi*(xyr_rad-ri)/(ro-ri) )
     ! P_1_1
     !xyr_TorVel = cos(xyr_lat)*cos(xyr_lon)* cos( pi*(xyr_rad-ri)/(ro-ri) )
     xyr_TorVel = 2*sin(xyr_lat)**2 * (xyr_rad-ri)**2 * xyr_Rad**2

     xyr_TorVel0 = xyr_TorVel
     wq_TorVel = wq_xyr(xyr_TorVel)
     wq_TorVel0 = wq_TorVel  
     wr_TorVel = wr_xyr(xyr_TorVel)


     !---- wq_TorBoundary test
     call wq_TorBoundary(wq_TorVel,cond=BCond(ll),new=.true.)
     xyr_TorVel = xyr_wq(wq_TorVel)

     call AssertEqual(&
          message='wq_TorvelgBoundary (internal value)',                &
          answer = wq_Torvel(:,0:lmi-2),                                 &
          check = wq_Torvel0(:,0:lmi-2),                                 &
          significant_digits = check_digits, ignore_digits = ignore     &
       )

     ! üå
     if( BCond(ll) == 'F' ) then
        xyr_True = xyr_wq(wq_RadDRad_wq(wq_Torvel)- wq_Torvel)/xyr_Rad
     else
        xyr_True = xyr_TorVel
     endif

     call AssertEqual(&
          message='wq_TorlBoundary (Top boundary)',                     &
          answer = xyr_True(:,:,kmi),                                    &
          check = xyr_Zero(:,:,kmi),                                     &
          significant_digits = check_digits, ignore_digits = ignore     &
          )

     call MessageNotify('M','wq_module_sjpack_torvelbc_test', &
          'wq_TorBoundarry: '//BCond(ll)//'-Top B.C. test succeeded!')


     !---- wr_TorBoundaryGrid test
     call wr_TorBoundaryGrid(wr_TorVel,cond=BCond(ll),new=.true.)
     xyr_TorVel = xyr_wr(wr_TorVel)
     wq_TorVel = wq_wr(wr_TorVel)

     ! å
     xyr_True = xyr_TorVel - xyr_TorVel0

     call AssertEqual(&
          message='wq_TorBoundary (internal value)',                    &
          answer = xyr_Torvel(:,:,1:kmi-1),                              &
          check = xyr_Torvel0(:,:,1:kmi-1),                              &
          significant_digits = check_digits, ignore_digits = ignore     &
       )

     ! üå
     if( BCond(ll) == 'F' ) then
        xyr_True = xyr_wq(wq_RadDRad_wq(wq_Torvel)- wq_Torvel)/xyr_Rad
     else
        xyr_True = xyr_TorVel
     endif

     call AssertEqual(&
          message='wq_TorlBoundaryGrid (Top Booundary)',                &
          answer = xyr_True(:,:,kmi),                                    &
          check = xyr_Zero(:,:,kmi),                                     &
          significant_digits = check_digits, ignore_digits = ignore     &
          )

     call MessageNotify('M','wq_module_sjpack_torvelbc_test', &
          'wq_TorBoundaryGrid: '//BCond(ll)//'-Top B.C. test succeeded!')
          
  enddo

  call MessageNotify('M','wtq_module_sjpack_torvelbc_wq_test', &
       'wtq_module_sjpack wq_TorvelBoundary subroutine test succeeded!')

end program wtq_module_sjpack_torvelbc_wq
