!--
!----------------------------------------------------------------------
!     Copyright (c) 2011 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  ʣǸͭꥵ֥롼 (SSL2TP)
!
!  2011/11/08  ݹ
!
!++
module ssl2tp_ceigen
  !
  != ssl2tp_ceigen
  !
  ! Authors:: Shin-ichi Takehiro, Youhei SASAKI
  ! Version:: $Id: 
  ! Copyright&License:: See COPYRIGHT[link:../COPYRIGHT]
  ! 
  !== 
  !
  ! spml/ssl2tp_ceigen  eigmatrix ⥸塼θ֥롼 ceigen
  ! Ѥθͭͷ׻Ѷ̥󥿡եͿ.
  !
  !   *  CMAT  i ܸͭͤ eigen(i) ˳Ǽ
  !   * бͭ٥ȥ eigvec(:,i) ˳Ǽ
  !   * Ǽͭͤοϰ eigen 礭Ƿޤ
  !   * ͭͤν֤ sort  order . 
  !   * sort ˤäƽ֤뤿Ѥ̤ꤹ. 
  !     (R), (RA), (I), (IA)
  !   * reverse ˤäƾ(.false.), 礭(.true.)Ǥ.
  !   * ǥեȤ sort='R', reverse=.false.
  !   *  CMAT ¸ʤ.
  !
  ! Ǥ DM_*/SSL2TP 롼ˤʣǹθͭ/ͭ٥ȥ׻
  ! ԤäƤ. , 桼ѤƤ饤֥ȥ֥롼ռ
  ! 뤳ȤʤȤȤǤ. 
  use dc_message, only : MessageNotify

  implicit none
  private
  public dm_ceigen_ssl2tp

contains
  subroutine dm_ceigen_ssl2tp(cmat,eigen,eigvec,info,sort,reverse)
    !
    ! Υ֥롼ϸͭͷ׻Ѷ̥󥿡եͿ
    ! eigmatrix ⥸塼θ֥롼 ceigen ȤѤ. 
    !
    !   *  CMAT  i ܸͭͤ eigen(i) ˳Ǽ
    !   * бͭ٥ȥ eigvec(:,i) ˳Ǽ
    !   * Ǽͭͤοϰ eigen 礭Ƿޤ
    !   * ͭͤν֤ sort  order . 
    !   * sort ˤäƽ֤뤿Ѥ̤ꤹ. 
    !     (R), (RA), (I), (IA)
    !   * reverse ˤäƾ(.false.), 礭(.true.)Ǥ.
    !   * ǥեȤ sort='R', reverse=.false.
    !   *  CMAT ¸ʤ.
    !
    ! Ǥ DM_*/SSL2TP 롼ˤʣǹθͭ/ͭ٥ȥ׻
    ! ԤäƤ. , 桼ѤƤ饤֥ȥ֥롼ռ
    ! 뤳ȤʤȤȤǤ. 
    !
    interface 
       function indexx(arrin)
         implicit none
         real(8), dimension(:), intent(in)  :: arrin
         integer, dimension(size(arrin))    :: indexx
       end function indexx
    end interface

   !------------  ------------
    complex(8), dimension(:,:)                :: cmat      ! 
    complex(8), intent(out), dimension(:)     :: eigen     ! ͭͼ¿
    complex(8), intent(out), &
      dimension(size(cmat,1),size(eigen))     :: eigvec    ! ͭ٥ȥ
    integer, intent(out)                      :: info      ! ơ
    character(len=2), intent(in), optional    :: sort      ! ¤Ѥ
    logical, intent(in), optional             :: reverse   ! ¤Ѥå

   !------------ ѿ ------------
    complex(8), dimension(size(cmat,1),size(cmat,1)) :: cmatrix ! ¸
    complex(8), dimension(size(cmat,1))              :: ceig  ! ͭ
    complex(8), dimension(size(cmat,1),size(cmat,1)) :: cvec  ! ͭ٥ȥ

    real(8), dimension(size(cmat,1))                 :: dv    ! ѿ
    integer, dimension(size(cmat,1))                 :: ip    ! ѿ
    integer, dimension(size(cmat,1))                 :: ind   ! ѿ
    complex(8), dimension(size(cmat,1),size(cmat,1)+1) :: zaw   ! ѿ

    integer, dimension(size(cmat,1))                 :: index ! ¤Ѥ
    integer, parameter :: mode=0   ! DCEIG1Ϥå(ʿղά)

    integer :: nm, i, j, neig

    !------- å ------
    if (size(cmat,1) /= size(cmat,2))then
       call MessageNotify('E','DM_CEIGEN_SSL2','Input matrix not square')
    else
       nm = size(cmat,1)
    endif

    !------- DM_*/SSL2TP ˤ׻ ------
    call dm_cblnc(cmat, nm, nm, dv, info)
    if ( info .eq. 30000 ) then
       call MessageNotify('E','DM_CEIGEN_SSL2TP','Error in DM_CBLNC')
       return
    end if

    call dm_ches2(cmat, nm, nm, ip, info)

    cmatrix = cmat

    call dchsqr(cmat, nm, nm, ceig, neig, info)
    if ( info .eq. 15000 ) then
       call MessageNotify('E','DM_CEIGEN_SSL2TP', &
            'Eigenvalue not completely obtaind in DCHSQR')
       return
    else if ( info .ge. 20000 ) then
       call MessageNotify('E','DM_CEIGEN_SSL2TP','Error in DM_CHSQR')
       return
    end if

    ind = 1

    call dm_chvec(cmatrix, nm, nm, ceig, ind, neig, cvec, zaw, info)
    if ( info .ge. 15000 ) then
       call MessageNotify('E','DM_CEIGEN_SSL2TP', &
            'Eigenvector not completely obtaind in DM_CHVEC')
       return
    else if ( info .ge. 20000 ) then
       call MessageNotify('E','DM_CEIGEN_SSL2TP','Error in DM_CHSQR')
       return
    end if

    call dm_chbk2(cvec, nm, nm, ind, neig, cmat, ip, dv, info)
    call dm_cnrml(cvec, nm, nm, ind, neig, 1, info)

    !------- ͭ٥ȥ촹 -------
    if ( present(sort) ) then
       if ( sort == 'RA' ) then          ! ͭͼ
          index=indexx(abs(dble(ceig)))
       elseif ( trim(sort) == 'I' ) then ! ͭ͵
          index=indexx(dimag(ceig))
       elseif ( sort == 'IA' ) then      ! ͭ͵
          index=indexx(abs(dimag(ceig)))
       else
          index=indexx(dble(ceig))       ! defaultϸͭͼ
       endif
    else
       index=indexx(dble(ceig))          ! defaultϸͭͼ
    endif

    if ( present(reverse) )then
       if ( reverse ) then               ! 礭
          index=index(size(index):1:-1)
       endif
    endif

    do i=1,size(eigen)
       j = index(i)
       eigen(i) = ceig(j)
       eigvec(:,i) = cvec(:,j)
    enddo
    
  end subroutine dm_ceigen_ssl2tp

end module ssl2tp_ceigen
