!--
!----------------------------------------------------------------------
!     Copyright (c) 2011 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!ɽ  wa_integral_module_sjpack_cuda
!
!  spml/wa_integral_module_sjpack_cuda ⥸塼ϵ̾Ǥήαư
!  ĴȡѤڥȥˡˤäƿͷ׻뤿 
!  ⥸塼 wa_module_sjpack_cuda β⥸塼Ǥ, 
!  ʬʿѷ׻Τ Fortran90 ؿ󶡤. 
!
!  ̾ 1 إǥ w_integral_module_sjpack_cuda ⥸塼
!  ¿إǥѤ˳ĥΤǤ, ƱʣĤΥڥȥǡ, 
!  ʻǡФѴԤ.
!
!   ISPACK  SJPACK  Fortran77 ֥롼ƤǤ. 
!  ڥȥǡӳʻǡγǼˡѴξܤ׻ˡ
!  ĤƤ ISPACK/SJPACK Υޥ˥奢򻲾Ȥ줿.
!
!
!  2011/03/12  ݹ wa_integral_module_sjpack  CUDA Ѥ˲¤
!
!++
module wa_integral_module_sjpack_cuda
  !
  != wa_integral_module_sjpack_cuda
  !
  ! Authors:: Shin-ichi Takehiro, Youhei SASAKI
  ! Version:: $Id: wa_integral_module_sjpack_cuda.f90 590 2013-08-19 08:48:21Z uwabami $
  ! Copyright&License:: See COPYRIGHT[link:../COPYRIGHT]
  !
  !== 
  !
  !  spml/wa_integral_module_sjpack_cuda ⥸塼ϵ̾Ǥήαư
  !  ĴȡѤڥȥˡˤäƿͷ׻뤿 
  !  ⥸塼 wa_module_sjpack_cuda β⥸塼Ǥ, 
  !  ʬʿѷ׻Τ Fortran90 ؿ󶡤. 
  !
  !  ̾ 1 إǥ w_integral_module_sjpack_cuda ⥸塼
  !  ¿إǥѤ˳ĥΤǤ, ƱʣĤΥڥȥǡ, 
  !  ʻǡФѴԤ.
  !
  !   ISPACK  SJPACK  Fortran77 ֥롼ƤǤ. 
  !  ڥȥǡӳʻǡγǼˡѴξܤ׻ˡ
  !  ĤƤ ISPACK/SJPACK Υޥ˥奢򻲾Ȥ줿.
  !
  !
  use w_base_module_sjpack_cuda, only : im, jm, x_Lon_Weight, y_Lat_Weight
  implicit none

  private

  public a_IntLonLat_xya                      ! ٷʬ
  public ya_IntLon_xya, a_IntLon_xa           ! ʬ    
  public xa_IntLat_xya, a_IntLat_ya           ! ʬ    
  public a_AvrLonLat_xya                      ! ٷʿ
  public ya_AvrLon_xya, a_AvrLon_xa           ! ʿ    
  public xa_AvrLat_xya, a_AvrLat_ya           ! ʿ    

  contains

  !--------------- ʬ׻ -----------------
    function a_IntLonLat_xya(xya_data)
      !
      ! 2 ٷٳʻǡΰʬ(¿). 
      !
      ! ºݤˤϳʻǡ x_X_Weight, y_Y_Weight 򤫤
      ! ¤׻Ƥ. 
      !
      real(8), intent(in)   :: xya_data(0:,:,:)
      !(in) 2 ٰٳʻǡ¤(0:im-1,1:jm,*)
      real(8) :: a_IntLonLat_xya(size(xya_data,3))
      !(out) ʬ줿ǡ¤(*)

      a_IntLonLat_xya = a_IntLon_xa(xa_IntLat_xya(xya_data))

    end function a_IntLonLat_xya

    function xa_IntLat_xya(xya_data)
      !
      ! 2 ٷٳʻǡΰ(Y)ʬ(¿).
      !
      ! ºݤˤϳʻǡ y_Y_Weight 򤫤¤׻Ƥ. 
      !
      real(8), intent(in) :: xya_data(0:,:,:)
      !(in) 2 ٰٳʻǡ¤(0:im-1,1:jm,*)
      real(8)             :: xa_IntLat_xya(0:im-1,size(xya_data,3))
      !(out) ʬ줿 1 (X)ʻǡ¤
      Integer :: j

      xa_IntLat_xya = 0.0D0
      do j=1,jm
         xa_IntLat_xya = xa_IntLat_xya + xya_data(:,j,:) * y_Lat_Weight(j)
      enddo

    end function xa_IntLat_xya

    function ya_IntLon_xya(xya_data)
      !
      ! 2 ٷٳʻǡη(X)ʬ(¿).
      !
      ! ºݤˤϳʻǡ x_X_Weight 򤫤¤׻Ƥ. 
      !
      real(8), intent(in) :: xya_data(0:,:,:)
      !(in) 2 ٰٳʻǡ¤(0:im-1,1:jm,*)

      real(8)             :: ya_IntLon_xya(1:jm,size(xya_data,3))
      !(out) ʬ줿 1 (Y)ʻǡ¤

      integer :: i

      ya_IntLon_xya = 0.0D0
      do i=0,im-1
         ya_IntLon_xya = ya_IntLon_xya + xya_data(i,:,:) * x_Lon_Weight(i)
      enddo

    end function ya_IntLon_xya

    function a_IntLat_ya(ya_data)
      !
      ! 1 (Y)ʻǡ Y ʬ(¿).
      !
      ! ºݤˤϳʻǡ y_Y_Weight 򤫤¤׻Ƥ. 
      !
      real(8), intent(in) :: ya_data(:,:)
      !(in)  1 (Y)ʻǡ¤(1:jm,*)

      real(8)             :: a_IntLat_ya(size(ya_data,2))
      !(out) ʬͤ¤(*)

      integer :: j

      a_IntLat_ya = 0.0D0
      do j=1,jm
         a_IntLat_ya = a_IntLat_ya + ya_data(j,:) * y_Lat_Weight(j)
      enddo

    end function a_IntLat_ya

    function a_IntLon_xa(xa_data)          ! ʬ
      !
      ! 1 (X)ʻǡ X ʬ(¿).
      !
      ! ºݤˤϳʻǡ x_X_Weight 򤫤¤׻Ƥ. 
      !
      real(8), intent(in) :: xa_data(0:,:)
      !(in)  1 (X)ʻǡ¤(0:im-1,*)
      real(8)             :: a_IntLon_xa(size(xa_data,2))
      !(out) ʬͤ¤(*)
      integer :: i

      a_IntLon_xa = 0.0D0
      do i=0,im-1
         a_IntLon_xa = a_IntLon_xa + xa_data(i,:) * x_Lon_Weight(i)
      enddo

    end function a_IntLon_xa

  !--------------- ʿѷ׻ -----------------
    function a_AvrLonLat_xya(xya_data)
      !
      ! 2 ٷٳʻǡΰʿ(¿).
      !
      ! ºݤˤϳʻǡ x_X_Weight, y_Y_Weight 򤫤
      ! ¤׻, x_X_Weight*y_Y_Weight ¤ǳ뤳ȤʿѤƤ. 
      !
      real(8), intent(in)   :: xya_data(0:,:,:)
      !(in) 2 ٰٳʻǡ¤(0:im-1,1:jm,*)

      real(8) :: a_AvrLonLat_xya(size(xya_data,3))
      !(out) ʿͤ¤(*)

      a_AvrLonLat_xya = a_AvrLon_xa(xa_AvrLat_xya(xya_data))

    end function a_AvrLonLat_xya

    function xa_AvrLat_xya(xya_data)
      !
      ! 2 ٷٳʻǡΰ(Y)ʿ(¿).
      !
      ! ºݤˤϳʻǡ y_Y_Weight 򤫤¤׻, 
      ! y_Y_Weight ¤ǳ뤳ȤʿѤƤ. 
      !
      real(8), intent(in) :: xya_data(0:,:,:)
      !(in) 2 ٰٳʻǡ¤(0:im-1,1:jm,*)

      real(8)             :: xa_AvrLat_xya(0:im-1,size(xya_data,3))
      !(out) ʿѤ줿 1 (X)ʻǡ¤(im,*)

      xa_AvrLat_xya = xa_IntLat_xya(xya_data)/sum(y_Lat_Weight)

    end function xa_AvrLat_xya

    function ya_AvrLon_xya(xya_data)
      !
      ! 2 ٷٳʻǡη(X)ʿ(¿).
      !
      ! ºݤˤϳʻǡ x_X_Weight 򤫤¤׻, 
      ! x_X_Weight ¤ǳ뤳ȤʿѤƤ. 
      !
      real(8), intent(in) :: xya_data(0:,:,:)
      !(in) 2 ٰٳʻǡ¤(0:im-1,1:jm,*)

      real(8)             :: ya_AvrLon_xya(1:jm,size(xya_data,3))
      !(out) ʿѤ줿 1 (Y)ʻ¤(1:jm,*)

      ya_AvrLon_xya = ya_IntLon_xya(xya_data)/sum(x_Lon_Weight)

    end function ya_AvrLon_xya

    function a_AvrLat_ya(ya_data)
      !
      ! 1 (Y)ʻǡΰ(Y)ʿ(¿).
      !
      ! ºݤˤϳʻǡ y_Y_Weight 򤫤¤׻, 
      ! y_Y_Weight ¤ǳ뤳ȤʿѤƤ. 
      !
      real(8), intent(in) :: ya_data(:,:)
      !(in)  1 ٳʻǡ¤(1:jm,*)

      real(8)             :: a_AvrLat_ya(size(ya_data,2))
      !(out) ʿͤ¤(*)

      a_AvrLat_ya = a_IntLat_ya(ya_data)/sum(y_Lat_Weight)

    end function a_AvrLat_ya

    function a_AvrLon_xa(xa_data)          ! ʿ
      !
      ! 1 (X)ʻǡη(X)ʿ(¿).
      !
      ! ºݤˤϳʻǡ x_X_Weight 򤫤¤׻, 
      ! x_X_Weight ¤ǳ뤳ȤʿѤƤ. 
      !
      real(8), intent(in) :: xa_data(0:,:)
      !(in)  1 (X)ʻǡ¤(0:im-1,*)

      real(8)             :: a_AvrLon_xa(size(xa_data,2))
      !(out) ʿͤ¤(*)

      a_AvrLon_xa = a_IntLon_xa(xa_data)/sum(x_Lon_Weight)

    end function a_AvrLon_xa

end module wa_integral_module_sjpack_cuda
