#
# lay2.rb
#   $Id$
#

require "numru/dcl"

include NumRu
include Math

nmax = 401
xmin = 1600.0
xmax = 2000.0

x = NArray.sfloat(nmax)
y = NArray.sfloat(nmax)

#-- data ----
x.indgen(xmin, (xmax-xmin)/(nmax-1))
y0 = 0.5
for n in 0..nmax-1
  y[n] = 5.0*y0 + 10.0
  y0   = 3.7*y0*(1.0-y0)
end

#-- graph ----
iws = (ARGV[0] || (puts ' WORKSTATION ID (I)  ? ;'; DCL::sgpwsn; gets)).to_i
DCL::gropn iws
DCL::sglset('LFULL', true)
DCL::grfrm

DCL::grswnd(xmin, xmax, 11.0, 15.0)
DCL::grsvpt(0.15, 0.95, 0.15, 0.65)
DCL::uspfit
DCL::grstrf

DCL::ussttl('TIME', 'YEAR', 'TEMPERATURE', 'DEG')
DCL::usdaxs

DCL::uulin(x, y)

DCL::grcls

