!-------------------------------------------------------------------------
! Copyright (c) 2011 SPMODEL Development Group. All rights reserved.!
!-------------------------------------------------------------------------
!
!ɽ  ae_module_fftj ƥȥץ
!
!      ִؿΥƥ
!
!  2011/12/03  ݹ
!
!
program ae_module_fftj_interpolate_test

  use ae_module_fftj
  use dc_test
  implicit none

  integer, parameter :: im = 16,  km=5
  real(8), parameter :: xmin=0.0, xmax=1.0
  
  real(8)            :: g_Data(0:im-1)
  real(8)            :: e_Data(-km:km)

  real(8)            :: ag_Data(2,0:im-1)
  real(8)            :: ae_Data(2,-km:km)

  real(8)            :: xobs   = 0.3d0
  real(8)            :: answer(2)
  real(8)            :: PI

  ! Ƚ
  integer, parameter :: check_digits = 16
  integer, parameter :: ignore = -14

  PI = 4.0D0 * atan(1.0D0)

  call ae_Initial(im,km,xmin,xmax)

  g_Data = sin(PI*g_X)**2
  e_Data = e_g(g_Data)

  call AssertEqual(&
    message = '1-dim Interpolation ',                           &
    answer = sin(PI*xobs)**2,                                   &
    check =  Interpolate_e(e_Data,xobs),                        &
    significant_digits = check_digits, ignore_digits = ignore   &
  )

  ag_Data(1,:) = cos(PI*g_X)**2
  ag_Data(2,:) = sin(PI*g_X)**4
  ae_Data      = ae_ag(ag_Data)

  answer(1) = cos(PI*xobs)**2
  answer(2) = sin(PI*xobs)**4

  call AssertEqual(&
    message = '2-dim Interpolation ',                           &
    answer = answer,                                            &
    check =  a_Interpolate_ae(ae_Data,xobs),                    &
    significant_digits = check_digits, ignore_digits = ignore   &
  )

end program ae_module_fftj_interpolate_test
