/* -*- Mode:Text -*- */
#ifndef lint
static char Rcs_Id[] =
    "$Id: unsq.c,v 1.8 90/12/31 00:59:28 geoff Exp $";
#endif

/*
 * $Log:	unsq.c,v $
 * Revision 1.8  90/12/31  00:59:28  geoff
 * Reformat to follow a consistent convention throughout ispell
 * 
 * Revision 1.7  89/12/27  03:19:23  geoff
 * Move all messages to msgs.h so they can be reconfigured
 * 
 * Revision 1.6  89/04/28  01:18:03  geoff
 * Change Header to Id;  nobody cares about my pathnames.
 * 
 * Revision 1.5  88/11/25  19:54:56  geoff
 * Get rid of some unused variables.
 * 
 * Revision 1.4  88/11/16  02:20:50  geoff
 * Make the "Unexpected EOF" message come out only when the EOF is in the
 * middle of a line.  Previously, it was issued only when the EOF was *not*
 * in the middle of a line.
 * 
 * Revision 1.3  88/03/27  01:06:59  geoff
 * Fix to use the ASCII-encoded count characters that sq now produces.
 * 
 * Revision 1.2  88/03/13  00:58:24  geoff
 * Add ID keywords
 * 
 */

#include <stdio.h>
#include "msgs.h"

/*
 * The following table encodes prefix sizes as a single character.  A
 * matching table will be found in sq.c.
 */
static char size_encodings[] =
    {
    '0', '1', '2', '3', '4', '5', '6', '7', '8', '9',	/* 00-09 */
    'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J',	/* 10-19 */
    'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T',	/* 20-29 */
    'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd',	/* 30-39 */
    'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n',	/* 40-49 */
    'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x',	/* 50-59 */
    'y', 'z'						/* 60-61 */
    };

#define MAX_PREFIX	(sizeof (size_encodings) - 1)

main ()
    {
    char		word[257];
    static char		prev[257] = "";

    while (!expand (word, prev))
        puts (word);
    exit(0);
    }

expand (word, prev) 
    char *		word;
    char *		prev;
    {
    register char *	wordp;
    register char *	prevp;
    register int	same_count;
    register int	count_char;

    count_char = getchar ();
    if (count_char == EOF)
	return(1);
    for (same_count = 0;
      same_count < MAX_PREFIX  &&  size_encodings[same_count] != count_char;
      same_count++)
	;
    if (same_count == MAX_PREFIX)
	{
	fprintf (stderr, UNSQ_C_BAD_COUNT, count_char);
	exit (1);
	}
    prevp = prev;
    wordp = word;
    while (same_count--)
	*wordp++ = (*prevp++);
    if (gets(wordp) == NULL)
	{
	fprintf(stderr, UNSQ_C_SURPRISE_EOF);
	exit (1);
	}
    strcpy (prev, word);
    return 0 ;
    }

