/* gftopk in C by Tomas Rokicki */ 
#include <stdio.h>
#define linelength 79 
#define terminallinelength 150 
#define maxrow 16000 
#define incr(a) (a++)
#define decr(a) (a--)
#define true (1)
#define false (0)
#define chr(a) ((quarterword)(a))
#define round(a) ((int)(a+0.5))
#define pknyb(a) zpknyb((integer)(a))
#define pkbyte(a) zpkbyte((integer)(a))

  typedef int integer ;
  typedef unsigned char quarterword ;
  typedef char boolean ;
  typedef quarterword ASCIIcode ; 
  typedef quarterword eightbits ; 
  typedef FILE *bytefile ; 
  ASCIIcode xord[128] ; 
  char xchr[256] ; 
  bytefile gffile ; 
  bytefile pkfile ; 
  integer pkloc ; 
  integer gfloc ; 
  boolean pkopen ; 
  char pkname[81], gfname[81] ; 
  integer bitweight ; 
  integer outputbyte ; 
  integer gflen ; 
  integer tfmwidth[256] ; 
  integer dx[256], dy[256] ; 
  quarterword status[256] ; 
  integer row[16001] ; 
  integer gfch ; 
  integer gfchmod256 ; 
  integer predpkloc ; 
  integer maxn, minn ; 
  integer maxm, minm ; 
  integer rowptr ; 
  integer power[9] ; 
  char comment[]="GFtoPK 1.4 output" ; 
  integer checksum ; 
  integer dirptr ; 
  integer designsize ; 
  integer hmag ; 
  integer i ; 
  integer haveext , lastext ;
  initialize () { integer i ; 
    printf ( "This is GFtoPK, C Version 1.4\n" ) ; 
    for ( i = 0 ; i <= 31 ; i ++ ) xchr [ i ] = '?' ; 
      xchr [ 32 ] = ' ' ; 
    xchr [ 33 ] = '!' ; 
    xchr [ 34 ] = '"' ; 
    xchr [ 35 ] = '#' ; 
    xchr [ 36 ] = '$' ; 
    xchr [ 37 ] = '%' ; 
    xchr [ 38 ] = '&' ; 
    xchr [ 39 ] = '\'' ; 
    xchr [ 40 ] = '(' ; 
    xchr [ 41 ] = ')' ; 
    xchr [ 42 ] = '*' ; 
    xchr [ 43 ] = '+' ; 
    xchr [ 44 ] = ',' ; 
    xchr [ 45 ] = '-' ; 
    xchr [ 46 ] = '.' ; 
    xchr [ 47 ] = '/' ; 
    xchr [ 48 ] = '0' ; 
    xchr [ 49 ] = '1' ; 
    xchr [ 50 ] = '2' ; 
    xchr [ 51 ] = '3' ; 
    xchr [ 52 ] = '4' ; 
    xchr [ 53 ] = '5' ; 
    xchr [ 54 ] = '6' ; 
    xchr [ 55 ] = '7' ; 
    xchr [ 56 ] = '8' ; 
    xchr [ 57 ] = '9' ; 
    xchr [ 58 ] = ':' ; 
    xchr [ 59 ] = ';' ; 
    xchr [ 60 ] = '<' ; 
    xchr [ 61 ] = '=' ; 
    xchr [ 62 ] = '>' ; 
    xchr [ 63 ] = '?' ; 
    xchr [ 64 ] = '@' ; 
    xchr [ 65 ] = 'A' ; 
    xchr [ 66 ] = 'B' ; 
    xchr [ 67 ] = 'C' ; 
    xchr [ 68 ] = 'D' ; 
    xchr [ 69 ] = 'E' ; 
    xchr [ 70 ] = 'F' ; 
    xchr [ 71 ] = 'G' ; 
    xchr [ 72 ] = 'H' ; 
    xchr [ 73 ] = 'I' ; 
    xchr [ 74 ] = 'J' ; 
    xchr [ 75 ] = 'K' ; 
    xchr [ 76 ] = 'L' ; 
    xchr [ 77 ] = 'M' ; 
    xchr [ 78 ] = 'N' ; 
    xchr [ 79 ] = 'O' ; 
    xchr [ 80 ] = 'P' ; 
    xchr [ 81 ] = 'Q' ; 
    xchr [ 82 ] = 'R' ; 
    xchr [ 83 ] = 'S' ; 
    xchr [ 84 ] = 'T' ; 
    xchr [ 85 ] = 'U' ; 
    xchr [ 86 ] = 'V' ; 
    xchr [ 87 ] = 'W' ; 
    xchr [ 88 ] = 'X' ; 
    xchr [ 89 ] = 'Y' ; 
    xchr [ 90 ] = 'Z' ; 
    xchr [ 91 ] = '[' ; 
    xchr [ 92 ] = '\\' ; 
    xchr [ 93 ] = ']' ; 
    xchr [ 94 ] = '^' ; 
    xchr [ 95 ] = '_' ; 
    xchr [ 96 ] = '`' ; 
    xchr [ 97 ] = 'a' ; 
    xchr [ 98 ] = 'b' ; 
    xchr [ 99 ] = 'c' ; 
    xchr [ 100 ] = 'd' ; 
    xchr [ 101 ] = 'e' ; 
    xchr [ 102 ] = 'f' ; 
    xchr [ 103 ] = 'g' ; 
    xchr [ 104 ] = 'h' ; 
    xchr [ 105 ] = 'i' ; 
    xchr [ 106 ] = 'j' ; 
    xchr [ 107 ] = 'k' ; 
    xchr [ 108 ] = 'l' ; 
    xchr [ 109 ] = 'm' ; 
    xchr [ 110 ] = 'n' ; 
    xchr [ 111 ] = 'o' ; 
    xchr [ 112 ] = 'p' ; 
    xchr [ 113 ] = 'q' ; 
    xchr [ 114 ] = 'r' ; 
    xchr [ 115 ] = 's' ; 
    xchr [ 116 ] = 't' ; 
    xchr [ 117 ] = 'u' ; 
    xchr [ 118 ] = 'v' ; 
    xchr [ 119 ] = 'w' ; 
    xchr [ 120 ] = 'x' ; 
    xchr [ 121 ] = 'y' ; 
    xchr [ 122 ] = 'z' ; 
    xchr [ 123 ] = '{' ; 
    xchr [ 124 ] = '|' ; 
    xchr [ 125 ] = '}' ; 
    xchr [ 126 ] = '~' ; 
    for ( i = 127 ; i <= 255 ; i ++ ) xchr [ i ] = '?' ; 
      for ( i = 0 ; i <= 127 ; i ++ ) xord [ chr ( i ) ] = 32 ; 
      for ( i = 32 ; i <= 126 ; i ++ ) xord [ xchr [ i ] ] = i ; 
      pkopen = false ; 
    for ( i = 0 ; i <= 255 ; i ++ ) status [ i ] = 0 ; 
      power [ 0 ] = 1 ; 
    for ( i = 1 ; i <= 8 ; i ++ ) power [ i ] = power [ i - 1 ] + power [ i - 
      1 ] ; 
    } 
  jumpout () { exit(1) ; 
    } 
  opengffile () { gffile = fopen ( gfname , "r" ) ; 
    gfloc = 0 ; 
    } 
  openpkfile () { pkfile = fopen ( pkname , "w" ) ; 
    pkloc = 0 ; 
    pkopen = true ;
    } 
  integer gfbyte () { incr ( gfloc ) ; 
    return ( getc ( gffile ) ) ; 
    } 
  integer gfsignedquad () { eightbits a, b, c, d ; 
    gfloc = gfloc + 4 ; 
    a = getc ( gffile ) ; 
    b = getc ( gffile ) ; 
    c = getc ( gffile ) ; 
    d = getc ( gffile ) ; 
    if ( a < 128 ) return ( ( ( a * 256 + b ) * 256 + c ) * 256 + d ) ; 
    else return ( ( ( ( a - 256 ) * 256 + b ) * 256 + c ) * 256 + d ) ; 
    } 
  zpkbyte ( a ) 
  integer a ; 
  { if ( pkopen ) 
    { if ( a < 0 ) a = a + 256 ; 
      putc ( chr ( a ) , pkfile ) ; 
      incr ( pkloc ) ; 
      } 
    } 
  pkhalfword ( a ) 
  integer a ; 
  { if ( a < 0 ) a = a + 65536 ; 
    putc ( chr ( a / 256 ) , pkfile ) ; 
    putc ( chr ( a % 256 ) , pkfile ) ; 
    pkloc = pkloc + 2 ; 
    } 
  pkthreebytes ( a ) 
  integer a ; 
  { putc ( chr ( a / 65536 % 256 ) , pkfile ) ; 
    putc ( chr ( a / 256 % 256 ) , pkfile ) ; 
    putc ( chr ( a % 256 ) , pkfile ) ; 
    pkloc = pkloc + 3 ; 
    } 
  pkword ( a ) 
  integer a ; 
  { integer b ; 
    if ( pkopen ) 
    { if ( a < 0 ) 
      { a = a + ( 1073741824 ) + ( 1073741824 ) ; 
        b = 128 + a / 16777216 ; 
        } 
      else b = a / 16777216 ; 
      putc ( chr ( b ) , pkfile ) ; 
      putc ( chr ( a / 65536 % 256 ) , pkfile ) ; 
      putc ( chr ( a / 256 % 256 ) , pkfile ) ; 
      putc ( chr ( a % 256 ) , pkfile ) ; 
      pkloc = pkloc + 4 ; 
      } 
    } 
  zpknyb ( a ) 
  integer a ; 
  { if ( bitweight == 16 ) 
    { outputbyte = a * 16 ; 
      bitweight = 1 ; 
      } 
    else 
    { pkbyte ( outputbyte + a ) ; 
      bitweight = 16 ; 
      } 
    } 
  findgflength () { fseek ( gffile , 0L , 2 ) ; 
    gflen = ftell ( gffile ) ; 
    } 
  movetobyte ( n ) 
  integer n ; 
  { fseek ( gffile , (long) n , 0 ) ; 
    } 
  packandsendcharacter () { integer i, j, k ; 
    integer extra ; 
    integer putptr ; 
    integer repeatflag ; 
    integer hbit ; 
    integer buff ; 
    integer dynf ; 
    integer height, width ; 
    integer xoffset, yoffset ; 
    integer deriv[17] ; 
    integer bcompsize ; 
    boolean firston ; 
    integer flagbyte ; 
    boolean state ; 
    boolean on ; 
    integer compsize ; 
    integer count ; 
    integer pbit ; 
    boolean ron, son ; 
    integer rcount, scount ; 
    integer ri, si ; 
    integer max2 ; 
    i = 2 ; 
    decr ( rowptr ) ; 
    while ( row [ i ] == ( - 99999 ) ) incr ( i ) ; 
      if ( row [ i ] != ( - 99998 ) ) 
    { maxn = maxn - i + 2 ; 
      while ( row [ rowptr - 2 ] == ( - 99999 ) ) 
        { decr ( rowptr ) ; 
          row [ rowptr ] = ( - 99998 ) ; 
          } 
        minn = maxn + 1 ; 
      extra = maxm - minm + 1 ; 
      maxm = 0 ; 
      j = i ; 
      while ( row [ j ] != ( - 99998 ) ) 
        { decr ( minn ) ; 
          if ( row [ j ] != ( - 99999 ) ) 
          { k = row [ j ] ; 
            if ( k < extra ) extra = k ; 
            incr ( j ) ; 
            while ( row [ j ] != ( - 99999 ) ) 
              { k = k + row [ j ] ; 
                incr ( j ) ; 
                } 
              if ( maxm < k ) maxm = k ; 
            } 
          incr ( j ) ; 
          } 
        minm = minm + extra ; 
      maxm = minm + maxm - 1 - extra ; 
      height = maxn - minn + 1 ; 
      width = maxm - minm + 1 ; 
      xoffset = - minm ; 
      yoffset = maxn ; 
      } 
    else {
      height = 0 ;
      width = 0 ;
      xoffset = 0 ;
      yoffset = 0 ;
      }
    putptr = 0 ; 
    rowptr = 2 ; 
    repeatflag = 0 ; 
    state = true ; 
    buff = 0 ; 
    while ( row [ rowptr ] == ( - 99999 ) )
      incr ( rowptr ) ;
    while ( row [ rowptr ] != ( - 99998 ) ) 
      { i = rowptr ; 
        if ( ( row [ i ] != ( - 99999 ) ) && ( ( row [ i ] != extra ) || ( 
        row [ i + 1 ] != width ) ) ) 
        { j = i + 1 ; 
          while ( row [ j - 1 ] != ( - 99999 ) ) incr ( j ) ; 
            while ( row [ i ] == row [ j ] ) 
            { if ( row [ i ] == ( - 99999 ) ) 
              { incr ( repeatflag ) ; 
                rowptr = i + 1 ; 
                } 
              incr ( i ) ; 
              incr ( j ) ; 
              } 
            } 
        if ( row [ rowptr ] != ( - 99999 ) ) row [ rowptr ] = row [ rowptr ] 
        - extra ; 
        hbit = 0 ; 
        while ( row [ rowptr ] != ( - 99999 ) ) 
          { hbit = hbit + row [ rowptr ] ; 
            if ( state ) 
            { buff = buff + row [ rowptr ] ; 
              state = false ; 
              } 
            else if ( row [ rowptr ] > 0 ) 
            { 
              { row [ putptr ] = buff ; 
                incr ( putptr ) ; 
                if ( repeatflag > 0 ) 
                { row [ putptr ] = - repeatflag ; 
                  repeatflag = 0 ; 
                  incr ( putptr ) ; 
                  } 
                } 
              buff = row [ rowptr ] ; 
              } 
            else state = true ; 
            incr ( rowptr ) ; 
            } 
          if ( hbit < width ) if ( state ) buff = buff + width - hbit ; 
        else 
        { 
          { row [ putptr ] = buff ; 
            incr ( putptr ) ; 
            if ( repeatflag > 0 ) 
            { row [ putptr ] = - repeatflag ; 
              repeatflag = 0 ; 
              incr ( putptr ) ; 
              } 
            } 
          buff = width - hbit ; 
          state = true ; 
          } 
        else state = false ; 
        incr ( rowptr ) ; 
        } 
      if ( buff > 0 ) 
    { row [ putptr ] = buff ; 
      incr ( putptr ) ; 
      if ( repeatflag > 0 ) 
      { row [ putptr ] = - repeatflag ; 
        repeatflag = 0 ; 
        incr ( putptr ) ; 
        } 
      } 
    
    { row [ putptr ] = ( - 99998 ) ; 
      incr ( putptr ) ; 
      if ( repeatflag > 0 ) 
      { row [ putptr ] = - repeatflag ; 
        repeatflag = 0 ; 
        incr ( putptr ) ; 
        } 
      } 
    for ( i = 1 ; i <= 13 ; i ++ ) deriv [ i ] = 0 ; 
      i = 0 ; 
    firston = row [ i ] == 0 ; 
    if ( firston ) incr ( i ) ; 
    compsize = 0 ; 
    while ( row [ i ] != ( - 99998 ) ) 
      { j = row [ i ] ; 
        if ( j == - 1 ) incr ( compsize ) ; 
        else 
        { if ( j < 0 ) 
          { incr ( compsize ) ; 
            j = - j ; 
            } 
          if ( j < 209 ) compsize = compsize + 2 ; 
          else 
          { k = j - 193 ; 
            while ( k >= 16 ) 
              { k = k / 16 ; 
                compsize = compsize + 2 ; 
                } 
              compsize = compsize + 1 ; 
            } 
          if ( j < 14 ) decr ( deriv [ j ] ) ; 
          else if ( j < 209 ) incr ( deriv [ ( 223 - j ) / 15 ] ) ; 
          else 
          { k = 16 ; 
            while ( ( k * 16 < j + 3 ) ) k = k * 16 ; 
              if ( j - k <= 192 ) deriv [ ( 207 - j + k ) / 15 ] = deriv [ ( 
            207 - j + k ) / 15 ] + 2 ; 
            } 
          } 
        incr ( i ) ; 
        } 
      bcompsize = compsize ; 
    dynf = 0 ; 
    for ( i = 1 ; i <= 13 ; i ++ ) 
      { compsize = compsize + deriv [ i ] ; 
        if ( compsize <= bcompsize ) 
        { bcompsize = compsize ; 
          dynf = i ; 
          } 
        } 
      compsize = ( bcompsize + 1 ) / 2 ; 
    if ( ( compsize > ( height * width + 7 ) / 8 ) || ( height * width == 0 ) 
    ) 
    { compsize = ( height * width + 7 ) / 8 ; 
      dynf = 14 ; 
      } 
    flagbyte = dynf * 16 ; 
    if ( firston ) flagbyte = flagbyte + 8 ; 
    if ( ( gfch > 255 ) || ( tfmwidth [ gfchmod256 ] > 16777215 ) || ( 
    tfmwidth [ gfchmod256 ] < 0 ) || ( dy [ gfchmod256 ] != 0 ) || ( dx [ 
    gfchmod256 ] < 0 ) || ( dx [ gfchmod256 ] % 65536 != 0 ) || ( compsize > 
    196579 ) || ( width > 65535 ) || ( height > 65535 ) || ( xoffset > 32767 
    ) || ( yoffset > 32767 ) || ( xoffset < - 32768 ) || ( yoffset < - 32768 
    ) ) 
    { flagbyte = flagbyte + 7 ; 
      pkbyte ( flagbyte ) ; 
      compsize = compsize + 28 ; 
      pkword ( compsize ) ; 
      pkword ( gfch ) ; 
      predpkloc = pkloc + compsize ; 
      pkword ( tfmwidth [ gfchmod256 ] ) ; 
      pkword ( dx [ gfchmod256 ] ) ; 
      pkword ( dy [ gfchmod256 ] ) ; 
      pkword ( width ) ; 
      pkword ( height ) ; 
      pkword ( xoffset ) ; 
      pkword ( yoffset ) ; 
      } 
    else if ( ( dx [ gfch ] > 16777215 ) || ( width > 255 ) || ( height > 255 
    ) || ( xoffset > 127 ) || ( yoffset > 127 ) || ( xoffset < - 128 ) || ( 
    yoffset < - 128 ) || ( compsize > 1016 ) ) 
    { compsize = compsize + 13 ; 
      flagbyte = flagbyte + compsize / 65536 + 4 ; 
      pkbyte ( flagbyte ) ; 
      pkhalfword ( compsize % 65536 ) ; 
      pkbyte ( gfch ) ; 
      predpkloc = pkloc + compsize ; 
      pkthreebytes ( tfmwidth [ gfchmod256 ] ) ; 
      pkhalfword ( dx [ gfchmod256 ] / 65536 ) ; 
      pkhalfword ( width ) ; 
      pkhalfword ( height ) ; 
      pkhalfword ( xoffset ) ; 
      pkhalfword ( yoffset ) ; 
      } 
    else 
    { compsize = compsize + 8 ; 
      flagbyte = flagbyte + compsize / 256 ; 
      pkbyte ( flagbyte ) ; 
      pkbyte ( compsize % 256 ) ; 
      pkbyte ( gfch ) ; 
      predpkloc = pkloc + compsize ; 
      pkthreebytes ( tfmwidth [ gfchmod256 ] ) ; 
      pkbyte ( dx [ gfchmod256 ] / 65535 ) ; 
      pkbyte ( width ) ; 
      pkbyte ( height ) ; 
      pkbyte ( xoffset ) ; 
      pkbyte ( yoffset ) ; 
      } 
    if ( dynf != 14 ) 
    { bitweight = 16 ; 
      max2 = 208 - 15 * dynf ; 
      i = 0 ; 
      if ( row [ i ] == 0 ) incr ( i ) ; 
      while ( row [ i ] != ( - 99998 ) ) 
        { j = row [ i ] ; 
          if ( j == - 1 ) pknyb ( 15 ) ; 
          else 
          { if ( j < 0 ) 
            { pknyb ( 14 ) ; 
              j = - j ; 
              } 
            if ( j <= dynf ) pknyb ( j ) ; 
            else if ( j <= max2 ) 
            { j = j - dynf - 1 ; 
              pknyb ( j / 16 + dynf + 1 ) ; 
              pknyb ( j % 16 ) ; 
              } 
            else 
            { j = j - max2 + 15 ; 
              k = 16 ; 
              while ( k <= j ) 
                { k = k * 16 ; 
                  pknyb ( 0 ) ; 
                  } 
                while ( k > 1 ) 
                { k = k / 16 ; 
                  pknyb ( j / k ) ; 
                  j = j % k ; 
                  } 
                } 
            } 
          incr ( i ) ; 
          } 
        if ( bitweight != 16 ) pkbyte ( outputbyte ) ; 
      } 
    else if ( height > 0 ) 
    { buff = 0 ; 
      pbit = 8 ; 
      i = 1 ; 
      hbit = width ; 
      on = false ; 
      state = false ; 
      count = row [ 0 ] ; 
      repeatflag = 0 ; 
      while ( ( row [ i ] != ( - 99998 ) ) || state || ( count > 0 ) ) 
        { if ( state ) 
          { count = rcount ; 
            i = ri ; 
            on = ron ; 
            decr ( repeatflag ) ; 
            } 
          else 
          { rcount = count ; 
            ri = i ; 
            ron = on ; 
            } 
          do { if ( count == 0 ) 
            { if ( row [ i ] < 0 ) 
              { if ( ! state ) repeatflag = - row [ i ] ; 
                incr ( i ) ; 
                } 
              count = row [ i ] ; 
              incr ( i ) ; 
              on = ! on ; 
              } 
            if ( ( count >= pbit ) && ( pbit < hbit ) ) 
            { if ( on ) buff = buff + power [ pbit ] - 1 ; 
              pkbyte ( buff ) ; 
              buff = 0 ; 
              hbit = hbit - pbit ; 
              count = count - pbit ; 
              pbit = 8 ; 
              } 
            else if ( ( count < pbit ) && ( count < hbit ) ) 
            { if ( on ) buff = buff + power [ pbit ] - power [ pbit - count ] 
              ; 
              pbit = pbit - count ; 
              hbit = hbit - count ; 
              count = 0 ; 
              } 
            else 
            { if ( on ) buff = buff + power [ pbit ] - power [ pbit - hbit ] 
              ; 
              count = count - hbit ; 
              pbit = pbit - hbit ; 
              hbit = width ; 
              if ( pbit == 0 ) 
              { pkbyte ( buff ) ; 
                buff = 0 ; 
                pbit = 8 ; 
                } 
              } 
            } while ( ! ( hbit == width ) ) ; 
          if ( state && ( repeatflag == 0 ) ) 
          { count = scount ; 
            i = si ; 
            on = son ; 
            state = false ; 
            } 
          else if ( ! state && ( repeatflag > 0 ) ) 
          { scount = count ; 
            si = i ; 
            son = on ; 
            state = true ; 
            } 
          } 
        if ( pbit != 8 ) pkbyte ( buff ) ; 
      } 
    } 
  convertgffile () { integer i, j, k ; 
    integer gfcom ; 
    boolean on ; 
    boolean state ; 
    integer extra ; 
    boolean bad ; 
    integer hppp, vppp ; 
    integer q ; 
    integer postloc ; 
    opengffile () ; 
    if ( gfbyte () != 247 ) 
    { printf ( " Bad GF file: First byte is not preamble!\n" ) ; 
      jumpout () ; 
      } 
    if ( gfbyte () != 131 ) 
    { printf ( " Bad GF file: Identification byte is incorrect!\n" ) ;
      jumpout () ; 
      } 
    findgflength () ; 
    postloc = gflen - 4 ; 
    do { if ( postloc == 0 ) 
      { printf ( " Bad GF file: all 223's!\n" ) ; 
        jumpout () ; 
        } 
      movetobyte ( postloc ) ; 
      k = gfbyte () ; 
      decr ( postloc ) ; 
      } while ( ! ( k != 223 ) ) ; 
    if ( k != 131 ) 
    { printf ( " Bad GF file: ID byte is %d!\n" , k ) ; 
      jumpout () ; 
      } 
    movetobyte ( postloc - 3 ) ; 
    q = gfsignedquad () ; 
    if ( ( q < 0 ) || ( q > postloc - 3 ) ) 
    { printf ( " Bad GF file: post pointer is %d!\n" , q ) ; 
      jumpout () ; 
      } 
    movetobyte ( q ) ; 
    k = gfbyte () ; 
    if ( k != 248 ) 
    { printf ( " Bad GF file: byte at %d is not post!\n" , q ) ;
      jumpout () ; 
      } 
    i = gfsignedquad () ; 
    designsize = gfsignedquad () ; 
    checksum = gfsignedquad () ; 
    hppp = gfsignedquad () ; 
    hmag = round ( hppp * 72.27 / 65536 ) ; 
    vppp = gfsignedquad () ; 
    if ( hppp != vppp ) printf ( "Odd aspect ratio!\n" ) ; 
    i = gfsignedquad () ; 
    i = gfsignedquad () ; 
    i = gfsignedquad () ; 
    i = gfsignedquad () ; 
    do { gfcom = gfbyte () ; 
      switch ( gfcom ) 
      { case 245 : 
        case 246 : 
        
        { gfch = gfbyte () ; 
          if ( status [ gfch ] != 0 ) 
          { printf ( 
     " Bad GF file: Locator for this character already found!\n") ; 
            jumpout () ; 
            } 
          if ( gfcom == 245 ) 
          { dx [ gfch ] = gfsignedquad () ; 
            dy [ gfch ] = gfsignedquad () ; 
            } 
          else 
          { dx [ gfch ] = gfbyte () * 65536 ; 
            dy [ gfch ] = 0 ; 
            } 
          tfmwidth [ gfch ] = gfsignedquad () ; 
          i = gfsignedquad () ; 
          status [ gfch ] = 1 ; 
          } 
        break ; 
        case 239 : 
        case 240 : 
        case 241 : 
        case 242 : 
        
        { pkbyte ( gfcom + 1 ) ; 
          i = 0 ; 
          for ( j = 0 ; j <= gfcom - 239 ; j ++ ) 
            { k = gfbyte () ; 
              pkbyte ( k ) ; 
              i = i * 256 + k ; 
              } 
            for ( j = 1 ; j <= i ; j ++ ) pkbyte ( gfbyte () ) ; 
            } 
        break ; 
        case 243 : 
        
        { pkbyte ( 244 ) ; 
          pkword ( gfsignedquad () ) ; 
          } 
        break ; 
        case 247 : 
        ; 
        break ; 
        case 249 : 
        ; 
        break ; 
        default : 
        
        { printf ( " Bad GF file: Unexpected %d in postamble!\n" , gfcom ) ;
          jumpout () ; 
          } 
        break ; 
        } } while ( ! ( gfcom == 249 ) ) ; 
    i = round ( hppp * 72.27 / 65536 ) ;
    if ( ! haveext ) sprintf ( pkname + lastext , ".%dpk" , i ) ;
    openpkfile () ; 
    pkbyte ( 247 ) ; 
    pkbyte ( 89 ) ; 
    pkbyte ( 17 ) ; 
    for ( i = 0 ; comment[i] != 0 ; i ++ ) pkbyte ( xord [ comment [ i ] ] ) ; 
      pkword ( designsize ) ; 
    pkword ( checksum ) ; 
    pkword ( hppp ) ; 
    pkword ( vppp ) ; 
    movetobyte ( 2 ) ; 
    i = gfbyte () ; 
    printf ( "'" ) ; 
    for ( j = 1 ; j <= i ; j ++ ) putchar ( xchr [ gfbyte () ] ) ; 
      printf ( "'\n" ) ; 
    do { gfcom = gfbyte () ; 
      switch ( gfcom ) 
      { case 67 : 
        case 68 : 
        
        { if ( gfcom == 67 ) 
          { gfch = gfsignedquad () ; 
            i = gfsignedquad () ; 
            minm = gfsignedquad () ; 
            maxm = gfsignedquad () ; 
            minn = gfsignedquad () ; 
            maxn = gfsignedquad () ; 
            } 
          else 
          { gfch = gfbyte () ; 
            i = gfbyte () ; 
            maxm = gfbyte () ; 
            minm = maxm - i ; 
            i = gfbyte () ; 
            maxn = gfbyte () ; 
            minn = maxn - i ; 
            } 
          gfchmod256 = gfch % 256 ; 
          if ( status [ gfchmod256 ] == 0 ) 
          { 
            { printf ( 
   " Bad GF file: no character locator for character %d!\n" , gfch ) ;
              jumpout () ; 
              } 
            do { gfcom = gfbyte () ; 
              switch ( gfcom ) 
              { case 239 : 
                case 240 : 
                case 241 : 
                case 242 : 
                
                { pkbyte ( gfcom + 1 ) ; 
                  i = 0 ; 
                  for ( j = 0 ; j <= gfcom - 239 ; j ++ ) 
                    { k = gfbyte () ; 
                      pkbyte ( k ) ; 
                      i = i * 256 + k ; 
                      } 
                    for ( j = 1 ; j <= i ; j ++ ) pkbyte ( gfbyte () ) ; 
                    } 
                break ; 
                case 243 : 
                
                { pkbyte ( 244 ) ; 
                  pkword ( gfsignedquad () ) ; 
                  } 
                break ; 
                case 247 : 
                ; 
                break ; 
                case 64 : 
                case 71 : 
                i = gfbyte () ; 
                break ; 
                case 65 : 
                case 72 : 
                
                { i = gfbyte () ; 
                  i = gfbyte () ; 
                  } 
                break ; 
                case 66 : 
                case 73 : 
                
                { i = gfbyte () ; 
                  i = gfbyte () ; 
                  i = gfbyte () ; 
                  } 
                break ; 
                default : 
                ; 
                break ; 
                } } while ( ! ( gfcom == 69 ) ) ; 
            } 
          else 
          { bad = false ; 
            rowptr = 2 ; 
            on = false ; 
            extra = 0 ; 
            state = true ; 
            do { gfcom = gfbyte () ; 
              if ( gfcom == 0 ) 
              { state = ! state ; 
                on = ! on ; 
                } 
              else if ( gfcom <= 66 ) 
              { if ( gfcom < 64 ) i = gfcom - 0 ; 
                else 
                { i = 0 ; 
                  for ( j = 0 ; j <= gfcom - 64 ; j ++ ) i = i * 256 + gfbyte 
                    () ; 
                    } 
                if ( state ) 
                { extra = extra + i ; 
                  state = false ; 
                  } 
                else 
                { 
                  { if ( rowptr > maxrow ) bad = true ; 
                    else 
                    { row [ rowptr ] = extra ; 
                      incr ( rowptr ) ; 
                      } 
                    } 
                  extra = i ; 
                  } 
                on = ! on ; 
                } 
              else if ( ( gfcom >= 74 ) && ( gfcom <= 238 ) ) 
              { if ( ! on && ( extra > 0 ) ) 
                { if ( rowptr > maxrow ) bad = true ; 
                  else 
                  { row [ rowptr ] = extra ; 
                    incr ( rowptr ) ; 
                    } 
                  } 
                
                { if ( rowptr > maxrow ) bad = true ; 
                  else 
                  { row [ rowptr ] = ( - 99999 ) ; 
                    incr ( rowptr ) ; 
                    } 
                  } 
                on = true ; 
                extra = gfcom - 74 ; 
                state = false ; 
                } 
              else switch ( gfcom ) 
              { case 70 : 
                case 71 : 
                case 72 : 
                case 73 : 
                
                { i = 0 ; 
                  for ( j = 1 ; j <= gfcom - 70 ; j ++ ) i = i * 256 + gfbyte 
                    () ; 
                    if ( ! on && ( extra > 0 ) ) 
                  { if ( rowptr > maxrow ) bad = true ; 
                    else 
                    { row [ rowptr ] = extra ; 
                      incr ( rowptr ) ; 
                      } 
                    } 
                  for ( j = 0 ; j <= i ; j ++ ) 
                    { if ( rowptr > maxrow ) bad = true ; 
                      else 
                      { row [ rowptr ] = ( - 99999 ) ; 
                        incr ( rowptr ) ; 
                        } 
                      } 
                    on = false ; 
                  extra = 0 ; 
                  state = true ; 
                  } 
                break ; 
                case 239 : 
                case 240 : 
                case 241 : 
                case 242 : 
                
                { pkbyte ( gfcom + 1 ) ; 
                  i = 0 ; 
                  for ( j = 0 ; j <= gfcom - 239 ; j ++ ) 
                    { k = gfbyte () ; 
                      pkbyte ( k ) ; 
                      i = i * 256 + k ; 
                      } 
                    for ( j = 1 ; j <= i ; j ++ ) pkbyte ( gfbyte () ) ; 
                    } 
                break ; 
                case 243 : 
                
                { pkbyte ( 244 ) ; 
                  pkword ( gfsignedquad () ) ; 
                  } 
                break ; 
                case 247 : 
                ; 
                break ; 
                case 69 : 
                
                { if ( ! on && ( extra > 0 ) ) 
                  { if ( rowptr > maxrow ) bad = true ; 
                    else 
                    { row [ rowptr ] = extra ; 
                      incr ( rowptr ) ; 
                      } 
                    } 
                  if ( ( rowptr > 2 ) && ( row [ rowptr - 1 ] != ( - 99999 ) 
                  ) ) 
                  { if ( rowptr > maxrow ) bad = true ; 
                    else 
                    { row [ rowptr ] = ( - 99999 ) ; 
                      incr ( rowptr ) ; 
                      } 
                    } 
                  
                  { if ( rowptr > maxrow ) bad = true ; 
                    else 
                    { row [ rowptr ] = ( - 99998 ) ; 
                      incr ( rowptr ) ; 
                      } 
                    } 
                  if ( bad ) 
                  { printf ( " Ran out of internal memory for row counts!\n" ) ;
                    jumpout () ; 
                    } 
                  packandsendcharacter () ; 
                  status [ gfchmod256 ] = 2 ; 
                  if ( pkloc != predpkloc ) 
                  { printf ( " Internal error while writing character!\n" 
                    ) ; 
                    jumpout () ; 
                    } 
                  } 
                break ; 
                default : 
                
                { printf ( 
   " Bad GF file: Unexpected %d character in character definition!\n" , gfcom
                  ) ;
                  jumpout () ; 
                  } 
                break ; 
                } } while ( ! ( gfcom == 69 ) ) ; 
            } 
          } 
        break ; 
        case 239 : 
        case 240 : 
        case 241 : 
        case 242 : 
        
        { pkbyte ( gfcom + 1 ) ; 
          i = 0 ; 
          for ( j = 0 ; j <= gfcom - 239 ; j ++ ) 
            { k = gfbyte () ; 
              pkbyte ( k ) ; 
              i = i * 256 + k ; 
              } 
            for ( j = 1 ; j <= i ; j ++ ) pkbyte ( gfbyte () ) ; 
            } 
        break ; 
        case 243 : 
        
        { pkbyte ( 244 ) ; 
          pkword ( gfsignedquad () ) ; 
          } 
        break ; 
        case 247 : 
        ; 
        break ; 
        case 248 : 
        ; 
        break ; 
        default : 
        
        { printf ( " Bad GF file: Unexpected %d command between characters!\n"
          , gfcom ) ;
          jumpout () ; 
          } 
        break ; 
        } } while ( ! ( gfcom == 248 ) ) ; 
    pkbyte ( 245 ) ; 
    while ( ( pkloc % 4 != 0 ) ) pkbyte ( 246 ) ; 
      } 
  main (argc, argv) 
int argc ;
char *argv[] ;
{ if ( argc < 2 || argc > 3 ) {
    printf("Usage: gftopk gffile[.gf] [pkfile[.pk]]\n") ;
    jumpout() ; 
    }
  strcpy ( gfname , argv [ 1 ] ) ;
  lastext = - 1 ; 
  i = 0 ; 
  while ( gfname [ i ] != 0 ) 
    { if ( gfname [ i ] == '.' ) lastext = i ; 
      else if ( gfname [ i ] == '/' ) lastext = - 1 ; 
      incr ( i ) ; 
      } 
    if ( lastext == - 1 ) 
  { strcpy ( gfname + i , ".gf" ) ; 
    lastext = i ; 
    } 
  if ( argc == 3 ) 
  { strcpy ( pkname , argv [ 2 ] ) ; 
    haveext = true ; 
    } 
  else 
  { strcpy ( pkname , gfname ) ; 
    haveext = false ; 
    } 
  initialize () ; 
  convertgffile () ; 
  for ( i = 0 ; i <= 255 ; i ++ ) if ( status [ i ] == 1 ) printf ( 
    "Character %d missing raster information!\n" , i ) ; 
    printf ( "%d bytes packed to %d bytes.\n" , gflen , pkloc ) ; 
  lab9999 : ; 
  } 
