/*
 * Fmtdump: read a .fmt file and produce C corresponding initialization
 * statements.
 *
 * Based on the idea of fmt2init, described in TUGboat, for TurboTeX.
 *
 * Usage: fmtdump [format_file [init_file.c]]
 *
 * Tim Morgan  4/20/88
 */

#define EXTERN
#include "texd.h"

extern char *sprintf();

char my_buffer[100], tbuf[100];
int blen = 0, buflimit;
#define	SMALL_LIMIT	40
#define	BIG_LIMIT	75

do_bool(n,v)
char *n;
int v;
{
    if (v)
	(void) printf("boolean %s=true;\n", n);
}

do_integer(n,v)
char *n;
integer v;
{
    if (v)
	(void) printf("integer %s= %ldL;\n", n, v);
}

void do_halfword(n, v)
char *n;
halfword v;
{
    if (v)
	(void) printf("halfword %s=%u;\n", n, v);
}

void do_schar(n, v)
char *n;
schar v;
{
    if (v)
	(void) printf("schar %s= %d;\n", n, v);
}

void do_short(n, v)
char *n;
short v;
{
    if (v)
	(void) printf("short %s= %d;\n", n, v);
}

void do_quarterword(n, v)
char *n;
quarterword v;
{
    if (v)
	(void) printf("quarterword %s=%u;\n", n, v);
}

boolean loadfmtfile () {
    /* 6666 10 */ register boolean Result; 
  loadfmtfile_regmem 
  integer j, k  ; 
  halfword p, q  ; 
  integer x  ; 
  getfmtint ( x ) ; 
  if ( x != 67218746L ) 
  goto lab6666 ; 
  getfmtint ( x ) ; 
  if ( x != 0 ) 
  goto lab6666 ; 
  getfmtint ( x ) ; 
  if ( x != memtop ) 
  goto lab6666 ; 
  getfmtint ( x ) ; 
  if ( x != 5976 ) 
  goto lab6666 ; 
  getfmtint ( x ) ; 
  if ( x != 2551 ) 
  goto lab6666 ; 
  getfmtint ( x ) ; 
  if ( x != 307 ) 
  goto lab6666 ; 
  {
    getfmtint ( x ) ; 
    if ( x < 0 ) 
    goto lab6666 ; 
    if ( x > poolsize ) 
    {
      wakeupterminal () ; 
      (void) fprintf( stdout , "%s%s\n",  "---! Must increase the " , "string pool size" ) ; 
      goto lab6666 ; 
    } 
    else poolptr = x ; 
  } 
  {
    getfmtint ( x ) ; 
    if ( x < 0 ) 
    goto lab6666 ; 
    if ( x > maxstrings ) 
    {
      wakeupterminal () ; 
      (void) fprintf( stdout , "%s%s\n",  "---! Must increase the " , "max strings" ) ; 
      goto lab6666 ; 
    } 
    else strptr = x ; 
  } 
  undumpthings ( strstart [ 0 ] , strptr + 1 ) ; 
  undumpthings ( strpool [ 0 ] , poolptr ) ; 
  {
    getfmtint ( x ) ; 
    if ( ( x < 1019 ) || ( x > memtop - 14 ) ) 
    goto lab6666 ; 
    else lomemmax = x ; 
  } 
  {
    getfmtint ( x ) ; 
    if ( ( x < 20 ) || ( x > lomemmax ) ) 
    goto lab6666 ; 
    else rover = x ; 
  } 
  p = 0 ; 
  q = rover ; 
  x = 0 ; 
  do {
      undumpthings ( mem [ p ] , q + 2 - p ) ; 
    p = q + mem [ q ] .hh .v.LH ; 
    if ( ( p > lomemmax ) || ( ( q >= mem [ q + 1 ] .hh .v.RH ) && ( mem [ q + 
    1 ] .hh .v.RH != rover ) ) ) 
    goto lab6666 ; 
    q = mem [ q + 1 ] .hh .v.RH ; 
  } while ( ! ( q == rover ) ) ; 
  undumpthings ( mem [ p ] , lomemmax + 1 - p ) ; 
  if ( memmin < -2 ) 
  {
    p = mem [ rover + 1 ] .hh .v.LH ; 
    q = memmin + 1 ; 
    mem [ memmin ] .hh .v.RH = 0 ; 
    mem [ memmin ] .hh .v.LH = 0 ; 
    mem [ p + 1 ] .hh .v.RH = q ; 
    mem [ rover + 1 ] .hh .v.LH = q ; 
    mem [ q + 1 ] .hh .v.RH = rover ; 
    mem [ q + 1 ] .hh .v.LH = p ; 
    mem [ q ] .hh .v.RH = 65535L ; 
    mem [ q ] .hh .v.LH = -0 - q ; 
  } 
  {
    getfmtint ( x ) ; 
    if ( ( x < lomemmax + 1 ) || ( x > memtop - 13 ) ) 
    goto lab6666 ; 
    else himemmin = x ; 
  } 
  {
    getfmtint ( x ) ; 
    if ( ( x < 0 ) || ( x > memtop ) ) 
    goto lab6666 ; 
    else avail = x ; 
  } 
  memend = memtop ; 
  undumpthings ( mem [ himemmin ] , memend + 1 - himemmin ) ; 
  getfmtint ( varused ) ; 
  getfmtint ( dynused ) ; 
  k = 1 ; 
  do {
      getfmtint ( x ) ; 
    if ( ( x < 1 ) || ( k + x > 5977 ) ) 
    goto lab6666 ; 
    undumpthings ( eqtb [ k ] , x ) ; 
    k = k + x ; 
    getfmtint ( x ) ; 
    if ( ( x < 0 ) || ( k + x > 5977 ) ) 
    goto lab6666 ; 
    {register integer for_end; j = k ; for_end = k + x - 1 ; if ( j <= 
    for_end) do 
      eqtb [ j ] = eqtb [ k - 1 ] ; 
    while ( j++ < for_end ) ; } 
    k = k + x ; 
  } while ( ! ( k > 5976 ) ) ; 
  {
    getfmtint ( x ) ; 
    if ( ( x < 258 ) || ( x > 3258 ) ) 
    goto lab6666 ; 
    else parloc = x ; 
  } 
  partoken = 4096 + parloc ; 
  {
    getfmtint ( x ) ; 
    if ( ( x < 258 ) || ( x > 3258 ) ) 
    goto lab6666 ; 
    else
    writeloc = x ; 
  } 
  {
    getfmtint ( x ) ; 
    if ( ( x < 258 ) || ( x > 3258 ) ) 
    goto lab6666 ; 
    else hashused = x ; 
  } 
  p = 257 ; 
  do {
      { 
      getfmtint ( x ) ; 
      if ( ( x < p + 1 ) || ( x > hashused ) ) 
      goto lab6666 ; 
      else p = x ; 
    } 
    getfmthh ( hash [ p ] ) ; 
  } while ( ! ( p == hashused ) ) ; 
  undumpthings ( hash [ hashused + 1 ] , 3524 - hashused ) ; 
  getfmtint ( cscount ) ; 
  {
    getfmtint ( x ) ; 
    if ( x < 7 ) 
    goto lab6666 ; 
    if ( x > fontmemsize ) 
    {
      wakeupterminal () ; 
      (void) fprintf( stdout , "%s%s\n",  "---! Must increase the " , "font mem size" ) ; 
      goto lab6666 ; 
    } 
    else fmemptr = x ; 
  } 
  {
    undumpthings ( fontinfo [ 0 ] , fmemptr ) ; 
    {
      getfmtint ( x ) ; 
      if ( x < 0 ) 
      goto lab6666 ; 
      if ( x > fontmax ) 
      {
	wakeupterminal () ; 
	(void) fprintf( stdout , "%s%s\n",  "---! Must increase the " , "font max" ) ; 
	goto lab6666 ; 
      } 
      else fontptr = x ; 
    } 
    undumpthings ( fontcheck [ 0 ] , fontptr + 1 ) ; 
    undumpthings ( fontsize [ 0 ] , fontptr + 1 ) ; 
    undumpthings ( fontdsize [ 0 ] , fontptr + 1 ) ; 
    undumpthings ( fontparams [ 0 ] , fontptr + 1 ) ; 
    undumpthings ( hyphenchar [ 0 ] , fontptr + 1 ) ; 
    undumpthings ( skewchar [ 0 ] , fontptr + 1 ) ; 
    undumpthings ( fontname [ 0 ] , fontptr + 1 ) ; 
    undumpthings ( fontarea [ 0 ] , fontptr + 1 ) ; 
    undumpthings ( fontbc [ 0 ] , fontptr + 1 ) ; 
    undumpthings ( fontec [ 0 ] , fontptr + 1 ) ; 
    undumpthings ( charbase [ 0 ] , fontptr + 1 ) ; 
    undumpthings ( widthbase [ 0 ] , fontptr + 1 ) ; 
    undumpthings ( heightbase [ 0 ] , fontptr + 1 ) ; 
    undumpthings ( depthbase [ 0 ] , fontptr + 1 ) ; 
    undumpthings ( italicbase [ 0 ] , fontptr + 1 ) ; 
    undumpthings ( ligkernbase [ 0 ] , fontptr + 1 ) ; 
    undumpthings ( kernbase [ 0 ] , fontptr + 1 ) ; 
    undumpthings ( extenbase [ 0 ] , fontptr + 1 ) ; 
    undumpthings ( parambase [ 0 ] , fontptr + 1 ) ; 
    undumpthings ( fontglue [ 0 ] , fontptr + 1 ) ; 
  } 
  {
    getfmtint ( x ) ; 
    if ( ( x < 0 ) || ( x > 307 ) ) 
    goto lab6666 ; 
    else hyphcount = x ; 
  } 
  {register integer for_end; k = 1 ; for_end = hyphcount ; if ( k <= for_end) 
  do 
    {
      {
	getfmtint ( x ) ; 
	if ( ( x < 0 ) || ( x > 307 ) ) 
	goto lab6666 ; 
	else j = x ; 
      } 
      {
	getfmtint ( x ) ; 
	if ( ( x < 0 ) || ( x > strptr ) ) 
	goto lab6666 ; 
	else hyphword [ j ] = x ; 
      } 
      {
	getfmtint ( x ) ; 
	if ( ( x < 0 ) || ( x > 65535L ) ) 
	goto lab6666 ; 
	else hyphlist [ j ] = x ; 
      } 
    } 
  while ( k++ < for_end ) ; } 
  {
    getfmtint ( x ) ; 
    if ( x < 0 ) 
    goto lab6666 ; 
    if ( x > triesize ) 
    {
      wakeupterminal () ; 
      (void) fprintf( stdout , "%s%s\n",  "---! Must increase the " , "trie size" ) ; 
      goto lab6666 ; 
    } 
    else triemax = x ; 
  } 
  undumpthings ( trie [ 0 ] , triemax + 1 ) ; 
  {
    getfmtint ( x ) ; 
    if ( ( x < 0 ) || ( x > 255 ) ) 
    goto lab6666 ; 
    else trieopptr = x ; 
  } 
  undumpthings ( hyfdistance [ 1 ] , trieopptr - 0 ) ; 
  undumpthings ( hyfnum [ 1 ] , trieopptr - 0 ) ; 
  undumpthings ( hyfnext [ 1 ] , trieopptr - 0 ) ; 
  {
    getfmtint ( x ) ; 
    if ( ( x < 0 ) || ( x > 3 ) ) 
    goto lab6666 ; 
    else interaction = x ; 
  } 
  {
    getfmtint ( x ) ; 
    if ( ( x < 0 ) || ( x > strptr ) ) 
    goto lab6666 ; 
    else formatident = x ; 
  } 
  getfmtint ( x ) ; 
  if ( ( x != 69069L ) || eof ( fmtfile ) ) 
  goto lab6666 ; 
  Result = true ; 
  return(Result) ; 
  lab6666: wakeupterminal () ; 
  (void) fprintf( stdout , "%s\n",  "(Fatal format file error; I'm stymied)" ) ; 
  Result = false ; 
  return(Result) ; 
}

void add_buf()
{
    register int len;

    len = strlen(tbuf);
    if (len + blen > buflimit) {
	if (buflimit == BIG_LIMIT) fputs("    ", stdout);	/* indent */
	puts(my_buffer);
	blen = 0;
	buflimit = BIG_LIMIT;
    }
    (void) strcpy(&my_buffer[blen], tbuf);
    blen += len;
}

void flush_buf()
{
    if (blen > 0) {
	puts(my_buffer);
	blen = 0;
    }
}

void do_integer_array(n, v, s, decsize)
char *n;
integer v[];
long s, decsize;
{
    register long i;

    for (--s; s >= 0 && v[s] == 0; --s);
    if (s < 0) return;
    (void) printf("integer %s[%ld]={", n, decsize);
    buflimit = SMALL_LIMIT;
    for (i=0; i<=s; ) {
	(void) sprintf(tbuf, "%dL,", v[i++]);
	add_buf();
    }
    flush_buf();
    puts("};");
}

void do_halfword_array(n, v, s, decsize)
char *n;
halfword v[];
long s, decsize;
{
    register long i;

    for (--s; s >= 0 && v[s] == 0; --s);
    if (s < 0) return;
    (void) printf("halfword %s[%ldL]={", n, decsize);
    buflimit = 40;
    for (i=0; i<=s; ) {
	(void) sprintf(tbuf, "%u,", v[i++]);
	add_buf();
    }
    flush_buf();
    puts("};");
}

do_uchar_array(n, v, s, decsize)
char *n;
unsigned char v[];
long s, decsize;
{
    register long i;

    for (--s; s >= 0 && v[s] == 0; --s);
    if (s < 0) return;
    (void) printf("quarterword %s[%d]={", n, decsize);
    buflimit = 40;
    for (i=0; i<=s; ) {
	(void) sprintf(tbuf, "%u,", v[i++]);
	add_buf();
    }
    flush_buf();
    puts("};");
}

do_char_array(n, v, s, decsize)
char *n;
char v[];
int s, decsize;
{
    register int i;

    for (--s; s >= 0 && v[s] == 0; --s);
    if (s < 0) return;
    (void) printf("char %s[%d]={", n, decsize);
    buflimit = 40;
    for (i=0; i<=s; ) {
	(void) sprintf(tbuf, "%d,", v[i++]);
	add_buf();
    }
    flush_buf();
    puts("};");
}

#define	do_ASCIIcode_array(n,v,s,d)	do_uchar_array(n, v, (long) s, (long) d)
#define	do_eightbits_array(n,v,s,d)	do_uchar_array(n, v, (long) s, (long) d)
#define	do_quarterword_array(n,v,s,d)	do_uchar_array(n, v, (long) s, (long) d)

do_schar_array(n, v, s, decsize)
char *n;
schar v[];
long s, decsize;
{
    register long i;

    for (--s; s >= 0 && v[s] == 0; --s);
    if (s < 0) return;
    (void) printf("schar %s[%ldL]={", n, decsize);
    buflimit = 40;
    for (i=0; i<=s; ) {
	(void) sprintf(tbuf, "%d,", v[i++]);
	add_buf();
    }
    flush_buf();
    puts("};");
}

/* This is a kludge */
do_memword_array(n, v, s, decsize)
char *n;
memoryword v[];
long s, decsize;
{
    register long i;

    for (--s; s >= 0 && v[s].cint == 0; --s);
    if (s < 0) return;
    (void) printf("long %s[%ldL]={", n, decsize);
    buflimit = 40;
    for (i=0; i<=s;) {
	(void) sprintf(tbuf, "%ldL,", v[i++].cint);
	add_buf();
    }
    flush_buf();
    puts("};");
}

do_four_array(n, v, s, decsize)
char *n;
fourquarters v[];
long s, decsize;
{
    register long i;

    for (--s;
	s >= 0 && v[s].b0 == 0 && v[s].b1 == 0 && v[s].b2 == 0 && v[s].b3 == 0;
	--s);
    if (s < 0) return;
    (void) printf("fourquarters %s[%ldL]={", n, decsize);
    buflimit = 40;
    for (i=0; i<=s; i++) {
	(void) sprintf(tbuf,"{{%u,%u},%u,%u}",
		v[i].b0, v[i].b1, v[i].b2, v[i].b3);
	if (i < s) (void) strcat(tbuf, ",");
	add_buf();
    }
    flush_buf();
    puts("};");
}

/* This is a kludge */
do_twohalves_array(n, v, s, decsize)
char *n;
twohalves v[];
long s, decsize;
{
    register long i;

    for (--s; v[s].v.RH || v[s].v.LH; --s);
    if (s < 0) return;
    (void) printf("unsigned long %s[%ldL]={", n, decsize);
    buflimit = 40;
    for (i=0; i<=s; i++) {
	(void) sprintf(tbuf, "%lu,", (v[i].v.RH << 16) | v[i].v.LH);
	add_buf();
    }
    flush_buf();
    puts("};");
}


dump_fmt()
{
    puts("typedef unsigned short halfword;");
    puts("typedef unsigned char quarterword;");
    puts("#include \"tex.h\"");
    puts("#include \"memory.h\"\n");

    do_integer("poolptr", poolptr);
    do_integer("strptr", strptr);
    do_halfword("lomemmax", lomemmax);
    do_halfword("himemmin", himemmin);
    do_integer("varused", varused);
    do_integer("dynused", dynused);
    do_halfword("avail", avail);
    do_halfword("memend", memend);
    do_halfword("parloc", parloc);
    do_halfword("partoken", partoken);
    do_halfword("writeloc", writeloc);
    do_halfword("hashused", hashused);
    do_integer("cscount", cscount);
    do_integer("fmemptr", fmemptr);
    do_quarterword("trieopptr", trieopptr);
    do_schar("interaction", interaction);
    do_integer("formatident", formatident);
    do_ASCIIcode_array("strpool", strpool, poolptr,
	sizeof(strpool)/sizeof(strpool[0]));
    do_integer_array("strstart", strstart, (long) (strptr+1), (long) (maxstrings+1));
    do_twohalves_array("zzzae", zzzae, (long) (sizeof(zzzae)/sizeof(zzzae[0])),
		  (long) (sizeof(zzzae)/sizeof(zzzae[0])));/* hash */
    do_memword_array("zzzaa", zzzaa, (long) (sizeof(zzzaa)/sizeof(zzzaa[0])),
		     (long) (sizeof(zzzaa)/sizeof(zzzaa[0])));/* mem */
    do_memword_array("zeqtb", zeqtb, (long) (sizeof(zeqtb)/sizeof(zeqtb[0])),
		     (long) (sizeof(zeqtb)/sizeof(zeqtb[0])));/* eqtb */
    do_memword_array("fontinfo", fontinfo, fmemptr, (long) (fontmemsize+1));
    do_four_array("fontcheck", fontcheck, fontptr+1, (long) (fontmax+1));
    do_integer_array("fontsize", fontsize, fontptr+1, (long) (fontmax+1));
    do_integer_array("fontdsize", fontdsize, fontptr+1, (long) (fontmax+1));
    do_halfword_array("fontparams", fontparams, fontptr+1, (long) (fontmax+1));
    do_integer_array("hyphenchar", hyphenchar, fontptr+1, (long) (fontmax+1));
    do_integer_array("skewchar", skewchar, fontptr+1, (long) (fontmax+1));
    do_integer_array("fontname", fontname, fontptr+1, (long) (fontmax+1));
    do_integer_array("fontarea", fontarea, fontptr+1, (long) (fontmax+1));
    do_eightbits_array("fontec", fontec, fontptr+1, (long) (fontmax+1));
    do_eightbits_array("fontbc", fontbc, fontptr+1, (long) (fontmax+1));
    do_integer_array("charbase", charbase, fontptr+1, (long) (fontmax+1));
    do_integer_array("widthbase", widthbase, fontptr+1, (long) (fontmax+1));
    do_integer_array("heightbase", heightbase, fontptr+1, (long) (fontmax+1));
    do_integer_array("depthbase", depthbase, fontptr+1,(long) (fontmax+1));
    do_integer_array("italicbase", italicbase, fontptr+1, (long) (fontmax+1));
    do_integer_array("ligkernbase", ligkernbase, fontptr+1, (long) (fontmax+1));
    do_integer_array("kernbase", kernbase, fontptr+1, (long) (fontmax+1));
    do_integer_array("extenbase", extenbase, fontptr+1, (long) (fontmax+1));
    do_integer_array("parambase", parambase, fontptr+1, (long) (fontmax+1));
    do_halfword_array("fontglue", fontglue, fontptr+1, (long) (fontmax+1));
    do_short("hyphcount", hyphcount);
    do_integer_array("hyphword", hyphword,
		     (long) (sizeof(hyphword)/sizeof(hyphword[0])),
		     (long) (sizeof(hyphword)/sizeof(hyphword[0])));
    do_halfword_array("hyphlist", hyphlist,
		      (long) (sizeof(hyphlist)/sizeof(hyphlist[0])),
		      (long) (sizeof(hyphlist)/sizeof(hyphlist[0])));
    do_integer("triemax", triemax);
    do_twohalves_array("trie", trie,
		       (long) (sizeof(trie)/sizeof(trie[0])),
		       (long) (sizeof(trie)/sizeof(trie[0])));
    do_schar_array("hyfdistance", hyfdistance,
		   (long) (sizeof(hyfdistance)/sizeof(hyfdistance[0])),
		   (long) (sizeof(hyfdistance)/sizeof(hyfdistance[0])));
    do_schar_array("hyfnum", hyfnum,
		   (long) (sizeof(hyfnum)/sizeof(hyfnum[0])),
		   (long) (sizeof(hyfnum)/sizeof(hyfnum[0])));
    do_quarterword_array("hyfnext", hyfnext,
			 (long) (sizeof(hyfnext)/sizeof(hyfnext[0])),
			 (long) (sizeof(hyfnext)/sizeof(hyfnext[0])));
    do_integer("readyalready", 314159L);
}


wakeupterminal()
{
}


/*
 * This routine initializes things to the same values as the initialization()
 * routine in TeX, then writes the values to stdout.  If TeX's initialization
 * routine is changed, then those changes must be entered here as well.
 */
void dump_initializations()
{
    register int i;

    do_bool("deletionsallowed", true);
    do_bool("OKtointerrupt", true);
    do_halfword("pagetail", (halfword) (memtop-2));
    do_halfword("lastglue", (halfword) 65535);
    printf("char *TEXformatdefault=\" plain.fmt\";\n");
    do_integer("dvilimit", (integer) dvibufsize);
    do_integer("halfbuf", (integer) (dvibufsize/2));
    do_integer("curs", -1L);
    do_integer("lastbop", -1L);
    do_bool("nonewcontrolsequence", true);
    do_quarterword("curlevel", 1);
    for (i=5267; i<=5976; i++)
	xeqlevel[i] = 1;
    do_quarterword_array("zzzad", zzzad, sizeof(zzzad)/sizeof(zzzad[0]),
		(long) (5976-5267+1));
    for (i=0; i<=16; i++)
	readopen[i] = 2;
    do_schar_array("readopen", readopen,
		(long) (sizeof(readopen)/sizeof(readopen[0])),
		(long) (16-0+1));
  /* The following code was copied directly from the C version of TeX */
  xchr [ 32 ] = ' ' ; 
  xchr [ 33 ] = '!' ; 
  xchr [ 34 ] = '"' ; 
  xchr [ 35 ] = '#' ; 
  xchr [ 36 ] = '$' ; 
  xchr [ 37 ] = '%' ; 
  xchr [ 38 ] = '&' ; 
  xchr [ 39 ] = '\'' ; 
  xchr [ 40 ] = '(' ; 
  xchr [ 41 ] = ')' ; 
  xchr [ 42 ] = '*' ; 
  xchr [ 43 ] = '+' ; 
  xchr [ 44 ] = ',' ; 
  xchr [ 45 ] = '-' ; 
  xchr [ 46 ] = '.' ; 
  xchr [ 47 ] = '/' ; 
  xchr [ 48 ] = '0' ; 
  xchr [ 49 ] = '1' ; 
  xchr [ 50 ] = '2' ; 
  xchr [ 51 ] = '3' ; 
  xchr [ 52 ] = '4' ; 
  xchr [ 53 ] = '5' ; 
  xchr [ 54 ] = '6' ; 
  xchr [ 55 ] = '7' ; 
  xchr [ 56 ] = '8' ; 
  xchr [ 57 ] = '9' ; 
  xchr [ 58 ] = ':' ; 
  xchr [ 59 ] = ';' ; 
  xchr [ 60 ] = '<' ; 
  xchr [ 61 ] = '=' ; 
  xchr [ 62 ] = '>' ; 
  xchr [ 63 ] = '?' ; 
  xchr [ 64 ] = '@' ; 
  xchr [ 65 ] = 'A' ; 
  xchr [ 66 ] = 'B' ; 
  xchr [ 67 ] = 'C' ; 
  xchr [ 68 ] = 'D' ; 
  xchr [ 69 ] = 'E' ; 
  xchr [ 70 ] = 'F' ; 
  xchr [ 71 ] = 'G' ; 
  xchr [ 72 ] = 'H' ; 
  xchr [ 73 ] = 'I' ; 
  xchr [ 74 ] = 'J' ; 
  xchr [ 75 ] = 'K' ; 
  xchr [ 76 ] = 'L' ; 
  xchr [ 77 ] = 'M' ; 
  xchr [ 78 ] = 'N' ; 
  xchr [ 79 ] = 'O' ; 
  xchr [ 80 ] = 'P' ; 
  xchr [ 81 ] = 'Q' ; 
  xchr [ 82 ] = 'R' ; 
  xchr [ 83 ] = 'S' ; 
  xchr [ 84 ] = 'T' ; 
  xchr [ 85 ] = 'U' ; 
  xchr [ 86 ] = 'V' ; 
  xchr [ 87 ] = 'W' ; 
  xchr [ 88 ] = 'X' ; 
  xchr [ 89 ] = 'Y' ; 
  xchr [ 90 ] = 'Z' ; 
  xchr [ 91 ] = '[' ; 
  xchr [ 92 ] = '\\' ; 
  xchr [ 93 ] = ']' ; 
  xchr [ 94 ] = '^' ; 
  xchr [ 95 ] = '_' ; 
  xchr [ 96 ] = '`' ; 
  xchr [ 97 ] = 'a' ; 
  xchr [ 98 ] = 'b' ; 
  xchr [ 99 ] = 'c' ; 
  xchr [ 100 ] = 'd' ; 
  xchr [ 101 ] = 'e' ; 
  xchr [ 102 ] = 'f' ; 
  xchr [ 103 ] = 'g' ; 
  xchr [ 104 ] = 'h' ; 
  xchr [ 105 ] = 'i' ; 
  xchr [ 106 ] = 'j' ; 
  xchr [ 107 ] = 'k' ; 
  xchr [ 108 ] = 'l' ; 
  xchr [ 109 ] = 'm' ; 
  xchr [ 110 ] = 'n' ; 
  xchr [ 111 ] = 'o' ; 
  xchr [ 112 ] = 'p' ; 
  xchr [ 113 ] = 'q' ; 
  xchr [ 114 ] = 'r' ; 
  xchr [ 115 ] = 's' ; 
  xchr [ 116 ] = 't' ; 
  xchr [ 117 ] = 'u' ; 
  xchr [ 118 ] = 'v' ; 
  xchr [ 119 ] = 'w' ; 
  xchr [ 120 ] = 'x' ; 
  xchr [ 121 ] = 'y' ; 
  xchr [ 122 ] = 'z' ; 
  xchr [ 123 ] = '{' ; 
  xchr [ 124 ] = '|' ; 
  xchr [ 125 ] = '}' ; 
  xchr [ 126 ] = '~' ; 
  xchr [ 0 ] = ' ' ; 
  xchr [ 127 ] = ' ' ; 
  {register integer for_end; i = 1 ; for_end = 31 ; if ( i <= for_end) do 
    xchr [ i ] = chr ( i ) ; 
  while ( i++ < for_end ) ; } 
  {register integer for_end; i = 0 ; for_end = 127 ; if ( i <= for_end) do 
    xord [ chr ( i ) ] = 127 ; 
  while ( i++ < for_end ) ; } 
  {register integer for_end; i = 1 ; for_end = 126 ; if ( i <= for_end) do 
    xord [ xchr [ i ] ] = i ; 
  while ( i++ < for_end ) ; }
    /* End of copied code */
    do_quarterword_array("xord", xord, sizeof(xord), sizeof(xord));
    do_char_array("xchr", xchr, sizeof(xchr), sizeof(xchr));
    printf("liststaterecord curlist={1,%ldL,%ldL,0,-65536000L,0};\n",
	(long) (memtop-1), (long) (memtop-1));
}


main(argc, argv)
char *argv[];
{
    char *fmtfilename;

    if (argc > 3) {
	(void) fprintf(stderr, "usage: %s fmt_file [init_file.c]\n", argv[0]);
	exit(1);
    }

    if (argc > 1) fmtfilename = argv[1];
    else fmtfilename = "plain.fmt";

    fmtfile = fopen(fmtfilename, "r");
    if (!fmtfile)
	perror(fmtfilename), exit(1);

    if (argc > 2) {
	if (freopen(argv[2], "w", stdout) == NULL)
	    perror(argv[2]), exit(1);
    }

    if (loadfmtfile()) {
	dump_fmt();
	dump_initializations();
	exit(0);
    } else {
	exit(1);
    }
    /*NOTREACHED*/
}
