/*
 * These are stub routines for running the trap test and making a small
 * inimf.
 *
 * Tim Morgan 2/5/88
 */

#define	EXTERN extern
#include "mfd.h"

/*
 * Initialize the screen.  Return false if it is not possible to
 * graphics for any reason (wrong type of terminal or whatever),
 * and return true if the screen is successfully initialized.
 */
initscreen()
{
#ifdef	TRAP
    return(true);
#else	/* INIMF */
    return(false);
#endif	/* TRAP/INIMF */
}

/* Procedure to cause the display to be updated */
updatescreen()
{
    (void) fprintf(logfile, "Calling UPDATESCREEN\n");
}

/* Procedure to blank a rectangle on the screen */
blankrectangle(left_col, right_col, top_row, bot_row)
screencol left_col, right_col;
screenrow top_row, bot_row;
{
    (void) fprintf(logfile, "\nCalling BLANKRECTANGLE(%ld,%ld,%ld,%ld)\n",
	   (long) left_col, (long) right_col,
	   (long) top_row, (long) bot_row);
}

/* Procedure to paint a row a particular color b */
zpaintrow(r, b, a, n)
screenrow r;
pixelcolor b;
transspec a;
screencol n;
{
    int k;

    (void) fprintf(logfile, "Calling PAINTROW(%ld,%ld;",
	   (long) r, (long) b);
    for (k=0; k<=n; k++) {
	(void) fprintf(logfile, "%ld", a[k]);
	if (k != n)
	    (void) putc(',', logfile);
    }
    (void) fprintf(logfile, ")\n");
}
