/*
 * X Version 11 Window interface for Metafont
 *
 * Modifed from Tim Morgan's X Version 11 routines by Richard Johnson
 */

#define	EXTERN	extern
#include "../mfd.h"

#ifdef	X11WIN
#include <X11/Xlib.h>
#include <X11/Xutil.h>

static Display *my_display;
static Window my_window;
static GC my_gc;

/* Return 1 if display opened successfully, else 0 */
mf_x11_initscreen()
{
    char default_geometry[50], *sprintf();
/*    opaqueframe outer_frame; */
    XSizeHints sizehints;
    XGCValues gcvalues;

    my_display = XOpenDisplay("");
    if (!my_display) return(0);
    my_window = XCreateSimpleWindow(my_display, DefaultRootWindow(my_display),
				    0, 0, screenwidth, screendepth, 1,
				    BlackPixel(my_display,
					       DefaultScreen(my_display)),
				    BlackPixel(my_display,
					       DefaultScreen(my_display)));
    sizehints.flags = 0;
    XSetStandardProperties(my_display, my_window, "Metafont", "Metafont",
			   0, 0, 0, sizehints);
    /* We need a GC if we're going to draw anything */
    gcvalues.foreground = WhitePixel(my_display, DefaultScreen(my_display));
    gcvalues.background = BlackPixel(my_display, DefaultScreen(my_display));
    gcvalues.fill_style = FillSolid;
    gcvalues.line_width = 1;
    my_gc = XCreateGC(my_display, my_window,
		      GCForeground|GCBackground|GCFillStyle|GCLineWidth,
		      &gcvalues);
    XMapWindow(my_display, my_window);
    return(1);
}

/* Make sure the screen is up to date */
mf_x11_updatescreen()
{
    XFlush(my_display);
}

mf_x11_blankrectangle(left, right, top, bottom)
screencol left, right;
screenrow top, bottom;
{
    XSetForeground(my_display, my_gc, WhitePixel(my_display, 0));
    XFillRectangle(my_display, my_window, my_gc, (int) left, (int)top,
	      (int) (right - left + 1), (int) (bottom - top + 1));
}

mf_x11_paintrow(row, init_color, tvect, vector_size)
screenrow row;
pixelcolor init_color;
transspec tvect;
register screencol vector_size;
{
    register int color, col;

    color = (init_color == 0) ? WhitePixel(my_display, 0) :
	BlackPixel(my_display, 0);

    do {
	col = *tvect++;
	XSetForeground(my_display, my_gc, color);
	XDrawLine(my_display, my_window, my_gc, col, (int) row,
		  (int) (*tvect-1), (int) row);
	if (color == WhitePixel(my_display, 0))
	    color = BlackPixel(my_display, 0);
	else color = WhitePixel(my_display, 0);
    } while (--vector_size > 0);
}

#endif
