
#ifndef lint
static char RCSid[] = "$Header: dateandtime.c,v 1.0 86/01/31 15:01:12 richards Released $";
#endif

/*
** DATEANDTIME.C -- external procedures:
**
**	procedure dateandtime(
**			var	minutes,
**				day,
**				month,
**				year:	integer);
*/

#include <signal.h>
#ifdef	BSD
#include <sys/time.h>
#else
#include <time.h>
#endif
#define	EXTERN	extern
#include "../mfd.h"

/*
**	catchint()
**
**  Gets called when the user hits his interrupt key.  Sets the global
**  "interrupt" nonzero, then sets it up so that the next interrupt will
**  also be caught here.
**
*/

extern	integer	interrupt;		/* defined in mf.p; non-zero means */
					/*  a user-interrupt request	   */
					/*  is pending			   */
catchint()
{
	interrupt = 1;
	(void) signal(SIGINT,catchint);
}

/*
**      dateandtime(time, day, month, year)
**
**  Stores minutes since midnight, current day, month and year into
**  *time, *day, *month and *year, respectively.
**
**  Also, set things up so that catchint() will get control on interrupts.
**
*/

ydateandtime(minutes, day, month, year)
integer	*minutes, *day, *month, *year;
{
        long        clock, time();
	struct tm   *tmptr, *localtime();
	static int  (*psig)();
	
	clock = time((long *) 0);
	tmptr = localtime(&clock);
	
	*minutes = tmptr->tm_hour * 60 + tmptr->tm_min;
	*day = tmptr->tm_mday;
	*month = tmptr->tm_mon + 1;
	*year = tmptr->tm_year + 1900;

	if ((psig = signal(SIGINT,catchint)) != SIG_DFL)
	    (void) signal(SIGINT, psig);
}
