.TH detex 1 2/27/86
.UC 4
.SH NAME
detex \- a filter to strip TeX and LaTeX's commands from a file.
.SH SYNOPSIS
.B detex [-i]
.I file1 [file2 ......]
.br
or
.B detex [-i]
.I < file
.br
.SH DESCRIPTION
TeX and LaTeX have control characters that
.B spell
and other
.I troff
-dependent
processors (like diction) do not recognize.
.I Detex
works as a preprocessor by
filtering those control characters. The output can then be piped to the next
process. The output can be saved by redirecting the standard output.
.I Detex
does not break the document into individual words. It merely
.I erases
the control sequences.
The character '%' is recognized as a comment indicator and the commented
text is not passed to the output.
.br
.I Detex
recognizes and opens files called by TeX's and LaTeX's \\input
and \\include commands. The
.B -i
flag makes
.I detex
ignore these commands.
The file name has to be correct relative to the current working directory.
If it cannot open the file nor file_name.tex, it will give a non-fatal
error message and proceed.
.SH DIAGNOSTICS
Nesting of \\input and \\include is allowed but the number of opened files
must not exceed the system's limit on the number of simultaneously opened
files (normally < 20).
.br
Material between single or double dollar signs is regarded as mathematical
equations and is ignored.
.SH SEE ALSO
tex(1)
.SH AUTHOR
Kamal Al-Yahya, Stanford University
