#include <stdio.h>
#include "help.h"

main()	/* test out the help function */
{
	char buf[BUFSIZ];
	char *hfpn = "helpfile";	/* help file path name */
	char *ahfpn = "alt-helpfile";	/* alternate help file name */

	printf("Type control-D to quit.\n");
	printf("Help on:  ");
	while (fgets(buf, sizeof buf, stdin) != NULL)
	{
		switch (help(buf, hfpn)) {
		case H_FOUND:
			/* already printed the help info; do nothing */
			break;
		case H_NOTFOUND:
			printf("Sorry, no help for %s", buf);
			help(buf, ahfpn);	/* try other help file */
			break;
		case H_ERROR:
			perror(hfpn);
			break;
		default:	/* defensive programming */
			printf("Can't happen\n");
			break;
		}
		printf("Help on:  ");
	}
	exit(0);
}
