/*
 * File:
 *
 *	message.c
 *
 * Author:
 *
 *	Brad Rullman
 *	Department of Computer Science  FR-35
 *	University of Washington
 *	Seattle, Washington  98155
 *	email: ecola@cs.washington.edu
 *
 *	Copyright @ March, 1987 - This program, or any subset of the functions
 *	herein, is not to be redistributed, or used for personal or commercial
 *	gain in the form of fame, fortune, or shorter working hours, without
 *	the consent of the author.
 *
 * Function:
 *
 *	A file of functions which implement the interface to the
 *	Message subwindow.
 *
 * Contents:
 *
 *   Public:
 *
 *	InitMessageSW		Initializes the Message subwindow.
 *	ShowMsg			Displays a message in the MessageSW.
 *	ClearMsg		Clears MessageSW if it contains an error msg.
 *	Confirm			Forces user to confirm an action with mouse.
 *	
 *   Private:
 *
 */

#include "global.h"
#include <suntool/fullscreen.h>

static Panel_item	msgBox;
static int		errorMsgDisplayed = 0;



/*
 * InitMessageSW
 *
 * Input:
 *	none.
 * Output:
 *	none.
 * Action:
 *	Create a panel window for displaying messages from FontTool.
 */
void
InitMessageSW()
{
    MessageSW = window_create(FontToolFrame, PANEL, 0);
    msgBox = panel_create_item(MessageSW, PANEL_MESSAGE,
	PANEL_LABEL_STRING, "Welcome to FontTool.  Left button paints, \
				middle erases, right undoes.",
	WIN_CURSOR,	    MainCursor,
	0);
    window_fit_height(MessageSW);
}



/*
 * ShowMsg
 *
 * Input:
 *	msg: A message to be displayed in the Message subwindow.
 * Output:
 *	none.
 * Action:
 *	Prints the given message in the Message subwindow.  If it's an
 *	error message, it rings a bell and flashes the MessageSW.
 */
void
ShowMsg(msg)
char *msg;
{
    if (*msg == '*') {
	errorMsgDisplayed++;
	window_bell(MessageSW);
    }
    else {
	errorMsgDisplayed = 0;
    }
    panel_set(msgBox, PANEL_LABEL_STRING, msg, 0);
}



/*
 * ClearMsg
 *
 * Input:
 *	none.
 * Output:
 *	none.
 * Action:
 *	Clears the Message subwindow IF it is currently displaying
 *	an error message, otherwise leaves it alone.
 */
void
ClearMsg()
{
    if (errorMsgDisplayed) {
	panel_set(msgBox, PANEL_LABEL_STRING, "", 0);
    }
    errorMsgDisplayed = 0;
}



/*
 * Confirm
 *
 * Input:
 *	none.
 * Output:
 *	1 if the user has confirmed his action with the left mouse button,
 *	0 otherwise.
 * Action:
 *	Waits for the user to confirm or cancel some action.  This can be
 *	done by pressing the appropriate mouse button anywhere on the screen.
 */
int
Confirm()
{
    int framefd;
    struct fullscreen *screen;
    Event event;
    int result;

    framefd = (int) window_get(FontToolFrame, WIN_FD);
    screen = fullscreen_init(framefd);
    while (1) {
	if (input_readevent(framefd, &event) == -1) {
	    AbortWithError("Confirm: input_readevent failed.");
	}
	switch (event.ie_code) {
	    case MS_LEFT:
		result = 1;
		break;
	    case MS_MIDDLE:
		result = 0;
		break;
	    case MS_RIGHT:
		result = 0;
		break;
	    default:
		continue;
	}
	fullscreen_destroy(screen);
	ClearMsg();
	return(result);
    }
}
