/*
 * File:
 *
 *	global.c
 *
 * Author:
 *
 *	Brad Rullman
 *	Department of Computer Science  FR-35
 *	University of Washington
 *	Seattle, Washington  98155
 *	email: ecola@cs.washington.edu
 *
 *	Copyright @ March, 1987 - This program, or any subset of the functions
 *	herein, is not to be redistributed, or used for personal or commercial
 *	gain in the form of fame, fortune, or shorter working hours, without
 *	the consent of the author.
 *
 * Function:
 *
 *	Contains the definitions of global data structures used
 *	throughout the FontTool program. These definitions may be
 *	accessed by including global.h, which has extern declarations
 *	for all the defintions made within this file.
 */

#include "global.h"

/*
 ******************** Globals for the SunView package  ***********************
 */

Frame	FontToolFrame;
Panel	MessageSW;
Panel	OptionSW;
Canvas	ViewSW;
Pixwin	*ViewPW;
Canvas	PaintSW;
Pixwin	*PaintPW;

Rect 	MessageRect;		/* current size of Message subwindow */
Rect	ViewRect;		/* current size of View subwindow */
Rect	OptionRect;		/* current size of Option subwindow */
Rect	PaintRect;		/* current size of Paint subwindow */

int	OptionSWHeight;

/*
 ******************** Global pixrects and associated data ********************
 */

Pixrect		*ViewPR = NULL;		/* pixrect mapping View subwindow */
Pixrect		*UndoPR = NULL;		/* maps ViewSW 1 paint op previous */
Rect		UndoRect;		/* bounding box of UndoPR changes */
Pixrect		*PaintPR = NULL;	/* pixrect mapping Paint subwindow */
Pixrect 	*ReferencePoint;	/* describes ref pt in PaintSW */
struct pr_pos	ReferenceXY;		/* loc of reference pt in PaintSW */
struct pr_pos	UndoReferenceXY;	/* previous loc of reference point */
int		RasterChanged=0;	/* 1 if contents of PaintSW altered */

/*
 ******************** Option globals *****************************************
 */

int	Magnification 	= MAXMAG;	/* current magnification in PaintSW */
int	CellType 	= CELLNORMAL;	/* current type of cell in PaintSW */
int	MouseMode 	= MODEPOINTS;	/* current drawing mode of mouse */
int	PaintColor;			/* current paint color */

/*
 * CellOffset is the maximum number of pixels in a circular cell that
 * extend past each border of the simple square bounding box described by
 * Magnification.  I.e. this is the amount of overlap that occurs when a
 * circular cell is drawn in our PaintSW "grid" composed of Magnification-
 * by-Magnification squares.
 */
int	CellOffset = 2;		/* since initial Magnification is 10 and 
			   	   WriteBlackCell10 is 14 pixels wide */

/*
 * Points to current circular cell to use as mask if "Write-Black"
 * or "Write-White" options selected.  Depends on the current Magnification.
 */
Pixrect	*CellMask = &WriteBlackCell10;

/*
 ******************** Cell Masks *********************************************
 */

/*
 * Define a mask for each Magnification, to be used when the "Write-Black"
 * or "Write-White" options are selected.  Each mask is in the shape of a 
 * circle (or as close to a circle as we can get at this size and resolution)
 * so we can simulate the dots that a "real" output device draws.
 * BTW, these were drawn with "icontool", as were the cursors.
 */
static short cell10_data[14] = {
    0x0FC0, 0x1FE0, 0x3FF0, 0x7FF8, 0xFFFC, 0xFFFC, 0xFFFC, 0xFFFC,
    0xFFFC, 0xFFFC, 0x7FF8, 0x3FF0, 0x1FE0, 0x0FC0,
};
mpr_static(WriteBlackCell10, 14, 14, 1, cell10_data);

static short cell8_data[12] = {
    0x0600, 0x1F80, 0x3FC0, 0x7FE0, 0x7FE0, 0xFFF0, 0xFFF0, 0x7FE0,
    0x7FE0, 0x3FC0, 0x1F80, 0x0600,
};
mpr_static(WriteBlackCell8, 14, 14, 1, cell8_data);

static short cell6_data[8] = {
    0x3C00, 0x7E00, 0xFF00, 0xFF00, 0xFF00, 0xFF00, 0x7E00, 0x3C00,
};
mpr_static(WriteBlackCell6, 14, 14, 1, cell6_data);

static short cell4_data[6] = {
    0x3000, 0x7800, 0xFC00, 0xFC00, 0x7800, 0x3000,
};
mpr_static(WriteBlackCell4, 14, 14, 1, cell4_data);

/*
 ******************** FontTool cursors ***************************************
 */

/*
 * Define the main cursor.
 */
static short cursorData[16] = {
    0xFE00, 0xFC00, 0xF800, 0xFC00, 0xFE00, 0xDF00, 0x8F80, 0x07C0,
    0x03E0, 0x01F0, 0x00F8, 0x007C, 0x003E, 0x001E, 0x000C, 0x0000,
};
mpr_static(CursorPR, 16, 16, 1, cursorData);
Cursor MainCursor, PaintCursor;

/*
 * Define a cursor in the shape of a watch, to be displayed when we
 * want to indicate to the user that a time-consuming operation is
 * being performed.
 */
static short watchCursorData[16] = {
    0x1FF0, 0x1FF0, 0x3FF8, 0x4104, 0x8822, 0x8002, 0x8002, 0xA10B,
    0x8283, 0x8442, 0x9022, 0x8012, 0x4104, 0x3FF8, 0x1FF0, 0x1FF0,
};
mpr_static(WatchCursorPR, 16, 16, 1, watchCursorData);
Cursor WatchCursor, PaintWatchCursor;
