#define banner "This is CTANGLE ($Revision: 1.1 $)\n" \

#define max_bytes 90000 \

#define max_toks 210000
#define max_names 4000 \

#define max_texts 2500
#define hash_size 353
#define longest_name 400
#define stack_size 50
#define buf_size 100 \

#line 1 "common.h"

#define tangle 0
#define weave 1 \

#define and_and 04
#define tab_mark 011
#define line_feed 012
#define form_feed 014
#define carriage_return 015
#define gt_gt 020
#define lt_lt 022
#define plus_plus 013
#define minus_minus 01
#define minus_gt 031
#define not_eq 032
#define lt_eq 034
#define gt_eq 035
#define eq_eq 036
#define or_or 037 \

#define length(c)(c+1)->byte_start-(c)->byte_start
#define print_id(c)ASCII_write((c)->byte_start,length((c))) \

#define llink link
#define rlink dummy.Rlink
#define root name_dir->rlink \
 \

#define spotless 0
#define harmless_message 1
#define error_message 2
#define fatal_message 3
#define mark_harmless {if(history==spotless)history= harmless_message;}
#define mark_error history= error_message
#define confusion(s)fatal("! This can't happen: ",s)
#define fatal(s1,s2){ \
printf(s1);err_print(s2); \
history= fatal_message;wrap_up(); \
}
#define overflow(string){ \
printf("\n! Sorry, %s capacity exceeded",string);fatal("",""); \
} \

#define max_file_name_length 60
#define cur_file file[include_depth]
#define cur_file_name file_name[include_depth]
#define web_file_name file_name[0]
#define cur_line line[include_depth] \

#define update_terminal fflush(stdout)
#define new_line putchar('\n')
#define putxchar putchar
#define ASCII_write(a,b)fflush(stdout),write(1,a,b)
#define line_write(c)write(fileno(C_file),c)
#define C_printf(c,a)fprintf(C_file,c,a)
#define C_putc(c)putc(c,C_file) \

#define equiv equiv_or_xref \

#define module_flag max_texts \

#define string 02
#define join 0177 \

#define cur_end cur_state.end_field
#define cur_byte cur_state.byte_field
#define cur_name cur_state.name_field
#define cur_repl cur_state.repl_field
#define cur_mod cur_state.mod_field \

#define module_number 0201
#define identifier 0202 \

#define misc 0
#define num_or_id 1
#define unbreakable 3
#define verbatim 4 \

#define ignore 0
#define ascii_constant 0302
#define control_text 0303
#define format 0304
#define definition 0305
#define begin_C 0306
#define module_name 0307
#define new_module 0310 \

#define constant 03 \

#define compress(c)if(loc++<=limit)return(c) \

#define macro 0
#define app_repl(c){if(tok_ptr==tok_mem_end)overflow("token");*tok_ptr++= c;} \

/*2:*/
#line 47 "tangle.web"

/*5:*/
#line 25 "common.h"

#include <stdio.h>

/*:5*//*48:*/
#line 644 "tangle.web"

#include "ctype.h" 

/*:48*/
#line 48 "tangle.web"

/*4:*/
#line 19 "common.h"

typedef short boolean;
typedef char unsigned eight_bits;
extern boolean program;
extern int phase;

/*:4*//*6:*/
#line 45 "common.h"

typedef char ASCII;
typedef char outer_char;
extern ASCII xord[];
extern outer_char xchr[];
ASCII mod_text[longest_name+1];
ASCII*mod_text_end= mod_text+longest_name;
ASCII*id_first;
ASCII*id_loc;

/*:6*//*7:*/
#line 57 "common.h"

extern ASCII buffer[];
extern ASCII*buffer_end;
extern ASCII*loc;
extern ASCII*limit;

/*:7*//*8:*/
#line 72 "common.h"

typedef struct name_info{
ASCII*byte_start;
struct name_info*link;
union{
struct name_info*Rlink;

char Ilk;
}dummy;
ASCII*equiv_or_xref;
}name_info;
typedef name_info*name_pointer;
typedef name_pointer*hash_pointer;
extern ASCII byte_mem[];
extern ASCII*byte_mem_end;
extern name_info name_dir[];
extern name_pointer name_dir_end;
extern name_pointer name_ptr;
extern ASCII*byte_ptr;
extern name_pointer hash[];
extern hash_pointer hash_end;
extern hash_pointer h;
extern name_pointer id_lookup();
extern name_pointer mod_lookup();
extern name_pointer prefix_lookup();

/*:8*//*9:*/
#line 114 "common.h"

extern history;

/*:9*//*10:*/
#line 125 "common.h"

extern include_depth;
extern FILE*file[];
extern FILE*change_file;
extern char C_file_name[];
extern char tex_file_name[];
extern char file_name[][max_file_name_length];

extern char change_file_name[];
extern line[];
extern change_line;
extern boolean input_has_ended;
extern boolean changing;

/*:10*//*11:*/
#line 140 "common.h"

typedef unsigned short sixteen_bits;
extern sixteen_bits module_count;
extern boolean changed_module[];
extern boolean print_where;

/*:11*//*12:*/
#line 147 "common.h"

extern int argc;
extern char**argv;
extern no_xref;

/*:12*//*13:*/
#line 160 "common.h"

extern FILE*C_file;
extern FILE*tex_file;
#line 83 "tangle.web"

/*:13*/
#line 49 "tangle.web"

/*14:*/
#line 107 "tangle.web"

typedef struct{
eight_bits*tok_start;
sixteen_bits text_link;
}text;
typedef text*text_pointer;

/*:14*//*25:*/
#line 245 "tangle.web"

typedef struct{
eight_bits*end_field;
eight_bits*byte_field;
name_pointer name_field;
text_pointer repl_field;
sixteen_bits mod_field;
}output_state;
typedef output_state*stack_pointer;

/*:25*/
#line 50 "tangle.web"

/*15:*/
#line 114 "tangle.web"

text text_info[max_texts];
text_pointer text_info_end= text_info+max_texts-1;
text_pointer text_ptr;
eight_bits tok_mem[max_toks];
eight_bits*tok_mem_end= tok_mem+max_toks-1;
eight_bits*tok_ptr;

/*:15*//*21:*/
#line 178 "tangle.web"

text_pointer last_unnamed;

/*:21*//*26:*/
#line 261 "tangle.web"

output_state cur_state;

output_state stack[stack_size+1];
stack_pointer stack_ptr;
stack_pointer stack_end= stack+stack_size;

/*:26*//*30:*/
#line 326 "tangle.web"

int cur_val;

/*:30*//*33:*/
#line 401 "tangle.web"

eight_bits out_state;
boolean protect;

/*:33*//*42:*/
#line 569 "tangle.web"

eight_bits ccode[128];

/*:42*//*45:*/
#line 609 "tangle.web"

boolean comment_continues= 0;

/*:45*//*47:*/
#line 641 "tangle.web"

name_pointer cur_module;

/*:47*//*61:*/
#line 896 "tangle.web"

text_pointer cur_text;
eight_bits next_control;

/*:61*//*68:*/
#line 1006 "tangle.web"

extern sixteen_bits module_count;

/*:68*/
#line 51 "tangle.web"


main(ac,av)
char**av;
{
argc= ac;argv= av;
program= tangle;
/*16:*/
#line 122 "tangle.web"

text_info->tok_start= tok_ptr= tok_mem;
text_ptr= text_info+1;text_ptr->tok_start= tok_mem;


/*:16*//*18:*/
#line 132 "tangle.web"

name_dir->equiv= (ASCII*)text_info;

/*:18*//*22:*/
#line 181 "tangle.web"
last_unnamed= text_info;text_info->text_link= 0;

/*:22*//*43:*/
#line 572 "tangle.web"
{
int c;
for(c= 0;c<=127;c++)ccode[c]= ignore;
ccode[' ']= ccode[tab_mark]= ccode['*']= new_module;
ccode['@']= '@';ccode['=']= string;
ccode['d']= ccode['D']= definition;ccode['f']= ccode['F']= format;
ccode['c']= ccode['C']= begin_C;
ccode['^']= ccode[':']= ccode['.']= ccode['t']= ccode['T']= control_text;
ccode['&']= join;ccode['<']= module_name;
ccode['\'']= ascii_constant;
}

/*:43*//*57:*/
#line 824 "tangle.web"
mod_text[0]= ' ';

/*:57*/
#line 58 "tangle.web"
;
common_init();
printf(banner);
phase_one();
phase_two();
wrap_up();
}

/*:2*//*19:*/
#line 138 "tangle.web"

names_match(p,first,l)
name_pointer p;
ASCII*first;
int l;
{
if(length(p)!=l)return 0;
return!strncmp(first,p->byte_start,l);
}

/*:19*//*20:*/
#line 151 "tangle.web"

init_node(node)
name_pointer node;
{
node->equiv= (ASCII*)text_info;
}
init_p(){}

/*:20*//*24:*/
#line 211 "tangle.web"
store_two_bytes(x)
sixteen_bits x;
{
if(tok_ptr+2>tok_mem_end)overflow("token");
*tok_ptr++= x>>8;
*tok_ptr++= x&0377;
}

/*:24*//*28:*/
#line 285 "tangle.web"
push_level(p)
name_pointer p;
{
if(stack_ptr==stack_end)overflow("stack");
*stack_ptr= cur_state;
stack_ptr++;
cur_name= p;cur_repl= (text_pointer)p->equiv;
cur_byte= cur_repl->tok_start;cur_end= (cur_repl+1)->tok_start;
cur_mod= 0;
}

/*:28*//*29:*/
#line 300 "tangle.web"
pop_level()
{
if(cur_repl->text_link<module_flag){
cur_repl= cur_repl->text_link+text_info;
cur_byte= cur_repl->tok_start;cur_end= (cur_repl+1)->tok_start;
return;
}
stack_ptr--;
if(stack_ptr>stack)cur_state= *stack_ptr;
}

/*:29*//*31:*/
#line 331 "tangle.web"
sixteen_bits
get_output()
{
sixteen_bits a;
restart:if(stack_ptr==stack)return 0;
if(cur_byte==cur_end){
cur_val= -((int)cur_mod);
pop_level();
if(cur_val==0)goto restart;
out_char(module_number);return;
}
a= *cur_byte++;
if(a<0200)out_char(a);
else{
a= (a-0200)*0400+*cur_byte++;
switch(a/024000){
case 0:cur_val= a;out_char(identifier);break;
case 1:/*32:*/
#line 359 "tangle.web"

a-= 024000;
if((a+name_dir)->equiv!=(ASCII*)text_info)push_level(a+name_dir);
else if(a!=0){
printf("\n! Not present: <");print_id(a+name_dir);err_print(">");

}
goto restart;

/*:32*/
#line 348 "tangle.web"
;
default:cur_val= a-050000;if(cur_val>0)cur_mod= cur_val;
out_char(module_number);
}
}
return 1;
}

/*:31*//*34:*/
#line 409 "tangle.web"
flush_buffer()
{
C_putc('\n');
if(cur_line%100==0){
printf(".");
if(cur_line%500==0)printf("%d",cur_line);
update_terminal;
}
cur_line++;
}

/*:34*//*35:*/
#line 423 "tangle.web"

phase_two(){
cur_line= 1;
/*36:*/
#line 443 "tangle.web"
{
sixteen_bits a;
for(cur_text= text_info+1;cur_text<text_ptr;cur_text++)
if(cur_text->text_link==0){
cur_byte= cur_text->tok_start;
cur_end= (cur_text+1)->tok_start;
C_printf("#define ",0);
out_state= misc;
protect= 1;
while(cur_byte<cur_end){
a= *cur_byte++;
if(cur_byte==cur_end&&a=='\n')break;
if(a<0200)out_char(a);
else{
a= (a-0200)*0400+*cur_byte++;
if(a<024000){
cur_val= a;out_char(identifier);
}
else if(a<050000){confusion("macros defs have strange char");}
else{
cur_val= a-050000;cur_mod= cur_val;out_char(module_number);
}

}
}
protect= 0;
flush_buffer();
}
}

/*:36*/
#line 426 "tangle.web"
;
if(text_info->text_link==0){
printf("\n! No program text was specified.");mark_harmless;

}
else{
printf("\nWriting the output file");update_terminal;
/*27:*/
#line 274 "tangle.web"

stack_ptr= stack+1;cur_name= name_dir;cur_repl= text_info->text_link+text_info;
cur_byte= cur_repl->tok_start;cur_end= (cur_repl+1)->tok_start;cur_mod= 0;

/*:27*/
#line 433 "tangle.web"
;
while(stack_ptr>stack)get_output();
flush_buffer();
printf("\nDone.");
}
}

/*:35*//*37:*/
#line 475 "tangle.web"
out_char(cur_char)
eight_bits cur_char;
{
ASCII*j;
switch(cur_char){
case'\n':if(protect)C_putc(' ');
if(protect||out_state==verbatim)C_putc('\\');
flush_buffer();if(out_state!=verbatim)out_state= misc;break;
/*39:*/
#line 515 "tangle.web"

case identifier:
if(out_state==num_or_id)C_putc(' ');
for(j= (cur_val+name_dir)->byte_start;j<(name_dir+cur_val+1)->byte_start;
j++)C_putc(*j);
out_state= num_or_id;break;

/*:39*/
#line 483 "tangle.web"
;
/*40:*/
#line 522 "tangle.web"

case module_number:
if(cur_val>0)C_printf("/*%d:*/",cur_val);
else if(cur_val<0)C_printf("/*:%d*/",-cur_val);
else{
sixteen_bits a;
a= 0400**cur_byte++;
a+= *cur_byte++;
C_printf("\n#line %d \"",a);
cur_val= *cur_byte++;
cur_val= 0400*(cur_val-0200)+*cur_byte++;
for(j= (cur_val+name_dir)->byte_start;j<(name_dir+cur_val+1)->byte_start;
j++)C_putc(*j);
C_printf("\"\n",0);
}
break;

/*:40*/
#line 484 "tangle.web"
;
/*38:*/
#line 502 "tangle.web"

case plus_plus:C_putc('+');C_putc('+');out_state= misc;break;
case minus_minus:C_putc('-');C_putc('-');out_state= misc;break;
case minus_gt:C_putc('-');C_putc('>');out_state= misc;break;
case gt_gt:C_putc('>');C_putc('>');out_state= misc;break;
case eq_eq:C_putc('=');C_putc('=');out_state= misc;break;
case lt_lt:C_putc('<');C_putc('<');out_state= misc;break;
case gt_eq:C_putc('>');C_putc('=');out_state= misc;break;
case lt_eq:C_putc('<');C_putc('=');out_state= misc;break;
case not_eq:C_putc('!');C_putc('=');out_state= misc;break;
case and_and:C_putc('&');C_putc('&');out_state= misc;break;
case or_or:C_putc('|');C_putc('|');out_state= misc;break;

/*:38*/
#line 485 "tangle.web"
;
case'=':C_putc('=');if(out_state!=verbatim){
C_putc(' ');out_state= misc;
}
break;
case join:out_state= unbreakable;break;
case constant:if(out_state==verbatim){
out_state= num_or_id;break;
}
if(out_state==num_or_id)C_putc(' ');out_state= verbatim;break;
case string:if(out_state==verbatim)out_state= misc;
else out_state= verbatim;break;
default:C_putc(cur_char);if(out_state!=verbatim)out_state= misc;
break;
}
}

/*:37*//*44:*/
#line 587 "tangle.web"
eight_bits skip_ahead()
{
eight_bits c;
while(1){
if(loc>limit&&(get_line()==0))return(new_module);
*(limit+1)= '@';
while(*loc!='@')loc++;
if(loc<=limit){
loc++;c= ccode[*loc];loc++;
if(c!=ignore||*(loc-1)=='>')return(c);
}
}
}

/*:44*//*46:*/
#line 612 "tangle.web"

skip_comment()
{
ASCII c;
while(1){
if(loc>limit)
if(get_line())return(comment_continues= 1);
else{
err_print("! Input ended in mid-comment");

return(comment_continues= 0);
}
c= *(loc++);
if(c=='*'&&*loc=='/'){loc++;return(comment_continues= 0);}
if(c=='@'){
if(ccode[*loc]==new_module){
err_print("! Section name ended in mid-comment");loc--;

return(comment_continues= 0);
}
else loc++;
}
}
}

/*:46*//*49:*/
#line 650 "tangle.web"
eight_bits get_next()
{
static int preprocessing= 0;
eight_bits c;
while(1){
if(loc>limit){
if(preprocessing&&*(limit-1)!='\\')preprocessing= 0;
if(get_line()==0)return(new_module);
else if(print_where){
print_where= 0;
/*63:*/
#line 924 "tangle.web"

store_two_bytes(0150000);
if(changing)id_first= change_file_name;
else id_first= cur_file_name;
id_loc= id_first+strlen(id_first);
if(changing)store_two_bytes((sixteen_bits)change_line);
else store_two_bytes((sixteen_bits)cur_line);
{int a= id_lookup(id_first,id_loc)-name_dir;app_repl((a/0400)+0200);
app_repl(a%0400);}

/*:63*/
#line 660 "tangle.web"
;
}
else return('\n');
}
c= *loc;
if(comment_continues||(c=='/'&&*(loc+1)=='*')){
skip_comment();
if(comment_continues)return('\n');
else continue;
}
loc++;
if(isdigit(c)||c=='\\'||c=='.')/*52:*/
#line 714 "tangle.web"
{
id_first= loc-1;
if(*id_first=='.'&&!isdigit(*loc))goto mistake;
if(*id_first=='\\')while(isdigit(*loc))loc++;
else{
if(*id_first=='0'){
if(*loc=='x'||*loc=='X'){
loc++;while(isxdigit(*loc))loc++;goto found;
}
}
while(isdigit(*loc)||*loc=='.')loc++;
if(*loc=='e'||*loc=='E'){
if(*++loc=='+'||*loc=='-')loc++;
while(isdigit(*loc))loc++;
}
}
found:if(*loc=='l'||*loc=='L')loc++;
id_loc= loc;
return(constant);
}

/*:52*/
#line 671 "tangle.web"

else if(isalpha(c)||c=='_')/*51:*/
#line 708 "tangle.web"
{
id_first= --loc;
while(isalpha(*++loc)||isdigit(*loc)||*loc=='_');
id_loc= loc;return(identifier);
}

/*:51*/
#line 672 "tangle.web"

else if(c=='\''||c=='\"')/*53:*/
#line 740 "tangle.web"
{
ASCII delim= c;
id_first= mod_text+1;
id_loc= mod_text;*++id_loc= delim;
while(1){
if(loc>=limit){
if(*(limit-1)!='\\'){
err_print("! String didn't end");loc= limit;break;

}
if(get_line()==0){
err_print("! Input ended in middle of string");loc= buffer;break;

}
else if(++id_loc<=mod_text_end)*id_loc= '\n';

}
if((c= *loc++)==delim){
if(++id_loc<=mod_text_end)*id_loc= c;
break;
}
if(c=='\\'){
if(loc>=limit)continue;
if(++id_loc<=mod_text_end)*id_loc= '\\';
c= *loc++;
}
if(++id_loc<=mod_text_end)*id_loc= c;
}
if(id_loc>=mod_text_end){
printf("\n! String too long: ");

ASCII_write(mod_text+1,25);
printf("...");mark_error;
}
id_loc++;
return(string);
}

/*:53*/
#line 673 "tangle.web"

else if(c=='@')/*54:*/
#line 781 "tangle.web"
{
c= ccode[*loc++];
switch(c){
case ignore:continue;
case control_text:while((c= skip_ahead())=='@');

if(*(loc-1)!='>')err_print("! Improper @ within control text");

continue;
case module_name:/*56:*/
#line 810 "tangle.web"
{
ASCII*k;
/*58:*/
#line 826 "tangle.web"

k= mod_text;
while(1){
if(loc>limit&&get_line()==0){
err_print("! Input ended in section name");

loc= buffer+1;break;
}
c= *loc;
/*59:*/
#line 850 "tangle.web"

if(c=='@'){
c= *(loc+1);
if(c=='>'){
loc+= 2;break;
}
if(ccode[c]==new_module){
err_print("! Section name didn't end");break;

}
*(++k)= '@';loc++;
}

/*:59*/
#line 835 "tangle.web"
;
loc++;if(k<mod_text_end)k++;
if(c==' '||c==tab_mark){
c= ' ';if(*(k-1)==' ')k--;
}
*k= c;
}
if(k>=mod_text_end){
printf("\n! Section name too long: ");

ASCII_write(mod_text+1,25);
printf("...");mark_harmless;
}
if(*k==' '&&k>mod_text)k--;

/*:58*/
#line 812 "tangle.web"
;
if(k-mod_text>3&&strncmp(k-2,"...",3)==0)cur_module= prefix_lookup(mod_text+1,k-3);
else cur_module= mod_lookup(mod_text+1,k);
return(module_name);
}

/*:56*/
#line 791 "tangle.web"
;
case string:/*60:*/
#line 868 "tangle.web"
{
id_first= loc++;*(limit+1)= '@';*(limit+2)= '>';
while(*loc!='@'||*(loc+1)!='>')loc++;
if(loc>=limit)err_print("! Verbatim string didn't end");

id_loc= loc;loc+= 2;
return(string);
}

/*:60*/
#line 792 "tangle.web"
;
case ascii_constant:/*55:*/
#line 798 "tangle.web"

id_first= loc;
if(*loc=='\\')loc++;
while(*loc!='\''){
loc++;
if(loc>limit){
err_print("! String didn't end");loc= limit-1;break;
}
}
loc++;
return(ascii_constant);

/*:55*/
#line 793 "tangle.web"
;
default:return(c);
}
}

/*:54*/
#line 674 "tangle.web"

else if(c==' '||c==tab_mark){
if(!preprocessing||loc>limit)continue;

else return(' ');
}
else if(c=='#'&&loc==buffer+1)preprocessing= 1;
mistake:/*50:*/
#line 693 "tangle.web"

switch(c){
case'+':if(*loc=='+')compress(plus_plus);break;
case'-':if(*loc=='-'){compress(minus_minus);}
else if(*loc=='>')compress(minus_gt);break;
case'=':if(*loc=='=')compress(eq_eq);break;
case'>':if(*loc=='='){compress(gt_eq);}
else if(*loc=='>')compress(gt_gt);break;
case'<':if(*loc=='='){compress(lt_eq);}
else if(*loc=='<')compress(lt_lt);break;
case'&':if(*loc=='&')compress(and_and);break;
case'|':if(*loc=='|')compress(or_or);break;
case'!':if(*loc=='=')compress(not_eq);break;
}

/*:50*/
#line 681 "tangle.web"

return(c);
}
}

/*:49*//*62:*/
#line 900 "tangle.web"
scan_repl(t)
eight_bits t;
{
sixteen_bits a;
if(t==module_name){/*63:*/
#line 924 "tangle.web"

store_two_bytes(0150000);
if(changing)id_first= change_file_name;
else id_first= cur_file_name;
id_loc= id_first+strlen(id_first);
if(changing)store_two_bytes((sixteen_bits)change_line);
else store_two_bytes((sixteen_bits)cur_line);
{int a= id_lookup(id_first,id_loc)-name_dir;app_repl((a/0400)+0200);
app_repl(a%0400);}

/*:63*/
#line 904 "tangle.web"
;}
while(1)switch(a= get_next()){
/*64:*/
#line 934 "tangle.web"

case identifier:a= id_lookup(id_first,id_loc)-name_dir;app_repl((a/0400)+0200);
app_repl(a%0400);break;
case module_name:if(t!=module_name)goto done;
else{
/*65:*/
#line 956 "tangle.web"
{
ASCII*try_loc= loc;
while(*try_loc==' '&&try_loc<limit)try_loc++;
if(*try_loc=='+'&&try_loc<limit)try_loc++;
while(*try_loc==' '&&try_loc<limit)try_loc++;
if(*try_loc=='=')err_print("! Nested named modules.  Missing @?");

}

/*:65*/
#line 939 "tangle.web"
;
a= cur_module-name_dir;
app_repl((a/0400)+0250);
app_repl(a%0400);
/*63:*/
#line 924 "tangle.web"

store_two_bytes(0150000);
if(changing)id_first= change_file_name;
else id_first= cur_file_name;
id_loc= id_first+strlen(id_first);
if(changing)store_two_bytes((sixteen_bits)change_line);
else store_two_bytes((sixteen_bits)cur_line);
{int a= id_lookup(id_first,id_loc)-name_dir;app_repl((a/0400)+0200);
app_repl(a%0400);}

/*:63*/
#line 943 "tangle.web"
;break;
}
case constant:case string:
/*66:*/
#line 965 "tangle.web"

app_repl(a);
while(id_first<id_loc){
if(*id_first=='@')id_first++;
app_repl(*id_first++);
}
app_repl(a);break;

/*:66*/
#line 946 "tangle.web"
;
case ascii_constant:
/*67:*/
#line 973 "tangle.web"
{
int c;
if(*id_first=='@'){
c= xchr[*id_first++];
if(*id_first!='@')err_print("! Double @ within string");
}
else if(*id_first=='\\'){
id_first++;
switch(*id_first){
case't':c= '\t';break;
case'n':c= '\n';break;
case'b':c= '\b';break;
case'0':c= '\0';break;
case'\\':c= '\\';break;
default:err_print("! Unrecognized escape sequence");
}
}
else c= xchr[*id_first];
app_repl(constant);
app_repl('0');
app_repl('0'+(c>>6));
app_repl('0'+((c-0100*(c>>6))>>3));
app_repl('0'+(c-010*(c>>3)));
app_repl(constant);
}
break;

/*:67*/
#line 948 "tangle.web"
;
case definition:case format:case begin_C:if(t!=module_name)goto done;
else{
err_print("! @d, @f and @c are ignored in C text");continue;

}
case new_module:goto done;

/*:64*/
#line 909 "tangle.web"

default:app_repl(a);
}
done:next_control= (eight_bits)a;
if(text_ptr>text_info_end)overflow("text");
cur_text= text_ptr;(++text_ptr)->tok_start= tok_ptr;
}

/*:62*//*69:*/
#line 1010 "tangle.web"
scan_module()
{
name_pointer p;
text_pointer q;
sixteen_bits a;
module_count++;
if(*(loc-1)=='*')
printf("*%d",module_count);fflush(stdout);
/*70:*/
#line 1022 "tangle.web"

next_control= 0;
while(1){
while(next_control<=format)
if((next_control= skip_ahead())==module_name){
loc-= 2;next_control= get_next();
}
if(next_control!=definition)break;
while((next_control= get_next())=='\n');
if(next_control!=identifier){
err_print("! Definition flushed, must start with identifier");

continue;
}
app_repl(((a= id_lookup(id_first,id_loc)-name_dir)/0400)+0200);
app_repl(a%0400);
if(*loc!='('){
app_repl(string);app_repl(' ');app_repl(string);
}
scan_repl(macro);
cur_text->text_link= 0;
}

/*:70*/
#line 1018 "tangle.web"
;
/*71:*/
#line 1045 "tangle.web"

switch(next_control){
case begin_C:p= name_dir;break;
case module_name:p= cur_module;
/*72:*/
#line 1057 "tangle.web"

while((next_control= get_next())=='+');
if(next_control!='='&&next_control!=eq_eq){
err_print("! C text flushed, = sign is missing");

while((next_control= skip_ahead())!=new_module);
return;
}

/*:72*/
#line 1049 "tangle.web"
;
break;
default:return;
}
/*73:*/
#line 1066 "tangle.web"

store_two_bytes((sixteen_bits)(0150000+module_count));


/*:73*/
#line 1053 "tangle.web"
;
scan_repl(module_name);
/*74:*/
#line 1070 "tangle.web"

if(p==name_dir||p==0){
(last_unnamed)->text_link= cur_text-text_info;last_unnamed= cur_text;
}
else if(p->equiv==(ASCII*)text_info)p->equiv= (ASCII*)cur_text;

else{
q= (text_pointer)p->equiv;
while(q->text_link<module_flag)q= q->text_link+text_info;
q->text_link= cur_text-text_info;
}
cur_text->text_link= module_flag;

/*:74*/
#line 1055 "tangle.web"
;

/*:71*/
#line 1019 "tangle.web"
;
}

/*:69*//*75:*/
#line 1083 "tangle.web"
phase_one(){
phase= 1;
module_count= 0;
reset_input();
while((next_control= skip_ahead())!=new_module);
while(!input_has_ended)scan_module();
check_complete();
phase= 2;
}

/*:75*//*76:*/
#line 1093 "tangle.web"
print_stats(){
printf("\nMemory usage statistics:\n");
printf("%d names (out of %d)\n",name_ptr-name_dir,max_names);
printf("%d replacement texts (out of %d)\n",text_ptr-text_info,max_texts);
printf("%d bytes (out of %d)\n",byte_ptr-byte_mem,max_bytes);
printf("%d tokens (out of %d)\n",tok_ptr-tok_mem,max_toks);
}

/*:76*/
