#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>

#define NAMSIZ		76
#define	SYNC	0x004	/* 1 => window is out of sync */

typedef enum {FALSE, TRUE} bool;

struct iorec {
	char		*fileptr;	/* ptr to file window */
	long		lcount;		/* number of lines printed */
	long		llimit;		/* maximum number of text lines */
	FILE		*fbuf;		/* FILE ptr */
	struct iorec	*fchain;	/* chain to next file */
	struct iorec	*flev;		/* ptr to associated file variable */
	char		*pfname;	/* ptr to name of file */
	short		funit;		/* file status flags */
	unsigned short	fblk;		/* index into active file table */
	long		fsize;		/* size of elements in the file */
	char		fname[NAMSIZ];	/* name of associated UNIX file */
	char		buf[BUFSIZ];	/* I/O buffer */
	char		window[1];	/* file window element */
};

setpos(f, p, m)				/* seek on a pascal file	   */
struct iorec *f;
int p, m;
{
	f->funit |= SYNC;
	(void) fseek (f->fbuf, (long) p, m);
}

int
sizef(f)				/* return size of file		   */
struct iorec *f;
{
	struct stat st;

	(void) fstat (fileno(f->fbuf), &st);
	return (st.st_size);
}

delete(f)				/* remove a link to a file	   */
struct iorec *f;
{
	(void) unlink (f->pfname);
}

bool
readp(filename)				/* check if a file may be read 	   */
char *filename;
{
	register char *p;
        register bool ok;

	for(p=filename; *p!=' '; p++)	/* pascal strings are space-padded */
		;
	*p='\0';			/* make it a C-string		   */
	if (access(filename, 04) == 0)	/* check if we can read this file  */
		ok=TRUE;
	else
		ok=FALSE;
	*p=' ';				/* "re-pasclify" the string	   */
	return(ok);
}

bool
writep(filename)			/* check if a file may be written   */
char *filename;
{
	register char *p;
        register bool ok;
	int f;

	for(p=filename; *p!=' '; p++)	/* pascal strings are space-padded */
		;
	*p='\0';			/* make it a C-string		   */
	if ((f=creat(filename, 0666)) >= 0) {	/* can we create this file?*/
		(void) close(f);
		ok = TRUE;
	} else
		ok = FALSE;
	*p=' ';				/* "re-pasclify" the string	   */
	return(ok);
}

tostdout(f)				/* make file appear on stdout	   */
struct iorec *f;
{
	(void) fflush (f->fbuf);
	f->fbuf = stdout;
}

tostderr(f)				/* make file appear on stderr	   */
struct iorec *f;
{
	(void) fflush (f->fbuf);
	f->fbuf = stderr;
}

bool
ttyp(f)					/* is file associated with a tty?  */
struct iorec *f;
{
	if (isatty(fileno(f->fbuf))==1)
		return(TRUE);
	else
		return(FALSE);
}

bool
popenp(f, path, pthpgm)			/* can this file be piped into a   */
struct iorec  *f;			/*   pager (like more)?		   */
char *path;
bool pthpgm;
{
	char *getenv(), *p;
	FILE *popen(), *g;

	if (pthpgm==FALSE) {			/* -Fpath option used	   */
		for(p=path; *p !=' ' && *p != '\0'; p++)
			;
		*p = '\0';
	} else if ((p=getenv("PAGER"))==NULL) { /* find prefered pager     */
		for(p=path; *p !=' ' && *p != '\0'; p++)
			;			/* didn't have one, use    */
		*p = '\0';			/* the default one for pgm */
	} else
		path = p;			/* default pager from env  */
	if ((g=popen(path, "w"))!=NULL) {	/* get a pipe to the pager */
		(void) fflush (f->fbuf);	/* make output to f go to  */
		f->fbuf = g;			/*   the pager		   */
		return(TRUE);
	} else
		return(FALSE);			/* couldn't do it	   */
}

pcloseit(f)					/* popend stream has to be */
struct iorec *f;				/*   pclosed		   */
{
	(void) pclose (f->fbuf);
}

bool
envargs(optch, str)
char *optch, *str;
{
	char *getenv(), *q;
	static char *p;
	static int foo = 0;

	switch (foo) {
	case 0:	if ((p=getenv("DVITTY"))==NULL)	/* 1st time only, get var  */
			return(FALSE);		/* sorry, no var	   */
		foo++;		/* remember we've been here to next call   */
				/* fall through 			   */
	default:
		if (*p!=' ' && *p!='\0')	/* anything here? 	   */
			*optch = *p++;		/* yes, it's our optchar   */
		else
			return(FALSE);		/* sorry, no more	   */
		q=str;				/* get args or whatever    */
		while (*p!=' ' && *p!='\0')
			*q++ = *p++;
		*q=' ';			/* the pascal program wants ' '    */
		while (*p==' ')		/* step to next or end             */
			p++;
		return(TRUE);
	}
}
