#ifndef lint
static char rcsid[] = "$Header$";
#endif

/*
 * Convert a TeX format font (pxl, gf, pk) into SUN vfont format
 * Quick and dirty implementation.
 *
 *	Lou Salkind
 *	New York University
 */

#include <stdio.h>
#include "../h/types.h"
#include "../h/conv.h"
#include "../h/font.h"

char *ProgName;
extern int errno;
extern char *optarg;
extern int optind;

#define	PTTOSP(x) ((x) << 16)	/* points to scaled points */

int	dpi;
int	dvimag;
int	dvidsz;
int	globalmag;
char	*devspec;
int	rotation;

main(argc, argv)
	register int argc;
	register char **argv;
{
	register int c;

	ProgName = *argv;
	dvimag = PTTOSP(10);
	dvidsz = PTTOSP(10);
	globalmag = 1000;
	dpi = 200;
	rotation = ROT_NORM;
	while ((c = getopt(argc, argv, "D:d:m:g:r:s:")) != EOF) {
		switch (c) {

		case 'D':
			dpi = atoi(optarg);
			break;

		case 'd':
			dvidsz = atoi(optarg);
			break;

		case 'm':
			dvimag = atoi(optarg);
			break;

		case 'g':
			globalmag = atoi(optarg);
			break;

		case 'r':
			rotation = makerot(optarg);
			break;

		case 's':
			devspec = optarg;
			break;

		case '?':
usage:
			error(1, 0, "\
usage: %s [-m dvimag] [-d designsize] [-g globalmag] [-s devspec] font ...",
				ProgName);
			/* NOTREACHED */

		default:
			panic("case %d", c);
			/* NOTREACHED */
		}
	}
	if (optind >= argc)
		goto usage;
	SetConversion(dpi, 1000, 25400000, 473628672, 1000);
	for (c = optind; c < argc; c++)
		show(argv[c]);
	exit(0);
}

makerot(s)
	char *s;
{

	switch (*s) {

	case 'n':
		return (ROT_NORM);

	case 'l':
		return (ROT_LEFT);

	case 'd':
		return (ROT_DOWN);

	case 'r':
		return (ROT_RIGHT);

	case '0': case '1': case '2': case '3':
		return (*s - '0');

	default:
		error(1, 0, "\
valid rotations are `n'ormal, `l'eft, `right', and `d'own");
		/* NOTREACHED */
	}
}

#include <vfont.h>

struct header header;
struct dispatch dispatch[NUM_DISPATCH];

show(s)
	char *s;
{
	register struct font *f;
	register struct glyph *g;
	register int i;
	char *fname;
	int maxx, maxy, offset, rsize;
	char *rast;
	char newfile[256];

	f = GetFont(s, dvimag, dvidsz, devspec, &fname);
	if (f == NULL) {
		GripeCannotGetFont(s, dvimag, dvidsz, devspec, fname);
		exit(1);
	}
	strcpy(newfile, s);
	strcat(newfile, ".v");
	freopen(newfile, "w", stdout);
	if (fseek(stdout, (long)sizeof(header) + sizeof(dispatch), 0) == -1)
		exit(1);
	maxx = 0;
	maxy = 0;
	offset = 0;
	for (i = f->f_lowch; i < f->f_highch; i++) {
		g = GLYPH(f, i);
		if (!GVALID(g))
			continue;
#ifdef notdef
		if (fromSP(g->g_tfmwidth) > maxx)
			maxx = fromSP(g->g_tfmwidth);
#endif
		if (!HASRASTER(g))
			continue;
		rast = RASTER(g, f, rotation);
		if (g->g_height > maxy)
			maxy = g->g_height;
		if (g->g_width > maxx)
			maxx = g->g_width;
		dispatch[i].up = g->g_yorigin;
		dispatch[i].down = g->g_height - g->g_yorigin;
		dispatch[i].left = g->g_xorigin;
		dispatch[i].right = g->g_width - g->g_xorigin;
		dispatch[i].width = fromSP(g->g_tfmwidth);
		rsize = ((g->g_width + 7) / 8) * g->g_height;
		dispatch[i].addr = offset;
		dispatch[i].nbytes = rsize;
		fwrite(rast, rsize, 1, stdout);
		offset += rsize;
	}
	header.magic = VFONT_MAGIC;
	header.size = offset;
	header.maxx = maxx;
	header.maxy = maxy;
	header.xtend = 0;
	if (fseek(stdout, 0L, 0) == -1)
		exit(1);
	fwrite(&header, sizeof(header), 1, stdout);
	fwrite(dispatch, sizeof(dispatch), 1, stdout);
}
