: getdep - get dependency lists.

: change ":" comments to "#" comments if your shell supports those;
: the result will run faster.

: find cpp
cpp=unknown
for where in /lib /usr/lib /bin /usr/bin; do
	if test -f $where/cpp; then cpp=$where/cpp; break; fi
done
if test $cpp = unknown; then
	echo "I cannot find cpp, sorry" 1>&2; exit 1
fi

: handle arguments
incl=
for i
do
	case "$i" in
	-I*)
		incl="$incl $i";;
	*)
		: assume source file
		: put '$dep' in front of dependencies
		dep=`echo "$i" | sed -e 's,/,\\\\/,g' -e 's/\.c$/.o/'`
		: Find includes, remove leading numerics, remove ./,
		: remove double quotes, and remove trailing numerics.
		: Sort that, discarding duplicates, and add '$dep'.
		$cpp $incl "$i" | grep "^#" |
		sed -e 's/# [0-9]* //' -e 's,"./,",' -e 's/"\(.*\)"/\1/' \
		    -e 's/ [ 0-9]*$//' |
		sort -u | sed -e "s/^/$dep: /";;
	esac
done
