#ifndef lint
static char *rcs = "$Header: misc.c,v 1.1 88/01/15 13:04:30 simpson Rel $";
#endif
/*
$Log:	misc.c,v $
 * Revision 1.1  88/01/15  13:04:30  simpson
 * initial release
 * 
 * Revision 0.1  87/12/11  18:31:03  simpson
 * beta test
 * 
*/

/* Miscellaneous routines */

#include <stdio.h>
#include <pwd.h>
#include <local/standard.h>
#include <ctype.h>
#include "constants.h"

/* Same as the tgetent of termcap(3x) but it works for the printcap
 * database.  Use the rest of the termcap(3x) routines after you use
 * this one.
 */
int pgetent(bp, name)
char	*bp;
char	*name;
{
    void    setenv();
    
    setenv("TERMCAP", "/etc/printcap");
    return tgetent(bp, name);
}

/* Changes the uid of the running process to that of `user'. If the `host' is
 * not equal to the current hostname, then a docile uid is switched to.  TRUE
 * is returned if the person selected in the password file exists and the uid
 * is switched, FALSE otherwise.
 */
Boolean setnewid(host, user)
char	*host, *user;
{
    char	    username[51];
    char	    hostname[51];
    char	    *strcpy();
    struct passwd   *passwd;

    (void)strcpy(username, user);
    (void)gethostname(hostname, 51);
    if (!EQ(hostname, host))
	(void)strcpy(username, DOCILEUSER);
    if (!(passwd = getpwnam(username)))
    	return FALSE;
    seteuid(passwd->pw_uid);
    setegid(passwd->pw_gid);
    return TRUE;
}

/* Gets the value of an environment variable just like getenv(3) but
 * instead it reads the value of the environment variable from the user's
 * .profile, .login or .cshrc file depending on what shell they are using.
 * This is useful for processes that are not forked by the user but still
 * wish to know the value of a user's environment variable.  The .cshrc
 * file is searched before the .login file.  The returned value is static
 * and the result is written over after each call as in getenv(3).  NULL is
 * returned if the user does not exist, the file is not readable or the
 * environment variable does not exist.  The string searched for should
 * begin with "<variable name>=" in .profile or "setenv <variable name> "
 * in the .cshrc or .login file.  Continuation lines are handled too.  If
 * the user name that is passed is NULL then the current effective user id
 * will used.
 */
char	*fgetenv(variable, user)
char	*variable;
char	*user;
{
    struct passwd   *passwd;
    static char	    envvariable[201];
    char	    s[201], line[201], *strcpy(), *strcat();
    FILE	    *f;
    Boolean	    continueline;
    Boolean	    bourne;
    Boolean	    dotcshrc = TRUE;

    if (!user) {
	if (!(passwd = getpwuid(geteuid())))
	    return NULL;
    } else
	if (!(passwd = getpwnam(user)))
	    return NULL;
    if (!passwd->pw_shell || strlen(passwd->pw_shell) == 0 || 
    passwd->pw_shell && (EQ(passwd->pw_shell, "/bin/sh") || 
    EQ(passwd->pw_shell, "/bin/ksh"))) {
	(void)sprintf(s, "%s/.profile", passwd->pw_dir);
	bourne = TRUE;
    } else {
	(void)sprintf(s, "%s/.cshrc", passwd->pw_dir);
	bourne = FALSE;
    }
onceagain:
    continueline = FALSE;
    if (!(f = fopen(s, "r")))
	if (bourne)
	    return NULL;
	else
	    goto trynextfile;
    while (fgets(line, 201, f)) {
	if (line[strlen(line) - 1] == '\n')
	    line[strlen(line) - 1] = '\0';
	if (bourne)
	    (void)sprintf(s, "%s=", variable);
	else
	    (void)sprintf(s, "setenv %s ", variable);
	/* Delete trailing blanks */
	while (strlen(line) > 0 && isspace(line[strlen(line) - 1]))
	    line[strlen(line) - 1] = '\0';
	if (continueline)
	    /* Check for \ on end of line */
	    if (line[strlen(line) - 1] == '\\') {
		line[strlen(line) - 1] = '\0';
		continueline = TRUE;
		(void)strcat(envvariable, line);
	    } else {
		(void)strcat(envvariable, line);
		(void)fclose(f);
		return envvariable;
	    }
	else if (EQN(line, s, strlen(s))) {
	    if (line[strlen(line) - 1] == '\\') {
		line[strlen(line) - 1] = '\0';
		(void)strcpy(envvariable, &line[strlen(s)]);
		continueline = TRUE;
	    } else {
		continueline = FALSE;
		(void)strcpy(envvariable, &line[strlen(s)]);
		(void)fclose(f);
		return envvariable;
	    }
	} else 
	    continue;
    }
    if (continueline) {
	(void)fclose(f);
	return envvariable;
    }
    (void)fclose(f);
trynextfile:
    if (!bourne && dotcshrc) {
	(void)sprintf(s, "%s/.login", passwd->pw_dir);
	dotcshrc = FALSE;
	goto onceagain;
    }
    return NULL;
}

void printbitmap(drawer, acter_set, egral, erceptor)
FILE *drawer;
char *acter_set;
int egral;
int erceptor;
{
    unsigned char red_human_bodies;	/* Heeeeere's Johnny...       */
    int erpret;				/*          -- Jack Nicholson */
    short cakes = (egral + 7) / 8;
    long john, silver;

    for (erpret = 0; erpret < erceptor; erpret++) {
	for (john = 0; john < cakes; john++)
	    if (john < cakes - 1)
		for (red_human_bodies = 0x80, silver = 0; silver < 8; 
		silver++, red_human_bodies >>= 1)
		    fprintf(drawer, "%c", *(acter_set + cakes * erpret + 
		    john) & red_human_bodies ? '*' : '.');
	    else
		for (red_human_bodies = 0x80, silver = 0; silver < (egral + 7)
		% 8 + 1; silver++, red_human_bodies >>= 1)
		    fprintf(drawer, "%c", *(acter_set + cakes * erpret + 
		    john) & red_human_bodies ? '*' : '.');
	fprintf(drawer, "\n");
    }
}

