#ifndef lint
static char *rcs = "$Header: if.c,v 1.1 88/01/15 13:04:16 simpson Rel $";
#endif
/*
$Log:	if.c,v $
 * Revision 1.1  88/01/15  13:04:16  simpson
 * initial release
 * 
 * Revision 0.1  87/12/11  18:30:58  simpson
 * beta test
 * 
*/
/* "if" filter
 * This doesn't filter the input at all if the -c option is given.  If the
 * -c option is not given, then it converts \n into \r\n if it is not in
 * QUIC mode.  It performs accounting if an accounting file is given.  It
 * makes educated guesses as to the number of pages printed.  Here is the
 * page count algorithm:
 *	if -c option given then {
 *	    if input string equals "^,"
 *		increment page count
 *	    else if input character is formfeed and not free format
 *		increment page count
 *	} else
 *	    if not in QUIC mode {
 *		if input character is \n and line count is greater than the
 *		length of the page
 *		    increment page count
 *	    } else
 *		if input string equals "^,"
 *		    increment page count
 *		else if input character is formfeed and not free format
 *		    increment page count 
 */
#include <stdio.h>
#include <signal.h>
#include <local/qms.h>
#include <local/standard.h>
#include <local/profile.h>
#include "fontnode.h"

char	*WhoAmI;	/* argv[0] */
char    *Model;
Boolean EnteredQuic = FALSE;
Boolean QuicMode = FALSE;
Boolean FreeForm = FALSE;
Boolean Raw = FALSE;
int	LineNum = 1;
int	CharCount = 1;
int	Length;
int	Width;
int	Indent = 0;
int	PortraitFont = 1204;
int	LandscapeFont = 1217;
struct sigvec	SigStruct;
extern char	*User;
extern char	*Host;
extern Boolean	Accounting;
extern int	NumPages;
extern FILE	*Accting;

main(argc, argv)
int	argc;
char	*argv[];
{
    extern int	optind;
    extern char	*optarg;
    PROFILE_VALUE   *v, *getbindingvalue();
    int		c, callcleanup();
    void	sanestate();
    void	cleanup();
    
    WhoAmI = argv[0];
    while ((c = getopt(argc, argv, "cw:l:i:n:h:")) != EOF)
	switch (c) {
	case 'c':
	    Raw = TRUE;
	    break;
	case 'l':
	    Length = atoi(optarg);
	    break;
	case 'w':
	    Width = atoi(optarg);
	    break;
	case 'i':
	    Indent = atoi(optarg);
	    break;
	case 'n':
	    User = optarg;
	    break;
	case 'h':
	    Host = optarg;
	    break;
	case '?':		/* This should not happen */
	    exit(2);
	}
    if (optind < argc) {
	Accounting = TRUE;
	if (!(Accting = fopen(argv[optind], "a"))) {
	    fprintf(stderr, "%s: cannot open accounting file %s\n", WhoAmI, 
	    argv[optind]);
	    Accounting = FALSE;
	}
    }
    if (!(v = getbindingvalue("model")) || v->class != PROFILE_STRING &&
    v->class != PROFILE_OTHER) {
	fprintf(stderr, 
	"%s: model binding missing or invalid in configuration file\n",
	WhoAmI);
	exit(2);
    }
    Model = v->value.s;
    if (Width > 80) {
	if ((v = getbindingvalue("landscapefont")) && v->class == 
	PROFILE_INTEGER)
	    LandscapeFont = v->value.i;
    } else
	if ((v = getbindingvalue("portraitfont")) && v->class == 
	PROFILE_INTEGER)
	    PortraitFont = v->value.i;
    SigStruct.sv_handler = callcleanup;
    SigStruct.sv_mask = 0;
    SigStruct.sv_onstack = 0;
    (void)sigvec(SIGINT, &SigStruct, (struct sigvec *)NULL);
    fputs(QUICON, stdout);
    fputs(Width > 80 ? LANDSCAPE : PORTRAIT, stdout);
    printf("%s00000", SYNTAX);
    if (Raw) {
	printf("%s00000%05d", INITMARGVERT, Width > 80 ? (int)(8.5 * 1000) :
	11 * 1000);
	printf("%s00000%05d", INITMARGHORZ, Width > 80 ? 11 * 1000 : (int)(8.5
	* 1000));
    } else {
	/* Different print engines can print in different parts of the page.
	 * For example, the Canon engine (QMS 800) cannot print in the top
	 * 1/4 inch of the page.  The QMS 1500 uses a Ricoh engine.  The
	 * 1200 and 2400 use a Xerox engine.  We have to account for each
	 * by having different spacing.
	 */
	if (EQ(Model, "QMS800"))
	    if (Width > 80) {
	        printf("%s%05d%05d", INITMARGVERT, (int)(.4 * 1000),  
		(int)(8.5 * 1000));
	        printf("%s%05d%05d", INITMARGHORZ, (int)(.325 * 1000), 
		11 * 1000);
	        printf("%s%04d", LINESPACING, (int)(8.2 * 100));
	    } else {
	        printf("%s%05d%05d", INITMARGVERT, (int)(.3 * 1000),
		11 * 1000);
	        printf("%s%05d%05d", INITMARGHORZ, (int)(.325 * 1000), 
		(int)(8.5 * 1000));
	        printf("%s%04d", LINESPACING, (int)(6.1 * 100));
	    }
	else if (EQ(Model, "QMS1500"))
	    if (Width > 80) {
	        printf("%s%05d%05d", INITMARGVERT, (int)(.1 * 1000),  
		(int)(8.2 * 1000));
	        printf("%s%05d%05d", INITMARGHORZ, (int)(.325 * 1000), 
		11 * 1000);
	        printf("%s%04d", LINESPACING, (int)(8.2 * 100));
	    } else {
	        printf("%s%05d%05d", INITMARGVERT, (int)(.1 * 1000),
		(int)(10.85 * 1000));
	        printf("%s%05d%05d", INITMARGHORZ, (int)(.325 * 1000), 
		(int)(8.5 * 1000));
	        printf("%s%04d", LINESPACING, (int)(6.1 * 100));
	    }
	else 	/* Models 1200 and 2400 */
	    if (Width > 80) {
	        printf("%s%05d%05d", INITMARGVERT, (int)(.32 * 1000), 
		(int)(8.5 * 1000));
	        printf("%s%05d%05d", INITMARGHORZ, (int)(.325 * 1000), 
		11 * 1000);
	        printf("%s%04d", LINESPACING, (int)(7.95 * 100));
	    } else {
	        printf("%s%05d%05d", INITMARGVERT, (int)(.22 * 1000), 
		11 * 1000);
	        printf("%s%05d%05d", INITMARGHORZ, (int)(.325 * 1000), 
		(int)(8.5 * 1000));
	        printf("%s%04d", LINESPACING, (int)(6.02 * 100));
	    }
	if (Width > 80) {
	    if ((v = getbindingvalue("landscapepitch")) && (v->class ==
	    PROFILE_INTEGER || v->class == PROFILE_FLOAT))
	        if (v->class == PROFILE_INTEGER)
		    printf("%s%04d", CHARSPACING, v->value.i * 100);
	        else
		    printf("%s%04d", CHARSPACING, (int)(v->value.f * 100));
	} else
	    if ((v = getbindingvalue("portraitpitch")) && (v->class ==
	    PROFILE_INTEGER || v->class == PROFILE_FLOAT))
	        if (v->class == PROFILE_INTEGER)
		    printf("%s%04d", CHARSPACING, v->value.i * 100);
	        else
		    printf("%s%04d", CHARSPACING, (int)(v->value.f * 100));
    }
    printf("%s%d%s", DEFFONT, Width > 80 ? LandscapeFont : PortraitFont, 
    ENDCMD);
    fputs(FREEOFF, stdout);
    fputs(QUICOFF, stdout);
    while (yylex())
	;
    (void)sigblock(SIGINT);
    if (Raw || EnteredQuic || LineNum != 1 || CharCount != 1) {
	(void)putchar('\f');
	NumPages++;
    }
    fputs(QUICON, stdout);
    cleanup((struct FontNode *)NULL, SUCCEED);
}

int callcleanup()
{
    void	cleanup();

    fputs(QUICON, stdout);
    fputs(FORMFEED, stdout), NumPages++;
    cleanup((struct FontNode *)NULL, SUCCEED);
}
    
#include "quic.c"
