#ifndef lint
static char *rcs = "$Header: dumpdesc.c,v 1.1 88/01/15 13:03:43 simpson Rel $";
#endif
/*
$Log:	dumpdesc.c,v $
 * Revision 1.1  88/01/15  13:03:43  simpson
 * initial release
 * 
 * Revision 0.1  87/12/11  18:30:50  simpson
 * beta test
 * 
*/
#include <stdio.h>
#include <local/standard.h>
#include "dev.h"

char EOFName[81];
char *WhoAmI;
char *Usage = "Usage: %s DESCfile\n";

main(argc, argv)
int	argc;
char	*argv[];
{
    extern int	    optind;
    extern char	    *optarg;
    int		    c;
    FILE	    *f;
    void	    dumpdescfile(), desceofsoexit(), seteoffunction();
    char            *strcpy();

    WhoAmI = argv[0];
    while ((c = getopt(argc, argv, "")) != EOF)
	switch (c) {
	case '?':
badusage:   fprintf(stderr, Usage, WhoAmI);
	    exit(FAIL);
	}
    if (optind != argc - 1)
	goto badusage;
    if (!(f = fopen(argv[optind], "r"))) {
	perror(argv[optind]);
	exit(FAIL);
    }
    seteoffunction(desceofsoexit);
    (void)strcpy(EOFName, argv[optind]);
    dumpdescfile(f);
    (void)fclose(f);
    exit(SUCCEED);
}

/* Symbolically dumps a DESC.out file.  The parameter should be an open
 * DESC.out file.
 */
void dumpdescfile(f)
FILE	*f;
{
    unsigned char   spacewidth, widthindex;
    struct dev	devheader;
    struct font	fontheader;
    int		count, c;
    short	size, index;
    long	funnycharoffset;  /* Static file offset - Before */
				    /* funnycharindextable. */
    long	fontstructoffset; /* Floating offset - Beginning of each */
				    /* font structure. */

    rewind(f);
    (void)cfread((char *)&devheader, sizeof(struct dev), 1, f);
    printf("filesize: (%d+%d)=%d\n", sizeof(struct dev), devheader.filesize,
    sizeof(struct dev) + devheader.filesize);
    printf("res: %d\tmotion (hor,ver): (%d,%d)\n", devheader.res, 
    devheader.hor, devheader.vert);
    printf("unitwidth: %d\tsizescale: %d\n", devheader.unitwidth,
    devheader.sizescale);
    printf("nfonts: %d\tnsizes: %d\n", devheader.nfonts, devheader.nsizes);
    printf("paper (width,length): (%d,%d)\n", devheader.paperwidth,
    devheader.paperlength);
    /* Read the sizes table */
    printf("point sizes available:\n");
    (void)cfread((char *)&size, sizeof(short), 1, f);
    for (count = 0; size; count++) {
	if ((count + 1) % 20 == 0)
	    putchar('\n');
	printf("%d, ", size);
	(void)cfread((char *)&size, sizeof(short), 1, f);
    }
    if (count > 0)
	putchar('\n');
    /* Read the funnycharstrings */
    printf("special character names:\n");
    funnycharoffset = ftell(f);
    for (count = 0; count < devheader.nchtab; count++) {
	if ((count + 1) % 20 == 0)
	    putchar('\n');
	(void)fseek(f, funnycharoffset + count * sizeof(short), 0);
	(void)cfread((char *)&index, sizeof(short), 1, f);
	(void)fseek(f, funnycharoffset + devheader.nchtab * sizeof(short) + 
	index, 0);
	while ((c = cgetc(f)) != '\0')
	    putchar(c);
	putchar(',');
    }
    if (count > 0)
	putchar('\n');
    (void)fseek(f, funnycharoffset + devheader.nchtab * sizeof(short) +
    devheader.lchname, 0);
    /* Read each individual font information */
    fontstructoffset = ftell(f);
    while (fread((char *)&fontheader, sizeof(struct font), 1, f) == 1) {
	printf("\n%s font %s (internal %s)\n",
	fontheader.specfont == 1 ? "Special" : "Regular",
	fontheader.namefont, fontheader.intname);
	if (fontheader.ligfont > 0) {
	    printf("ligatures: ");
	    if (fontheader.ligfont & LFI)
		printf("fi, ");
	    if (fontheader.ligfont & LFL)
		printf("fl, ");
	    if (fontheader.ligfont & LFF)
		printf("ff, ");
	    if (fontheader.ligfont & LFFI)
		printf("ffi, ");
	    if (fontheader.ligfont & LFFL)
		printf("ffl, ");
	    printf("\n");
	}
	spacewidth = cgetc(f);
	if (spacewidth > (unsigned)0)
	    printf("spacewidth: %u\n", spacewidth);
	for (count = 0; count < 96 + devheader.nchtab; count++) {
	    /* Seek to fontindextable */
	    (void)fseek(f, fontstructoffset + sizeof(struct font) + 3 * 
	    fontheader.nwfont + count, 0);
	    widthindex = cgetc(f);
	    if (widthindex == 0)
		continue;
	    if (count < 96)
		if (count + 32 == 0177)	    /* Delete */
		    printf("0177\t");
		else
		    printf("%c\t", count + 32);
	    else {
		/* Print out special character sequence. */
		(void)fseek(f, funnycharoffset + (count - 96) * sizeof(short),
		0);
		(void)cfread((char *)&index, sizeof(short), 1, f);
		(void)fseek(f, funnycharoffset + devheader.nchtab *
		sizeof(short) + index, 0);
		while ((c = cgetc(f)) != '\0')
		    putchar(c);
		putchar('\t');
	    }
	    /* Print out width, kerning and code info */
	    (void)fseek(f, fontstructoffset + sizeof(struct font) + widthindex,
	    0);
	    printf("width %d\t", cgetc(f));
	    (void)fseek(f, fontstructoffset + sizeof(struct font) +
	    fontheader.nwfont + widthindex, 0);
	    printf("kerning %d\t", cgetc(f));
	    (void)fseek(f, fontstructoffset + sizeof(struct font) +
	    fontheader.nwfont * 2 + widthindex, 0);
	    printf("code %d\n", cgetc(f));
	}
	/* Go to next font structure */
	(void)fseek(f, fontstructoffset + sizeof(struct font) + 3 *
	fontheader.nwfont + 96 + devheader.nchtab, 0);
	fontstructoffset = ftell(f);
    }
}

void desceofsoexit()
{
    fprintf(stderr, "%s: unexpected eof in DESC.out file %s\n", WhoAmI,
    EOFName);
    exit(FAIL);
}
