.\" $Header: cati.l,v 1.1 88/01/15 12:58:16 simpson Rel $
.\" $Log:	cati.l,v $
.\" Revision 1.1  88/01/15  12:58:16  simpson
.\" initial release
.\" 
.\" Revision 0.1  87/12/11  17:56:50  simpson
.\" beta test
.\" 
.TH CATI 1 TRW
.UC 4
.SH NAME
cati \- GSI CAT-4/8 phototypesetter interpreter
.SH SYNOPSIS
.B cati
[
.B -l
] [
.B -v
] [ file ... ]
.SH DESCRIPTION
.I Cati
writes a commentary on standard output
interpreting each command as it would act on the phototypesetter.
The options are:
.TP
.B -l
print a one line summary of the leading and nothing else.
.TP
.B -v
turn on verbose mode where each individual lead or escape command is printed.
The default is terse mode where only a one line summary
of an ubroken series of lead or escape commands is printed.
.PP
If
.I file
is omitted
.I cati
reads from standard input.
.PP
The output notation is:
.TP
.RI > " E F B T"
> (<) denotes forward (backward) escape.
.I E
is the accumulated escape of an unbroken series of escape commands.
.IR F " (" B )
is the total forward (backward) escape to date.
.I T
is the magnitude of all escape (in either direction) to date.
All numerical values are in CAT horizontal units.
.TP
.RI + " L F B T"
+ (-) denotes forward (backward) leading.
.I L
is the accumulated leading of an unbroken series of lead commands.
.IR F " (" B )
is the total forward (backward) leading to date.
.I T
is the magnitude of all leading (in either direction) to date.
All numerical values are in CAT vertical units.
.TP
Initialize
an
.I initialize
control code.
.TP
.RI "Lower rail (font " N )
a
.I "lower rail"
control code.
.I N
is the font selected by the mode change.
.TP
.RI "Upper rail (font " N )
an
.I "upper rail"
control code.
.I N
is the font selected by the mode change.
.TP
.RI "Upper magazine (font " N )
an
.I "upper magazine"
control code.
.I N
is the font selected by the mode change.
.TP
.RI "Lower magazine (font " N )
a
.I "lower magazine"
control code.
.I N
is the font selected by the mode change.
.TP
Font half lower
a
.I "lower font half"
control code.
.TP
Font half upper
an
.I "upper font half"
control code.
.TP
.RI "> mode" " F B T"
an
.I "escape mode"
control code.
> (<) denotes forward (backward) escape mode.
.IR "F " ( B )
is the total amount of forward (backward) escape to date.
.I T
is the magnitude of all escape to date.
All numerical values are in CAT horizontal units.
.TP
STOP
a
.I stop
control code.
.TP
.RI "+ mode" " F B T"
a
.I "lead mode"
control code.
+ (-) denotes forward (backward) lead mode.
.IR "F " ( B )
is the total amount of forward (backward) leading to date.
.I T
is the magnitude of all leading to date.
All numerical values are in CAT vertical units.
.TP
.RI "Tilt up (font " N )
a
.I "tilt up"
control code.
.I N
is the font selected by the mode change.
.TP
.RI "Tilt down (font " N )
a
.I "tilt down"
control code.
.I N
is the font selected by the mode change.
.TP
.RI Size " N"
a
.I "point size change control"
code.
.I N
is the selected point size.
If the size change is a single to double transition the parenthetical
remark `(double)' will follow
.IR N .
If the size change is a double to single transition the parenthetical
remark `(single)' will follow
.IR N .
.TP
Flash \fIF \fR(font \fIN IH \fRsize \fIS \fR<\fIR\fR,\fIC\fR>)
a
.I flash
code.
.I F
is the flashed character.
.I Cati
assumes that regular filmstrips are mounted are mounted on font positions
1-6 and 8 and that the Bell Special Mathematical font is mounted on position
7.
These assumptions are compatible with the default mountings
.IR troff (1)
assumes for the CAT-4.
.I N
is the font position 1-8.
.I I
is the filmstrip index of the character and
.I H
is the current font half
where L or U denote the lower and upper font halfs respectively.
.I S
is the current point size.
.I R
and
.I C
are the current row and column expressed in CAT vertical and
horizontal units respectively.
.TP
Formfeed
a
.I formfeed
control code.
.PP
In verbose mode each escape or leading command in the code stream
is printed.
The output notation is:
.TP
.RI "> " E
> (<) denotes forward (backward) escape.
.I E
is the magnitude of the escape in CAT horizontal units.
.TP
.RI "+ "  L
+ (-) denotes forward (backware) leading.
.I L
is the magintude of the leading in CAT vertical units.
.TP
.RI ">> " E
>> (<<) denotes big forward (backward) escape.
.I E
is the magnitude of the escape in CAT horizontal units.
.TP
.RI "++ " L
++ (--) denotes big forward (backward) leading.
.I L
is the magnitude of the leading in CAT vertical units.
.SH SEE ALSO
troff(1), cat(5)
