%{
#ifndef lint
static char *rcs = "$Header: qmsram.y,v 1.1 88/01/15 12:19:35 simpson Rel $";
#endif
/*
$Log:	qmsram.y,v $
 * Revision 1.1  88/01/15  12:19:35  simpson
 * initial release
 * 
 * Revision 0.1  87/12/11  17:12:12  simpson
 * beta test
 * 
*/
#include <stdio.h>
#include <setjmp.h>
#include <local/standard.h>
#include "qms.h"

extern FILE *_Ifp, *_Ofp;
extern Boolean	_FirstChar;
static jmp_buf	Env;
static struct qmsram	Result;
%}
%token RAM TRT ART FRT ORT INTEGER ENDLINE
%%
ramline : RAM valuelist ENDLINE ;

valuelist : valuelist value optcomma | /* epsilon */ ;

value :
    TRT '=' INTEGER
	{
	    Result.TR = $3;
	}
    |
    ART '=' INTEGER
	{
	    Result.AR = $3;
	}
    |
    FRT '=' INTEGER
	{
	    Result.FR = $3;
	}
    |
    ORT '=' INTEGER
	{
	    Result.OR = $3;   
	}
    ;

optcomma : ',' | /* epsilon */ ;
%%
#include "qmsramlex.c"

struct qmsram *qmsram()
{
    _FirstChar = TRUE;
    fputs(QUICON, _Ofp);
    fprintf(_Ofp, "%s00000", SYNTAX);
    fprintf(_Ofp, "%sRAM%s", INFO, ENDCMD);
    fputs(QUICOFF, _Ofp);
    (void)fflush(_Ofp);
    if (setjmp(Env)) {
	while (timedgetc(_Ifp) != EOF)	/* Discard remaining input */
	    ;
	return NULL;
    }
    if (yyparse() != 0)
	return NULL;
    yysptr = yysbuf;	    /* Resets lex lookahead buffer */
    return &Result;
}

static yyerror(s)
char	*s;
{
    longjmp(Env, TRUE);
}
