/* fonts.h
 * This file contains the interface to fonts.c, a way for using at tex fonts
 * on a printer in a modular way.
 */

/* Initialization code.
 * Should be called at the start of the printing program.
 */
extern f_init();
/* f_init(printer,pgmname,dirvec,dirveclen,num,den,mag,options)
 *   FILE *printer;
 *   char *pgm_name,dirvec[];
 *   int dirveclen;
 *   long num,den,mag;
 *   unsigned long options;
 */

/* Called at the end of your program.
 */
extern f_term();

/* Options to f_define_font
 */

/* Define a font for using.
 * This can be called more than once for the same font.
 */
extern f_define_font();
/* f_define_font(fontnum,options,area,name,mag,s,tfmchecksum)
 *   char *area,*name;
 *   unsigned long fontnum,options,mag,s,tfmchecksum;
 */


/* Hints as to what fonts are to be used.
 * This is called once per page to give fonts module hints as what fonts
 * are going to be used on this page.
 */
extern f_newpage();
/* f_newpage(fontvec,charvec,veclen)
 *   unsigned long fontvec[];
 *   unsigned long charvec[][4];
 *   int veclen;
 */

/* Set a font as the current font.
 */
extern f_use_font();
/* f_use_font(fontnum,font_space)
 *   unsigned long fontnum;
 *   long *font_space;
 */

/* Hints as to what fonts are to be used.
 * This is called once per page to give fonts module instrucions as what fonts
 * and characters in those fonts have to be loaded for this page.
 * "fontvec" contains a list of fonts used for this page
 * "veclen" is the number of fonts used on this page
 * "charvec" contains the per font information about the symbols needed
 */
extern int f_newpage();
/* f_newpage(fontvec,charvec,veclen)
 *   unsigned long fontvec[];
 *   unsigned long charvec[][4];
 *   int veclen;
 */


/* Make sure that the font info for this character is loaded.
 * This is here so fonts could be incrementally loaded into the printer,
 * if so desired by fonts.c.
 * This procedure is called for every character output to the printer,
 * So it should be fast in the standard case.
 * Should return how much the point moves after setting this character.
 */
extern int f_use_char();
/* f_use_char(ch,pxlwidth,devwidth)
 *   unsigned long ch;
 *   long *pxlwidth,*devwidth;
 */
