/* Copyright 1988 Stephan v. Bechtolsheim */

/* This file is part of the TeXPS Software Package.

The TeXPS Software Package is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the TeXPS Software Package
General Public License for full details.

Everyone is granted permission to copy, modify and redistribute
the TeXPS Software Package, but only under the conditions described in the
TeXPS Software Package General Public License.   A copy of this license is
supposed to have been given to you along with TeXPS Software Package so you
can know your rights and responsibilities.  It should be in a
file named CopyrightLong.  Among other things, the copyright notice
and this notice must be preserved on all copies.  */


#include <stdio.h>
#include "signal.h"

/* This routine is called if an interrupt is received. */
int Signal();

/*
 * InitSignalHandling
 * ******************
 * Initialize all signal handling here.
 */
void
InitSignalHandling()
{
  struct sigvec sv; /* signal vector */

  /* Initalize handling of interrupts. */
  sv.sv_handler = Signal;
  if (sigvec(SIGINT, &sv, (struct sigvec *) NULL) != 0 ||
      sigvec(SIGQUIT,&sv, (struct sigvec *) NULL) != 0 ||
      sigvec(SIGFPE, &sv, (struct sigvec *) NULL) != 0)
    Fatal ("InitSignalHandling(): Initialising signal handling failed");
#ifdef DEBUG
  fprintf (stderr, "InitSignalHandling(): done\n");
#endif
}

/*
 * Signal
 * ******
 * Must be declared to return an integer!
 *
 * Signal / Interrupt handling.
 */
int
Signal()
{
  fflush (stdout);

  fprintf (stderr, "\nSignal(): Interrupt received\n");
  fflush (stderr);

  CleanUpFiles();

  fprintf (stderr, "\nSignal(): done\n");

  exit(1);
}
