/*
 *	pxl_open.c(path, font, pxlmag, pkmag, name, read_font_index)
 *	Find and open gf, pk, or pxl files in the given path, having the given
 *	name and magnification.  It tries gf files first, followed by pk and pxl
 *	files..  The path variable should be of the form path1:path2:...:pathn,
 *	and each of the paths will be tried successively.  Strings in pathi of
 *	the form %f, %p, and %d will be replaced by the font name, "gf" or "pk"
 *	or "pxl", and the magnification, respectively.  If no %f appears in a
 *	path specifier, then the string "/%f.%d%p" is added on the end.  If
 *	the file is found, then a file pointer is returned, and *name is set to
 *	a string giving the file name.  If the file is not found, then NULL is
 *	returned.  This procedure also returns a pointer to the glyph-reading
 *	procedure associated with the file format.
 * 
 *	Often there are so many fonts that we need to manage the number of
 *	simultaneously open files.  In that case, the variable n_fonts_left
 *	gives the number of open files that are left, (initially MAXINT, set
 *	dynamically) and when it is necessary to close a file, these routines
 *	call close_a_file() which should free up a file descriptor.
 * 
 */

#include <stdio.h>
#include <string.h>
#include <errno.h>

extern	int	errno;

#define	PATH_SEP	':'
#define	DEFAULT_TAIL	"/%f.%d%p"

#ifndef	__STDC__
#define	OPEN_MODE	"r"
#else	__STDC__
#define	OPEN_MODE	"rb"
#endif	__STDC__

extern	int	n_fonts_left;

	/* the corresponding read_char procedures are handled in xdvi.h */
typedef	void (*read_font_index_proc)();
	/* struct font *fontp; */

read_font_index_proc read_GF_index, read_PK_index, read_PXL_index;

char *malloc(), *index(), *sprintf();

#define	Strcpy	(void) strcpy
#define	Sprintf	(void) sprintf

static FILE *formatted_open(path, font, pxl, mag, name)
char *path, *font, *pxl;
int mag;
char **name;
{
	char	*p = path,
		nm[128],
		*n = nm,
		c;
	int	f_used = 0;
	FILE	*f;

	for (;;) {
	    c = *p++;
	    if (c==PATH_SEP || c=='\0') {
		if (f_used) break;
		p = DEFAULT_TAIL;
		continue;
	    }
	    if (c=='%') {
		c = *p++;
		switch (c) {
		    case 'f':
			f_used=1;
			Strcpy(n, font);
			break;
		    case 'p':
			Strcpy(n, pxl);
			break;
		    case 'd':
			Sprintf(n, "%d", mag);
			break;
		    default:
			*n++ = c;
			*n = '\0';
		}
		n += strlen(n);
	    }
	    else *n++ = c;
	}
	*n = '\0';
	f = fopen(nm, OPEN_MODE);
	if (f == NULL && errno == EMFILE) {
	    n_fonts_left = 0;
	    close_a_file();
	    f = fopen(nm, OPEN_MODE);
	}
	if (f != NULL) {
	    *name = malloc((unsigned) (n - nm + 1));
	    Strcpy(*name, nm);
	}
	return(f);
}

FILE *pxl_open(path, font, pxlmag, pkmag, name, read_font_index)
char *path, *font;
int pxlmag, pkmag;
char **name;
read_font_index_proc *read_font_index;
{
	char	*p = path;
	FILE	*f;

	for (;;) {
	    if (read_GF_index &&
		(f=formatted_open(p, font, "gf", pkmag, name)) != NULL) {
		    *read_font_index = read_GF_index;
		    return(f);
	    }
	    if (read_PK_index &&
		(f=formatted_open(p, font, "pk", pkmag, name)) != NULL) {
		    *read_font_index = read_PK_index;
		    return(f);
	    }
	    if (read_PXL_index &&
		(f=formatted_open(p, font, "pxl", pxlmag, name)) != NULL) {
		    *read_font_index = read_PXL_index;
		    return(f);
	    }
	    p = index(p, PATH_SEP);
	    if (p == NULL) return(NULL);
	    ++p;
	}
}
