;;
;; Temporary solution to link Mew to Gnus.
;; This code will be obsolated because Mew supports USENET news soon.
;;
;; (add-hook 'gnus-summary-mode-hook '(lambda () (require 'mew-gnus)))
;; (setq gnus-mail-reply-method 'gnus-mail-reply-using-mew)
;; (setq gnus-mail-forward-method 'gnus-mail-forward-using-mew)
;; (setq gnus-mail-other-window-method 'gnus-mail-other-window-using-mew)
;; (setq gnus-default-article-saver 'gnus-summary-save-in-mew)

(if mew-emacs19-p
    (eval-when-compile 
     (progn
       (require 'gnus))))

(require 'mew)

(defvar mh-lib "/usr/local/lib/mh")

(defun gnus-summary-save-in-mew (&optional folder)
  "Save this article to MH folder (using `rcvstore' in MH library).
Optional argument FOLDER specifies folder name."
  (interactive)
  (gnus-summary-select-article gnus-save-all-headers gnus-save-all-headers)
  (gnus-eval-in-buffer-window gnus-article-buffer
    (save-restriction
      (widen)
      (or (and (boundp 'mew-folder-alist) mew-folder-alist)
	  (setq mew-folder-list (mew-folder-make-list)
		mew-folder-alist (mew-folder-make-alist mew-folder-list)))
      (let ((folder
             (or folder
                 (mew-input-folder
		  (funcall gnus-folder-save-name
			   gnus-newsgroup-name
			   gnus-current-headers
			   gnus-newsgroup-last-folder))))
            (errbuf (get-buffer-create " *GNUS rcvstore*")))
        (unwind-protect
            (call-process-region (point-min) (point-max)
                                 (expand-file-name "rcvstore" mh-lib)
                                 nil errbuf nil folder)
          (set-buffer errbuf)
          (if (zerop (buffer-size))
              (message "Article saved in folder: %s" folder)
            (message "%s" (buffer-string)))
          (kill-buffer errbuf)
          (setq gnus-newsgroup-last-folder folder))))))

(defun gnus-mail-reply-using-mew (&optional yank)
  (let (from cc subject date to reply-to
	     (buffer
	      (progn (and (string-match "v5" gnus-version)
			  (pop-to-buffer gnus-article-buffer))
		     (current-buffer))))
    (save-restriction
      (gnus-article-show-all-headers)
      (setq from (gnus-fetch-field "from")
            subject (let ((subject (gnus-fetch-field "subject")))
                      (if (and subject
                               (not (string-match "^[Rr][Ee]:.+$" subject)))
                          (concat "Re: " subject) subject))
            reply-to (gnus-fetch-field "reply-to")
            cc (gnus-fetch-field "cc")
            date (gnus-fetch-field "date"))
      (setq to (or reply-to from))
      (mew-send to (or cc "") subject)
      (make-variable-buffer-local 'mew-message-citation-buffer) 
      (setq mew-message-citation-buffer gnus-article-buffer))
    (if yank (mew-draft-cite))))

(defun gnus-mail-forward-using-mew (&optional buffer)
  "Forward the current message to another user using mew."
  (or (bufferp mew-buffer-tmp)
      (save-excursion
	(mew-set-environment)))
  (let* ((buffer
	  (if (string-match "v5" gnus-version)
	      (pop-to-buffer (or buffer gnus-article-buffer))
	    (current-buffer)))
	 (subject (concat "[" gnus-newsgroup-name "] "
			  (or (gnus-fetch-field "subject") "")))
	 (file (mew-draft-get-new))
	 (mimefolder (mew-draft-to-mime file))
         (mimedir (mew-expand-file-name mimefolder)))
    (if (null (file-directory-p mimedir))
        (mew-make-directory mimedir)
      (if (null (mew-directory-empty-p mimedir))
          (if (mew-y-or-n-p (format "Mime folder %s is not empty. Delete it? "
				    mimefolder))
              (progn
                (call-process "rm" nil nil nil "-rf" mimedir)
                (mew-make-directory mimedir)))))
    (unwind-protect
	(progn
	  (write-region (point-min) (point-max) (mew-draft-get-new mimefolder))
	  (delete-other-windows)
	  (split-window-vertically)
	  (switch-to-buffer-other-window (find-file-noselect file))
	  (mew-draft-header subject 'nl)
	  (mew-draft-mode)
	  (setq mew-multi-syntax
		(mew-multi-multi-syntax (file-name-nondirectory mimedir) 1))
	  (save-excursion
	    (mew-draft-prepare-multipart)))
      (save-buffer))) ;; to make sure no to use this draft again
  (message "Draft is prepared"))

(defun gnus-mail-other-window-using-mew ()
  "Compose mail other window using mew."
  (or (bufferp mew-buffer-tmp)
      (save-excursion
	(mew-set-environment)))
  (let* ((subject (gnus-fetch-field "subject")))
    (delete-other-windows)
    (split-window-vertically)
    (other-window 1)
    (mew-send nil nil subject)
    (make-variable-buffer-local 'mew-message-citation-buffer)
    (setq mew-message-citation-buffer gnus-article-buffer)))

(provide 'mew-gnus)
