;;;			    mew-fib.el
;;;
;;;		 Copyright (C) 1994  Yoshinari NOMURA
;;;
;;;		   This emacs lisp library confirms
;;;		GNU GENERAL PUBLIC LICENSE Version 2.
;;;
;;; Author:  Yoshinari NOMURA <nom@csce.kyushu-u.ac.jp>
;;; Created: Nov.  29, 1994
;;; Revised: Nov.  29, 1994
;;;

(defconst mew-fib-version "mew-fib.el version 0.03")

(defvar mew-fib-item-file (expand-file-name "~/.mew-fib"))
(defvar mew-fib-item-alist nil)
(defvar mew-buffer-tmp " *mew fib tmp*")

(provide 'mew-fib)

(defun mew-fib-split (str)
  (let (ret match)
    (while (string-match "[\t \n]*\\([^,]+\\)" str)
      (setq  match (substring str (match-beginning 1) (match-end 1))
	     str (substring str (match-end 0))
	     match (if (string-match "[\t \n]+$" match)
		       (substring match 0 (match-beginning 0))
		     match)
	     ret (cons match ret)))
    (reverse ret)))

(defun mew-fib-make-alist ()
  (save-excursion
    (let (item val ret tmp-val)
      (setq mew-fib-item-alist nil)
      (set-buffer (get-buffer-create mew-buffer-tmp))
      (erase-buffer)
      (if (file-exists-p mew-fib-item-file)
	  (insert-file-contents mew-fib-item-file))
      (beginning-of-buffer)
      (delete-matching-lines "^[ \t]*[;#%]")
      (while (re-search-forward "^\\([^:]+\\):[ \t]*\\(.*\\)$" nil t)
	(setq item    (buffer-substring (match-beginning 1) (match-end 1))
	      tmp-val (buffer-substring (match-beginning 2) (match-end 2))
	      val (if (string= tmp-val "") val tmp-val)
	      ret (append ret (mapcar (function 
				       (lambda (arg)
					 (cons (downcase arg) val)))
				      (mew-fib-split item)))))
      ret)))

(defun mew-fib-fill-default ()
  (interactive)
  (save-excursion
    (let (begin end str)
      (setq mew-fib-item-alist (mew-fib-make-alist))
      (beginning-of-buffer)
      (while (re-search-forward "|>\\([^<]+\\)<|" nil t)
	(setq begin (match-beginning 1)
	      end (match-end 1)
	      str (buffer-substring begin end))
	(delete-region begin end)
	(backward-char 2)
	(insert (or (cdr (assoc (downcase str) mew-fib-item-alist)) str)))
    )))

(defun mew-fib-delete-frame ()
  (interactive)
  (save-excursion
    (beginning-of-buffer)
    (replace-regexp "|>\\|<|" "")))

(defun mew-fib-flush-input ()
  (interactive)
  (save-excursion
    (let ((ptr (point)))
      (beginning-of-line)
      (if (and (looking-at "^.*|>\\([^<]+\\)<|")
	       (>= ptr (match-beginning 1))
	       (<= ptr (match-end 1)))
	  (delete-region (match-beginning 1)
			 (match-end 1))))))

(defun mew-fib-next-item ()
  (interactive)
  (if (re-search-forward "|>\\([^<]+\\)<|" nil t)
      (backward-char 2)
    (beginning-of-buffer)
    (re-search-forward "|>\\([^<]+\\)<|" nil t)))

(defun mew-fib-previous-item ()
  (interactive)
  (if (re-search-backward "|>\\([^<]+\\)<|" nil t)
      (forward-char 2)
    (end-of-buffer)
    (re-search-backward "|>\\([^<]+\\)<|" nil t)))

