% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/by_orderBy.R
\name{by-order}
\alias{by-order}
\alias{order_by}
\alias{orderBy}
\title{Ordering (sorting) rows of a data frame}
\usage{
order_by(data, formula)

orderBy(formula, data)
}
\arguments{
\item{data}{A dataframe}

\item{formula}{The right hand side of a formula}
}
\value{
The ordered data frame
}
\description{
Ordering (sorting) rows of a data frame by the certain
variables in the data frame. This function is essentially a
wrapper for the \code{order()} function - the important
difference being that variables to order by can be given by a
model formula.
}
\details{
The sign of the terms in the formula determines whether
sorting should be ascending or decreasing; see examples below
}
\examples{

orderBy(~ conc + Treatment, CO2)
## Sort decreasingly by conc
orderBy(~ - conc + Treatment, CO2)
## Same as:
order_by(CO2, c("conc", "Treatment"))
order_by(CO2, c("-conc", "Treatment"))
}
\seealso{
\code{\link{transformBy}}, \code{\link{transform_by}}, \code{\link{splitBy}}, \code{\link{split_by}}
}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk} and Kevin
Wright
}
\concept{byfunction}
\keyword{utilities}
