//                                               -*- C++ -*-
/**
 *  @brief QMdiSubWindow to define the diagram of the data model
 *
 *  Copyright 2015-2025 EDF-Phimeca
 *
 *  This library is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
#include "persalys/DataModelDiagramWindow.hxx"

namespace PERSALYS
{

DataModelDiagramWindow::DataModelDiagramWindow(DataModelDiagramItem * dataModelDiagramItem, QWidget * parent)
  : DiagramWindow(dataModelDiagramItem, parent)
{
  titleLabel_->setDocLink("user_manual/graphical_interface/data_model/user_manual_data_model.html#datamodeldiagram");

  int row = 0;

  DiagramPushButton * modelDefinitionButton = new DiagramPushButton;
  modelDefinitionButton->setText(tr("Model\ndefinition"));
  modelDefinitionButton->setWhatsThis(tr("Import a data file and define the input and output variables"));
  connect(modelDefinitionButton, SIGNAL(clicked(bool)), dataModelDiagramItem, SLOT(appendDataModelItem()));

  appendButton(modelDefinitionButton, row);

  DiagramPushButton * dataAnalysisButton = new DiagramPushButton;
  dataAnalysisButton->setText(tr("Data\nanalysis"));
  dataAnalysisButton->setWhatsThis(tr("Analyse each variable"));
  connect(dataAnalysisButton, SIGNAL(clicked(bool)), dataModelDiagramItem->newDataAnalysis_, SIGNAL(triggered()));
  connect(dataModelDiagramItem, SIGNAL(dataSizeValidityChanged(bool, QString)), dataAnalysisButton, SLOT(setEnabled(bool, QString)));

  appendButton(dataAnalysisButton, row, modelDefinitionButton);

  DiagramPushButton * sensitivityAnalysisButton = new DiagramPushButton;
  sensitivityAnalysisButton->setText(tr("Sensitivity\nanalysis"));
  sensitivityAnalysisButton->setWhatsThis(tr("Compute Rank Sobol' indices"));
  connect(sensitivityAnalysisButton, SIGNAL(clicked(bool)), dataModelDiagramItem->newDataSensitivityAnalysis_, SIGNAL(triggered()));
  connect(dataModelDiagramItem, SIGNAL(dataSensitivityValidityChanged(bool, QString)), sensitivityAnalysisButton, SLOT(setEnabled(bool, QString)));

  appendButton(sensitivityAnalysisButton, ++row, modelDefinitionButton);

  DiagramPushButton * quantileAnalysisButton = new DiagramPushButton;
  quantileAnalysisButton->setText(tr("Quantile\nanalysis"));
  quantileAnalysisButton->setWhatsThis(tr("Estimate quantiles"));
  connect(quantileAnalysisButton, SIGNAL(clicked(bool)), dataModelDiagramItem->newQuantileAnalysis_, SIGNAL(triggered()));
  connect(dataModelDiagramItem, SIGNAL(dataModelValidityChanged(bool, QString)), quantileAnalysisButton, SLOT(setEnabled(bool, QString)));

  appendButton(quantileAnalysisButton, ++row, modelDefinitionButton);

  DiagramPushButton * inferenceButton = new DiagramPushButton;
  inferenceButton->setText(tr("Marginals\ninference"));
  inferenceButton->setWhatsThis(tr("Make an inference analysis for variables with given distributions"));
  connect(inferenceButton, SIGNAL(clicked(bool)), dataModelDiagramItem->newInferenceAnalysis_, SIGNAL(triggered()));
  connect(dataModelDiagramItem, SIGNAL(dataSizeValidityChanged(bool, QString)), inferenceButton, SLOT(setEnabled(bool, QString)));

  appendButton(inferenceButton, ++row, modelDefinitionButton);

  DiagramPushButton * copulaInferenceButton = new DiagramPushButton;
  copulaInferenceButton->setText(tr("Dependence\ninference"));
  copulaInferenceButton->setWhatsThis(tr("Test the dependence of the variables"));
  connect(copulaInferenceButton, SIGNAL(clicked(bool)), dataModelDiagramItem->newCopulaInferenceAnalysis_, SIGNAL(triggered()));
  connect(dataModelDiagramItem, SIGNAL(dependenciesValidityChanged(bool, QString)), copulaInferenceButton, SLOT(setEnabled(bool, QString)));

  appendButton(copulaInferenceButton, ++row, modelDefinitionButton);

  DiagramPushButton * metamodelButton = new DiagramPushButton;
  metamodelButton->setText(tr("Metamodel\ncreation"));
  metamodelButton->setWhatsThis(tr("Build a computationally cheap approximation model from input-output data"));
  connect(metamodelButton, SIGNAL(clicked(bool)), dataModelDiagramItem->newMetaModel_, SIGNAL(triggered()));
  connect(dataModelDiagramItem, SIGNAL(metaModelValidityChanged(bool, QString)), metamodelButton, SLOT(setEnabled(bool, QString)));

  appendButton(metamodelButton, ++row, modelDefinitionButton);

  DiagramPushButton * metamodelExportButton = new DiagramPushButton;
  metamodelExportButton->setText(tr("Export\nas model"));
  metamodelExportButton->setWhatsThis(tr("Export metamodel as model"));
  connect(dataModelDiagramItem, SIGNAL(metamodelNumberValidityChanged(bool, QString)), metamodelExportButton, SLOT(setEnabled(bool, QString)));
  connect(metamodelExportButton, SIGNAL(clicked(bool)), dataModelDiagramItem, SLOT(requestMetaModelExport()));

  appendButton(metamodelExportButton, row, metamodelButton);

  updateDiagram();
}
}
