/*
 *
 *
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library.  If not, see <https://www.gnu.org/licenses/>.
 *
 * Authors: Zhen Sun <sunzhen1@kylinos.cn>
 *
 */

#ifndef WIDGET_H
#define WIDGET_H

#include <QWidget>
#include <QPushButton>
#include <QTimer>
#include <QLabel>
#include <QDialog>
#include <QLineEdit>
#include "windowmanager/windowmanager.h"

using namespace kdk;
class QSpinBox;
class QComboBox;
class Widget : public QWidget
{
    Q_OBJECT

public:
    Widget(QWidget *parent = nullptr);
    ~Widget();
    void initUI();
    void initConnection();

private:
    QLabel* m_label;
    QWidget* m_subWidget;
    QPushButton* m_btnMinimize;
    QPushButton* m_btnMaximum;
    QPushButton* m_btnActivate;
    QPushButton* m_btnStayOnTop;
    QPushButton* m_btnClose;
    QPushButton* m_btnShowDesktop;
    QPushButton* m_btnChangeIcon;
    QPushButton* m_btnChangeTitle;
    QPushButton* m_btnShowGroup;
    QPushButton* m_shwWdgbtn;
    QPushButton* m_shwWindowTitle;
    QPushButton* m_shwWindowIcon;
    QPushButton* m_btnprintList;
    QPushButton* m_btnSetGeometry;
    QPushButton* m_btnGetType;
    QComboBox* m_setTypeBox;
    kdk::WindowManager *m_manager;
    QSpinBox *m_posX;
    QSpinBox *m_posY;
    QSpinBox *m_width;
    QSpinBox *m_height;
    QTimer* m_timer;
    WindowId m_lastestWindowId;
    QPushButton* m_skipTaskbarBtn;
    QPushButton* m_skipSwitcherBtn;
    QPushButton* m_showOnAllDesktop;
    QPushButton* m_isDesktopShowing;
    QPushButton* m_isOnCurrentDesktop;
};
#endif // WIDGET_H
