<div align="center">
  <img height="128" src="data/icons/hicolor/scalable/apps/io.github.nokse22.asciidraw.svg" alt="ASCII Draw Logo"/>
  
  # ASCII Draw
  
  <p align="center">
    <strong>Create beautiful diagrams and artwork using only ASCII characters</strong>
  </p>
  
  <p align="center">
    <a href="https://www.gnu.org/licenses/gpl-3.0">
      <img src="https://img.shields.io/badge/License-GPLv3-blue.svg" alt="License: GPL v3"/>
    </a>
    <a href="https://www.python.org/">
      <img src="https://img.shields.io/badge/Made%20with-Python-ff7b3f.svg" alt="Made with Python"/>
    </a>
    <a href="https://flathub.org/apps/details/io.github.nokse22.asciidraw">
      <img src="https://img.shields.io/badge/dynamic/json?color=brightgreen&label=Flathub%20Downloads&query=%24.installs_total&url=https%3A%2F%2Fflathub.org%2Fapi%2Fv2%2Fstats%2Fio.github.nokse22.asciidraw" alt="Flathub Downloads"/>
    </a>
  </p>
</div>

---

## ✨ Features

**Sketch anything using characters** - ASCII Draw is a powerful and intuitive application that lets you draw diagrams, tables, tree views, art and more using only characters. Whether you're documenting code, creating technical diagrams, or expressing your creativity, ASCII Draw provides all the professional tools you need.

<div align="center">
  <img src="data/resources/screenshot 01.png" width="800" alt="ASCII Draw Main Interface"/>
</div>

### 🛠️ Comprehensive Tool Set

- **🔲 Rectangle Tools**: Multiple line styles for borders and frames
- **🎨 Filled Rectangles**: Customizable border and fill characters
- **📏 Line Drawing**: Cartesian, Freehand, and Stepped lines with optional arrows
- **🖌️ Freehand Brush**: Natural drawing experience for artistic expression
- **📝 Text with FIGlet Fonts**: Stylized text using beautiful ASCII font styles
- **📊 Table Creator**: Professional table formatting and alignment
- **🌳 Tree View**: Hierarchical structures and organizational charts
- **🧹 Eraser**: Precise deletion and editing capabilities
- **🔤 Character Picker**: Extensive library of ASCII characters and symbols
- **↔️ Selection Tools**: Move and rotate selections with ease
- **🪣 Flood Fill**: Quickly fill areas with chosen characters

### 🎨 What You Can Create

- **Technical Diagrams**: Flowcharts, network diagrams, system architectures
- **Code Documentation**: Visual representations for README files and documentation
- **Data Visualization**: Tables, charts, and structured data displays
- **Creative Art**: ASCII art and decorative elements
- **Educational Content**: Visual aids for presentations and tutorials
- **Organizational Charts**: Tree structures and hierarchical displays

<details>
<summary>📸 <strong>View More Screenshots</strong></summary>

<div align="center">
  <img src="data/resources/screenshot 02.png" width="600" alt="Drawing Interface"/>
  <br><em>Intuitive drawing interface with various tools</em><br><br>
  
  <img src="data/resources/screenshot 03.png" width="600" alt="Text Features"/>
  <br><em>Advanced text manipulation and formatting options</em><br><br>
  
  <img src="data/resources/screenshot 04.png" width="600" alt="Character Selection"/>
  <br><em>Wide selection of ASCII characters and symbols</em><br><br>
  
  <img src="data/resources/screenshot 05.png" width="600" alt="Drawing Tools"/>
  <br><em>Various drawing tools for precise artwork creation</em><br><br>
  
  <img src="data/resources/screenshot 06.png" width="600" alt="Save Options"/>
  <br><em>Save as text file or copy to clipboard</em>
</div>

</details>

## 💬 Chat

To chat about ASCII Draw, share what you made or ask for help when contributing you can join our Matrix [#ascii-draw:matrix.org](https://matrix.to/#/%23ascii-draw:matrix.org)

---

## 🚀 Installation

### 📦 Quick Install

<div align="center">
  <a href='https://flathub.org/apps/io.github.nokse22.asciidraw'>
    <img height='80' alt='Download on Flathub' src='https://dl.flathub.org/assets/badges/flathub-badge-en.png'/>
  </a>
  &nbsp;&nbsp;&nbsp;&nbsp;
  <a href="https://snapcraft.io/ascii-draw">
    <img height='80' alt="Get it from the Snap Store" src="https://snapcraft.io/static/images/badges/en/snap-store-black.svg"/>
  </a>
</div>

### ⚡ From Source

For developers and contributors who want to build from source:

```bash
# Clone the repository
git clone https://github.com/Nokse22/ascii-draw.git

# Navigate to the project directory
cd ascii-draw

# Open in GNOME Builder and click "Run Project"
```

---

## 🛠️ System Requirements

- **Operating System**: Linux (GNOME desktop environment recommended)
- **Python**: 3.8 or higher
- **Dependencies**: GTK4, libadwaita, pyfiglet, emoji

---

## 🤝 Contributing

We welcome contributions! Whether you're fixing bugs, adding features, or improving documentation, your help makes ASCII Draw better for everyone.

### How to Contribute

1. Fork the repository
2. Create your feature branch (`git checkout -b feature/amazing-feature`)
3. Commit your changes (`git commit -m 'Add some amazing feature'`)
4. Push to the branch (`git push origin feature/amazing-feature`)
5. Open a Pull Request

---

## 📄 License

This project is licensed under the GNU General Public License v3.0 - see the [LICENSE](LICENSE) file for details.

---

## 🌟 Support the Project

If you find ASCII Draw useful, please consider:

- ⭐ Starring this repository
- 🐛 Reporting bugs and issues
- 💡 Suggesting new features
- 🔄 Sharing with others who might find it useful

---

<div align="center">
  <p>Made with ❤️ by the ASCII Draw community</p>
  <p>
    <a href="https://github.com/Nokse22/ascii-draw">View on GitHub</a> • 
    <a href="https://github.com/Nokse22/ascii-draw/issues">Report Bug</a> • 
    <a href="https://github.com/Nokse22/ascii-draw/issues">Request Feature</a>
  </p>
</div>
