!----------------------------------------------------------------------
!     Copyright (c) 2010--2012 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  wtq_module_sjpack ƥȥץ :: ִؿΥƥ
!
!  2010/04/18  ݹ   wt_module_sjpack_interpolate_test.f90 ¤
!      2011/09/14  ݹ   MPI 
!      2011/09/14  ݹ   wtq_mpi_module Ѥ˲¤
!      2012/04/02  ݹ   wtq_mpi_module_sjpack Ѥ˲¤
!      2012/04/03  ݹ   wtq_module_sjpack Ѥ˲¤
!
program wtq_module_sjpack_interpol_wt

  use dc_message, only : MessageNotify
  use dc_test, only : AssertEqual
  use wtq_module_sjpack
  implicit none

  integer,parameter  :: im=32, jm=16         ! ʻ(, , ư)
  integer,parameter  :: kmo=16, kmi=10       ! ʻ(ư, ư)
  integer,parameter  :: nm=10                ! ȿ(ʿ)
  integer,parameter  :: lmo=16, lmi=16       ! ȿ(ư, ư)
  real(8),parameter  :: ri=0.5, ro=1.5       ! ⳰Ⱦ

  real(8), dimension((nm+1)**2,0:lmo)       ::  wt_data
  real(8), dimension(0:im-1,1:jm,0:kmo)     ::  xyz_data

  ! Ƚ
  integer, parameter :: check_digits = 10
  integer, parameter :: ignore = -11

  real(8) :: Alon
  real(8) :: Alat
  real(8) :: Arad
  real(8) :: data_sol
  real(8) :: pi

  call MessageNotify('M','wtq_module_sjpack_interpolate_wt_test', &
                         'wtq_module_sjpack wt-interpolate tests') 

  pi = atan(1.0D0)*4.0D0

  Alon = pi/3
  Alat = pi/3
  Arad = 0.75
!!$  Alon =pi/4
!!$  Alat =pi/5
!!$  Arad =0.99
!!$  Alon = 3*pi/5
!!$  Alat = -pi/7
!!$  Arad = 1.333 

  call wtq_Initial(im,jm,kmi,kmo,nm,lmi,lmo,ri,ro)

  !---- Interpolaate_array000_wt Υƥ ----
  xyz_data = sqrt(3.0D0/2)*cos(xyz_Lat)*cos(xyz_Lon) & ! Y_1^1
            * (xyz_Rad-ri) *  (xyz_Rad-ro)

  data_sol = sqrt(3.0D0/2)*cos(ALat)*cos(ALon) * (ARad-ri) *  (ARad-ro)

  wt_data = wt_xyz(xyz_data)

  call AssertEqual(&
       message='Interpolate_wt Y_1^-1',                              &
       answer = data_sol,                                            &
       check = Interpolate_wt(wt_data,alon,alat,arad),      &
       significant_digits = check_digits, ignore_digits = ignore     &
       )

  call MessageNotify('M','wtq_module_sjpack_interpolate_wt_test',&
                         'wtq_module_sjpack wt-interpolate function test succeeded!') 

end program wtq_module_sjpack_interpol_wt
