! Copyright (C) GFD Dennou Club, 2000.  All rights reserved.

    !  ndims ĤǤʤФʤʤ
subroutine GDNcVarInquireIA(var, dimlen)
    use gtdata_netcdf_types, only: GD_NC_VARIABLE, GD_NC_VARIABLE_ENTRY
!    use gtdata_netcdf_internal, only: GD_NC_VARIABLE_ENTRY
    use gtdata_netcdf_internal, only: vtable_lookup
    use netcdf_f77, only: nf_noerr, nf_inq_vardimid, nf_inq_dimlen
    type(GD_NC_VARIABLE), intent(in):: var
    integer, intent(out):: dimlen(:)
    type(GD_NC_VARIABLE_ENTRY):: ent
    integer:: stat, i

    dimlen(:) = -1

    stat = vtable_lookup(var, ent)
    if (stat /= nf_noerr) return

    if (ent%varid > 0) then
        if (.not. associated(ent%dimids)) return
        do, i = 1, min(size(dimlen), size(ent%dimids))
            stat = nf_inq_dimlen(ent%fileid, ent%dimids(i), dimlen(i))
            if (stat /= nf_noerr) exit
        enddo
    else
        stat = nf_inq_dimlen(ent%fileid, ent%dimid, dimlen(1))
        if (stat /= nf_noerr) dimlen(1) = -1
    endif
end subroutine
