! package main 
!     for 2-D thermal convection in a square box. 
!
! 99/09/10  S. Takehiro
!
program dblsol_init

  use dimension
  use coordinates
  use math
  use diffuse_boundary
  use phase
  use variables
  use output_netcdf

  implicit none
  character(len=15)  :: file='dblsol_init.data'

!============================== ɸ ==============================
  call coordinates_init

  allocate ( temp(nx,nz), enth(nx,nz) )
  allocate ( C(nx,nz), Cl(nx,nz), fs(nx,nz) )
  allocate ( zeta(nx,nz), psi(nx,nz) )

!============================== Ѳ ==============================
  !call phase_param_init
      Cp_s = 1.0 ;  Cp_l = 1.0
      hf   = 0.0 ; 
      Tm0  = 0.0 ;  Tm1 = -10.0

!================================  ================================

      psi = 0.0

      zeta = laplace(psi)
      call diffuse_boundary_zeta(zeta,psi) 

      !temp = 1-zz
      temp = zz
      !temp(nx/4,nz/4) = temp(nx/4,nz/4) + 0.01
      
      !C = 0.0
      C = 1.0-zz
      C(nx/4,nz/4) = C(nx/4,nz/4) + 0.01

     !-------------- ¾̤η׻
      fs = fs_T_C( temp, C )
      enth  = enthalpy_T_fs( temp, fs )
      Cl = C_liquid( C, temp, fs )

!=================================  =================================
  call output_netcdf_init( file )
  call output_netcdf_data( file )

  stop

end program dblsol_init
