!======================================================================
!  Ѳѥ᥿ؿ⥸塼(2 ʬ 2 )
!  
!======================================================================
module phase_relation

  implicit none
  private

  double precision :: Cp_s=1.0   ! Ǯ
  double precision :: Cp_l=1.0   ! Ǯ
  double precision :: hf=1.0     ! Te Ǥθ->ꥨ󥿥ԡѲ

  double precision :: Tm0=1.0    ! C -> 1 ǤΥꥭ
  double precision :: Tm1=2.0    ! C -> 0 ǤΥꥭ

  public  :: Cp_s, Cp_l, hf, Tm0, Tm1

  public  :: T_liquidus, T_solidus, C_liquidus, C_solidus
  public  :: enthalpy_T_fs, fs_T_C, fs_enth_C, T_enth_C
  public  :: C_liquid

  contains

 !----------------------------  ----------------------------
  subroutine phase_param_init

      use namelist
      logical   :: ofirst = .true. 
      namelist /NMPHAS/ Cp_s, Cp_l, hf, Tm0, Tm1

      if ( ofirst ) then
         ofirst = .false. 
         write(6,*)'<<< LINEAR LIQUIDUS PHASE DIAGRAM 99/06/28 >>>'
      endif

      if( .not. rewnml() ) write( nm_write_num, NML=NMPHAS )
      read( nm_read_num, NML=NMPHAS, end=999 )
 999  write( nm_write_num, NML=NMPHAS )

    end subroutine phase_param_init

 !--------------------- ꥭ ----------------------
  function T_liquidus( C )

    double precision :: T_liquidus    ! 
    double precision :: C             ! ǻ

    T_liquidus =  -(Tm1-Tm0)*(C-1)**2 + Tm1

  end function T_liquidus

 !---------------------  ----------------------
  function T_solidus( C )

    double precision :: T_solidus    ! 
    double precision :: C            ! ǻ

    T_solidus =  (Tm1-Tm0)*C**2 + Tm0

  end function T_solidus

 !------------------ ꥭٵմؿ -------------------
  function C_liquidus( T )

    double precision :: T             ! 
    double precision :: C_liquidus    ! ǻ

    C_liquidus = 1 - sqrt( (Tm1-T)/(Tm1-Tm0) )

  end function C_liquidus

 !------------------ ٵմؿ -------------------
  function C_solidus( T )

    double precision :: T              ! 
    double precision :: C_solidus      ! ǻ

    C_solidus = sqrt( (T-Tm0)/(Tm1-Tm0) )

  end function C_solidus

 !------------- 󥿥ԡ(,) -------------
  function enthalpy_T_fs( T, fs )

    double precision :: T        ! 
    double precision :: fs       ! 
    double precision :: hs       ! ꥨ󥿥ԡ
    double precision :: hl       ! ꥨ󥿥ԡ
    double precision :: enthalpy_T_fs

    hs = Cp_s * T
    hl = Cp_l * T + (Cp_s-Cp_l)*Tm0 + hf

    enthalpy_T_fs = fs*hs + (1-fs)*hl

  end function enthalpy_T_fs

 !------------- (, ǻ) -------------
  function fs_T_C( T, C )

    double precision :: T          ! 
    double precision :: C          ! ǻ
    double precision :: fs_T_C     ! 

    if ( T .gt. T_liquidus(C) ) then
       fs_T_C = 0.0
    else if ( T .lt. T_solidus(C)) then
       fs_T_C = 1.0
    else
       if ( C_solidus(T) .eq. C_liquidus(T) )then
          call msgdmp('E','fs_T_C','C_sol-C_liq shuold be non-zero.' )
       endif
       fs_T_C = ( C - C_liquidus(T) ) / ( C_solidus(T) - C_liquidus(T) )
    endif

  end function fs_T_C

 !------------- (, ǻ) -------------
  function fs_enth_C( enth, C )

    double precision :: enth       ! 󥿥ԡ
    double precision :: C          ! ǻ
    double precision :: fs_enth_C     ! 

    double precision :: T, enth_liq, enth_sol

    T = T_enth_C( enth, C )

    if ( T .gt. T_liquidus(C) ) then
       fs_enth_C = 0.0
    else if ( T .lt. T_solidus(C)) then
       fs_enth_C = 1.0
    else 
       if ( C_solidus(T) .eq. C_liquidus(T) )then
          enth_liq = enthalpy_T_fs( T_liquidus(C), 0.0d0 )
          enth_sol = enthalpy_T_fs( T_solidus(C), 1.0d0 )
          fs_enth_C = (enth_liq - enth)/(enth_liq - enth_sol)
       else
          fs_enth_C = ( C - C_liquidus(T) ) / ( C_solidus(T) - C_liquidus(T) )
       endif
    endif

  end function fs_enth_C

 !------------- (󥿥ԡ, ǻ) -------------
  function T_enth_C( enth, C )

    double precision :: T_enth_C   ! 
    double precision :: enth          ! 󥿥ԡ
    double precision :: C             ! ǻ

    double precision :: Tliq, Tsol, enth_liq, enth_liq_astr, enth_sol

    Tliq = T_liquidus( C )
    Tsol = T_solidus( C )

    enth_liq = enthalpy_T_fs( Tliq, 0.0d0 )
    !enth_liq_astr = enthalpy_T_fs( Tsol, fs_T_c(Tsol,C) )
    enth_sol = enthalpy_T_fs( Tsol, 1.0d0 )

    if ( Tliq .eq. Tsol ) then
       if ( enth_liq .LE. enth ) then
          T_enth_c = ( enth - hf - (Cp_s - Cp_l )*Tm0 )/ Cp_l
       else if ( enth .LT. enth_sol ) then
          T_enth_c = enth / Cp_s
       else
          T_enth_c = Tsol
       endif
    else
       if ( enth_liq .LE. enth ) then
          T_enth_c = ( enth - hf - (Cp_s - Cp_l )*Tm0 )/ Cp_l
       else if ( enth .LT. enth_sol ) then
          T_enth_c = enth / Cp_s
       else
          T_enth_c = T_enth_C_bisec( enth, C, Tsol, Tliq )
       endif
    endif
  end function T_enth_C

 !--------- (󥿥ԡ, ǻ)2ʬˡǵ ---------
  function T_enth_C_bisec( enth, C, tmin, tmax )

    double precision :: T_enth_C_bisec   ! 
    double precision :: enth             ! 󥿥ԡ
    double precision :: C                ! ǻ
    double precision :: tmin, tmax       ! ٽ

    double precision :: eps = 1e-6          ! Ƚ
    double precision :: temp, enth_guess

999 continue
    !ent_s = enthalpy_T_fs( tmin, fs_T_c(tmin,C) )
    !ent_l = enthalpy_T_fs( tmax, fs_T_c(tmax,C) )
    
    temp = (tmin+tmax)/2
    enth_guess = enthalpy_T_fs( temp, fs_T_c(temp,C) )
        
    !if ( abs((enth_guess - enth)/enth) .lt. eps ) then
    if ( ((tmax-tmin)/max( abs(tmax),abs(tmin) ) .lt. eps ) &
         &  .or. ( (tmax-tmin) .lt. eps ) )then
       T_enth_C_bisec = temp
       return
    endif

    if ( enth_guess .lt. enth ) then
       tmin = temp
    else
       tmax = temp
    endif
    goto 999
  end function T_enth_C_bisec
  

 !-------------------- ǻ --------------------
  function C_liquid( C, T, fs ) 
    double precision  :: C         ! ǻ
    double precision  :: T         ! 
    double precision  :: fs        ! 
    double precision  :: C_liquid  ! Ǥǻ

    if ( fs .le. 0.0 ) then
       C_liquid = C
    else if ( fs .ge. 1.0 ) then
       C_liquid = 0.0
    else 
       C_liquid = C_liquidus(T)
    endif

  end function C_liquid

end module phase_relation
