!======================================================================
!  Ѳѥ᥿ؿ⥸塼(2 ʬ 2 )
!  2 󥤥󥿡ե
!======================================================================
module phase_array2

  use phase_relation
  implicit none
  private

  public  :: T_liquidus_array2, T_solidus_array2 
  public  :: C_liquidus_array2, C_solidus_array2
  public  :: enthalpy_T_fs_array2, T_enth_C_array2
  public  :: fs_T_C_array2, fs_enth_C_array2
  public  :: C_liquid_array2

  contains

 !--------------------- ꥭ ----------------------
  function T_liquidus_array2( C )

    double precision, dimension(:,:)                  :: C   ! ǻ
    double precision, dimension(size(C,1),size(C,2))  :: T_liquidus_array2

    integer :: i,j 

    do j = 1, size(C,2)
       do i = 1, size(C,1)
          T_liquidus_array2(i,j) = T_liquidus(C(i,j))
       enddo
    enddo

  end function T_liquidus_array2

 !---------------------  ----------------------
  function T_solidus_array2( C )

    double precision, dimension(:,:)                 :: C         ! ǻ
    double precision, dimension(size(C,1),size(C,2)) :: T_solidus_array2

    integer :: i, j

    do j = 1, size(C,2)
       do i = 1, size(C,1)
          T_solidus_array2(i,j) = T_solidus(C(i,j))
       enddo
    enddo
  end function T_solidus_array2

 !------------------ ꥭٵմؿ -------------------
  function C_liquidus_array2( T )

    double precision, dimension(:,:)                 :: T       ! 
    double precision, dimension(size(T,1),size(T,2)) :: C_liquidus_array2

    integer :: i, j

    do j=1, size(T,2)
       do i=1, size(T,1)
          C_liquidus_array2(i,j) = C_liquidus(T(i,j))
       enddo
    enddo
  end function C_liquidus_array2

 !------------------ ٵմؿ -------------------
  function C_solidus_array2( T )

    double precision, dimension(:,:)                 :: T     ! 
    double precision, dimension(size(T,1),size(T,2)) :: C_solidus_array2

    integer :: i, j

    do j=1, size(T,2)
       do i=1, size(T,1)
          C_solidus_array2(i,j) =  C_solidus(T(i,j))
       enddo
    enddo
  end function C_solidus_array2

 !------------- 󥿥ԡ(,) -------------
  function enthalpy_T_fs_array2( T, fs )

    double precision, dimension(:,:)       :: T        ! 
    double precision, dimension(:,:)       :: fs       ! 
    double precision, dimension(size(T,1),size(T,2)) :: enthalpy_T_fs_array2

    integer :: i, j

    do j=1, size(T,2)
       do i=1, size(T,1)
          enthalpy_T_fs_array2(i,j) =  enthalpy_T_fs( T(i,j), fs(i,j) )
       enddo
    enddo
  end function enthalpy_T_fs_array2

 !------------- (, ǻ) -------------
  function fs_T_C_array2( T, C )

    double precision, dimension(:,:)       :: T               ! 
    double precision, dimension(:,:)       :: C               ! ǻ
    double precision, dimension(size(T,1),size(T,2)) :: fs_T_C_array2    ! 

    integer :: i, j

    do j=1, size(T,2)
       do i=1, size(T,1)
          fs_T_C_array2(i,j) = fs_T_C(T(i,j),C(i,j))
       enddo
    end do
  end function fs_T_C_array2

 !------------- (, ǻ) -------------
  function fs_enth_C_array2( enth, C )

    double precision, dimension(:,:)          :: enth        ! 󥿥ԡ
    double precision, dimension(:,:)          :: C           ! ǻ
    double precision, dimension(size(enth,1),size(enth,2)) :: fs_enth_C_array2   ! 

    integer :: i, j

    do j=1, size(enth,2)
       do i=1, size(enth,1)
          fs_enth_C_array2(i,j) = fs_enth_C( enth(i,j), C(i,j) )
       enddo
    end do
  end function fs_enth_C_array2

 !------------- (󥿥ԡ, ǻ) -------------
  function T_enth_C_array2( enth, C )

    double precision, dimension(:,:)          :: enth       ! 󥿥ԡ
    double precision, dimension(:,:)          :: C          ! ǻ
    double precision, dimension(size(enth,1),size(enth,2)) :: T_enth_C_array2   ! 

    integer :: i, j

    do j=1, size(enth,2)
       do i=1, size(enth,1)
          T_enth_c_array2(i,j) = T_enth_c( enth(i,j), C(i,j) )
       enddo
    enddo
  end function T_enth_C_array2
  
 !-------------------- ǻ --------------------
  function C_liquid_array2( C, T, fs ) 
    double precision, dimension(:,:)       :: C               ! ǻ
    double precision, dimension(:,:)       :: T               ! 
    double precision, dimension(:,:)       :: fs              ! 
    double precision, dimension(size(C,1),size(C,2)) :: C_liquid_array2
                                                      ! Ǥǻ

    integer :: i, j

    do j=1, size(C,2)
       do i=1, size(C,1)
          C_liquid_array2(i,j) = C_liquid( C(i,j), T(i,j), fs(i,j) )
       enddo
    enddo
  end function C_liquid_array2

end module phase_array2
