!======================================================================
!  Ѳѥ᥿ؿ⥸塼(2 ʬ 2 )
!  1 󥤥󥿡ե
!======================================================================
module phase_array

  use phase_relation
  implicit none
  private

  public  :: T_liquidus_array, T_solidus_array 
  public  :: C_liquidus_array, C_solidus_array
  public  :: enthalpy_T_fs_array, T_enth_C_array
  public  :: fs_T_C_array, fs_enth_C_array
  public  :: C_liquid_array

  contains

 !--------------------- ꥭ ----------------------
  function T_liquidus_array( C )

    double precision, dimension(:)        :: C                ! ǻ
    double precision, dimension(size(C))  :: T_liquidus_array ! 

    integer :: i

    do i = 1, size(C)
       T_liquidus_array(i) = T_liquidus(C(i))
    enddo

  end function T_liquidus_array

 !---------------------  ----------------------
  function T_solidus_array( C )

    double precision, dimension(:)       :: C                  ! ǻ
    double precision, dimension(size(C)) :: T_solidus_array    ! 

    integer :: i

    do i = 1, size(C)
       T_solidus_array(i) = T_solidus(C(i))
    enddo

  end function T_solidus_array

 !------------------ ꥭٵմؿ -------------------
  function C_liquidus_array( T )

    double precision, dimension(:)       :: T                   ! 
    double precision, dimension(size(T)) :: C_liquidus_array    ! ǻ

    integer :: i

    do i=1, size(T)
       C_liquidus_array(i) = C_liquidus(T(i))
    enddo

  end function C_liquidus_array

 !------------------ ٵմؿ -------------------
  function C_solidus_array( T )

    double precision, dimension(:)       :: T                    ! 
    double precision, dimension(size(T)) :: C_solidus_array      ! ǻ

    integer :: i

    do i=1, size(T)
       C_solidus_array(i) =  C_solidus(T(i))
    enddo
  end function C_solidus_array

 !------------- 󥿥ԡ(,) -------------
  function enthalpy_T_fs_array( T, fs )

    double precision, dimension(:)       :: T        ! 
    double precision, dimension(:)       :: fs       ! 
    double precision, dimension(size(T)) :: enthalpy_T_fs_array

    integer :: i

    do i=1, size(T)
       enthalpy_T_fs_array(i) =  enthalpy_T_fs( T(i), fs(i) )
    enddo
  end function enthalpy_T_fs_array

 !------------- (, ǻ) -------------
  function fs_T_C_array( T, C )

    double precision, dimension(:)       :: T               ! 
    double precision, dimension(:)       :: C               ! ǻ
    double precision, dimension(size(T)) :: fs_T_C_array    ! 

    integer :: i

    do i=1, size(T)
       fs_T_C_array(i) = fs_T_C(T(i),C(i))
    enddo
  end function fs_T_C_array

 !------------- (, ǻ) -------------
  function fs_enth_C_array( enth, C )

    double precision, dimension(:)          :: enth              ! 󥿥ԡ
    double precision, dimension(:)          :: C                 ! ǻ
    double precision, dimension(size(enth)) :: fs_enth_C_array   ! 

    integer :: i

    do i=1, size(enth)
       fs_enth_C_array(i) = fs_enth_C( enth(i), C(i) )
    enddo
  end function fs_enth_C_array

 !------------- (󥿥ԡ, ǻ) -------------
  function T_enth_C_array( enth, C )

    double precision, dimension(:)          :: enth             ! 󥿥ԡ
    double precision, dimension(:)          :: C                ! ǻ
    double precision, dimension(size(enth)) :: T_enth_C_array   ! 

    integer :: i

    do i=1, size(enth)
       T_enth_c_array(i) = T_enth_c( enth(i), C(i) )
    enddo
  end function T_enth_C_array
  
 !-------------------- ǻ --------------------
  function C_liquid_array( C, T, fs ) 
    double precision, dimension(:)       :: C               ! ǻ
    double precision, dimension(:)       :: T               ! 
    double precision, dimension(:)       :: fs              ! 
    double precision, dimension(size(C)) :: C_liquid_array  ! Ǥǻ

    integer :: i

    do i=1, size(C)
       C_liquid_array(i) = C_liquid( C(i), T(i), fs(i) )
    enddo
  end function C_liquid_array

end module phase_array
