! package output_netcdf
!     for 2-D thermal convection in a square box. 
!
! 99/05/04  S. Takehiro
! 99/05/21  S. Takehiro   double precision
! 99/06/29  S. Takehiro   for otfix_left, otfix_right
! 99/08/19  S. Takehiro  close a netcdf file in each output. 
!
!============================= netcdf  =============================
module output_netcdf
  use timestep, only    : time, istep
  use dynamics_param
  use diffuse_boundary
  use dynamics_diffcoef
  use phase
  use variables
  use coordinates, only : x, z
  use dimension

  implicit none

  integer              :: ncid = 10      ! netcdf file specification number. 
  integer              :: xid, zid, timeid
  integer              :: tempid, psiid, enthid, compid, fsid, clid
  integer,dimension(3) :: ncdimid
  integer              :: status

  private
  public   :: output_netcdf_init, output_netcdf_data, output_netcdf_close

  contains

!============================= Ͻ ===========================
  subroutine output_netcdf_init( filename )
    include 'netcdf.inc'
    character(len=*)    :: filename

   !------------------------ ե ------------------------
    status = nf_create( filename, NF_NOCLOBBER, ncid )
    if ( status .ne. NF_NOERR ) &
       &   call msgdmp('E','ouput_init','file open error.' )

   !-------------------------- ȥ --------------------------
    status = nf_put_att_text & 
       & ( ncid, NF_GLOBAL, 'title', 53, &
       &   'convbox : 2-D thermal convection in a rectangular box' )

   !------------------------- ѥ᥿ -------------------------
    status = nf_put_att_int1 & 
         & ( ncid, NF_GLOBAL, 'ondim', NF_BYTE, 1, ondim )
    status = nf_put_att_int1 & 
         & ( ncid, NF_GLOBAL, 'opr_inf', NF_BYTE, 1, opr_inf )

    if ( ondim )then
       status = nf_put_att_double & 
          & ( ncid, NF_GLOBAL, 'Rayleigh_number', NF_DOUBLE, 1, Ra )
       status = nf_put_att_double & 
          & ( ncid, NF_GLOBAL, 'Comp_Rayleigh_number', NF_DOUBLE, 1, Rs )
       status = nf_put_att_double & 
          & ( ncid, NF_GLOBAL, 'Prandtl_number', NF_DOUBLE, 1, Pr )
       status = nf_put_att_double &
          & ( ncid, NF_GLOBAL, 'Lewis_number', NF_DOUBLE, 1, Le )
    else
       status = nf_put_att_double & 
          & ( ncid, NF_GLOBAL, 'alpha', NF_DOUBLE, 1, alpha )
       status = nf_put_att_double & 
          & ( ncid, NF_GLOBAL, 'beta', NF_DOUBLE, 1, beta )
       status = nf_put_att_double & 
          & ( ncid, NF_GLOBAL, 'gravity', NF_DOUBLE, 1, g )
       status = nf_put_att_double &
          & ( ncid, NF_GLOBAL, 'Internal_heating', NF_DOUBLE, 1, Q )
    endif

   !------------------------- Ȼ ----------------------------
    status = nf_put_att_double &
         & ( ncid, NF_GLOBAL, 'kappa_s', NF_DOUBLE, 1, kappa_s )
    status = nf_put_att_double &
         & ( ncid, NF_GLOBAL, 'kappa_l', NF_DOUBLE, 1, kappa_l )

    status = nf_put_att_double &
         & ( ncid, NF_GLOBAL, 'Dc_s', NF_DOUBLE, 1, Dc_s )
    status = nf_put_att_double &
         & ( ncid, NF_GLOBAL, 'Dc_l', NF_DOUBLE, 1, Dc_l )

    status = nf_put_att_double &
         & ( ncid, NF_GLOBAL, 'Visc_s', NF_DOUBLE, 1, Visc_s )
    status = nf_put_att_double &
         & ( ncid, NF_GLOBAL, 'Visc_l', NF_DOUBLE, 1, Visc_l )
    status = nf_put_att_double &
         & ( ncid, NF_GLOBAL, 'Visc_m', NF_DOUBLE, 1, Visc_m )

    status = nf_put_att_double &
         & ( ncid, NF_GLOBAL, 'Da_s', NF_DOUBLE, 1, Da_s )
    status = nf_put_att_double &
         & ( ncid, NF_GLOBAL, 'Da_l', NF_DOUBLE, 1, Da_l )

   !---------------------- Ѳѥ᥿ -------------------------
    status = nf_put_att_double &
         & ( ncid, NF_GLOBAL, 'Cp_s', NF_DOUBLE, 1, Cp_s )
    status = nf_put_att_double &
         & ( ncid, NF_GLOBAL, 'Cp_l', NF_DOUBLE, 1, Cp_l )
    status = nf_put_att_double &
         & ( ncid, NF_GLOBAL, 'hf', NF_DOUBLE, 1, hf )
    status = nf_put_att_double &
         & ( ncid, NF_GLOBAL, 'Tm0', NF_DOUBLE, 1, Tm0 )
    status = nf_put_att_double &
         & ( ncid, NF_GLOBAL, 'Tm1', NF_DOUBLE, 1, Tm1 )

   !-----------------------  --------------------------
    call diffuse_boundary_output_nc( ncid )

   !------------------------- ɸѿ --------------------------
    status = nf_def_dim( ncid, 'x', nx, ncdimid(1) )
    status = nf_def_dim( ncid, 'z', nz, ncdimid(2) )
    status = nf_def_dim( ncid, 'time', NF_UNLIMITED, ncdimid(3) )

    status = nf_def_var( ncid, 'x', NF_DOUBLE, 1, ncdimid(1), xid )
    status = nf_put_att_text( ncid, xid, 'longname', 12, 'X coordinate')

    status = nf_def_var( ncid, 'z', NF_DOUBLE, 1, ncdimid(2), zid )
    status = nf_put_att_text( ncid, zid, 'longname', 12, 'Z coordinate')

    status = nf_def_var( ncid, 'time', NF_DOUBLE, 1, ncdimid(3), timeid )
    status = nf_put_att_text( ncid, timeid, 'longname', 4, 'time')

   !-------------------- ѿ(, ήؿ) --------------------
    status = nf_def_var( ncid, 'temp', NF_DOUBLE, 3, ncdimid, tempid )
    status = nf_put_att_text( ncid, tempid, 'longname', 11, 'temperature')

    status = nf_def_var( ncid, 'psi', NF_DOUBLE, 3, ncdimid, psiid )
    status = nf_put_att_text( ncid, psiid, 'longname', 15, 'stream function')

    status = nf_def_var( ncid, 'enth', NF_DOUBLE, 3, ncdimid, enthid )
    status = nf_put_att_text( ncid, enthid, 'longname', 8, 'enthalpy')

    status = nf_def_var( ncid, 'C', NF_DOUBLE, 3, ncdimid, compid )
    status = nf_put_att_text( ncid, compid, 'longname', 11, 'composition')

    status = nf_def_var( ncid, 'fs', NF_DOUBLE, 3, ncdimid, fsid )
    status = nf_put_att_text( ncid, fsid, 'longname', 14, 'solid fraction')

    status = nf_def_var( ncid, 'Cl', NF_DOUBLE, 3, ncdimid, clid )
    status = nf_put_att_text( ncid, clid, 'longname', 16, 'liq. composition')

    status = nf_enddef(ncid)
    if ( status .ne. NF_NOERR ) &
       & call msgdmp('E','ouput_init','cannot leave define mode.' )

    status = nf_put_var_double ( ncid, xid, x )
    status = nf_put_var_double ( ncid, zid, z )

    status = nf_close( ncid )
  end subroutine output_netcdf_init

!================================  ================================
  subroutine output_netcdf_data( filename )
    include 'netcdf.inc'
    integer    ::  i
    character(len=*)    :: filename

    status = nf_open( filename, NF_WRITE, ncid )
    if ( status .ne. NF_NOERR ) &
       &   call msgdmp('E','ouput_netcdf','file open error.' )

    status = nf_inq_dimlen( ncid, timeid, i )
    i = i+1
    write( 6,* ) i, istep, time
    status = nf_put_var1_double ( ncid, timeid, i, time )

    status = nf_put_vara_double & 
            & ( ncid, psiid, (/1,1,i/), (/nx,nz,1/), psi )
    status = nf_put_vara_double & 
            & ( ncid, tempid, (/1,1,i/), (/nx,nz,1/), temp )
    status = nf_put_vara_double & 
            & ( ncid, enthid, (/1,1,i/), (/nx,nz,1/), enth )
    status = nf_put_vara_double & 
            & ( ncid, compid, (/1,1,i/), (/nx,nz,1/), C )
    status = nf_put_vara_double & 
            & ( ncid, fsid, (/1,1,i/), (/nx,nz,1/), fs )
    status = nf_put_vara_double & 
            & ( ncid, clid, (/1,1,i/), (/nx,nz,1/), Cl )

    status = nf_close( ncid )
  end subroutine output_netcdf_data

!============================= ϸ =============================
  subroutine output_netcdf_close
    include 'netcdf.inc'
  
    status = nf_close( ncid )

  end subroutine output_netcdf_close

end module output_netcdf

