! package input
!     for 2-D thermal convection in a square box. 
!
! 99/09/08  S. Takehiro
!
!============================= netcdf  =============================
module input
  use timestep, only    : time
  use coordinates, only : x, z
  use variables
  use dimension
  use namelist
  use read_netcdf

  implicit none

  private
  public   :: input_variables

  contains
!============================= ɤ߹ ===========================
    subroutine input_variables
      character(len=80)    :: file=''
      integer              :: step=1
      logical              :: ofirst=.true.

      integer :: i

      namelist /NMIVAR/ step, file

      if ( ofirst ) then
         ofirst = .false.
         write(6,*)'<<< INITIAL COND. by netcdf file, 99/09/09 >>>'
      endif

      if( .not. rewnml() ) write( nm_write_num, NML=NMIVAR )
      read( nm_read_num, NML=NMIVAR, end=199 )
 199  write( nm_write_num, NML=NMIVAR )

      if ( file .eq. '' .or. step .eq. 0 ) then
         write(6,*)' ### file not found. '
         write(6,*)' ### initial values set internally'
         call variables_init
      else
        !------------- ɸ, 
         call read_netcdf_init( file )

         write(6,*)' ### dimension nx, nz might be modified '
         deallocate( x, z )
         allocate( x(nx), z(nz) )
         allocate ( temp(nx,nz), enth(nx,nz) )
         allocate ( C(nx,nz), Cl(nx,nz), fs(nx,nz) )
         allocate ( zeta(nx,nz), psi(nx,nz) )

         call read_netcdf_axis

        !------------- 
         do i = 1, step
            call read_netcdf_data(i)
         enddo
      endif
    end subroutine input_variables

  end module input
