! package convcont
!     contour plot for 2-D thermal convection in a square box. 
!
! 99/08/24  S. Takehiro
!
program convcurv

  use base
  use variables
  !use dynamics_param
  !use dynamics
  use read_netcdf
  use output_dcl

  implicit none

  character(len=80)    :: filename=''
  integer              :: iws, iarg, ixz, ii

!============================ ե̾ ============================
  call OSQARN(iarg)
  if ( iarg .ge. 1 )then
     call OSGARG( 1, filename )
  else
     call msgdmp('E','convcont','Usage : convcont filename' )
  endif

!============================== ɸ ==============================
  call read_netcdf_init( filename )
  allocate( x(nx), z(nz) )
  allocate ( temp(nx,nz), zeta(nx,nz), psi(nx,nz) )
  allocate ( enth(nx,nz), C(nx,nz), fs(nx,nz), Cl(nx,nz) )

  call read_netcdf_axis
  dx = (x(nx) - x(1)) / (nx-1)
  dz = (z(nz) - z(1)) / (nz-1)

!===============================  ==============================
  write( 6, * ) 'Coodinate(x=1,z=2), number?'
  read ( 5, * ) ixz, ii

  call sgpwsn
  read ( 5, * ) iws
  call output_dcl_init(iws)

!============================== ǡ =============================
  do istep = 1, nt
     call read_netcdf_data(istep)
     call output_dcl_data_header
     if ( ixz .eq. 1 )then
        call output_dcl_data_1dx(ii)
     else
        call output_dcl_data_1dz(ii)
     endif
  enddo

!================================= λ ================================
  call read_netcdf_close
  call output_dcl_close

end program convcurv

