! package convcont
!     contour plot for 2-D thermal convection in a square box. 
!
! 99/05/04  S. Takehiro
!
program convcont

  use base
  use variables
  !use dynamics_param
  !use dynamics
  use read_netcdf
  use output_dcl

  implicit none

  character(len=80)    :: filename=''
  integer              :: iws, iarg

!============================ ե̾ ============================
  call OSQARN(iarg)
  if ( iarg .ge. 1 )then
     call OSGARG( 1, filename )
  else
     call msgdmp('E','convcont','Usage : convcont filename' )
  endif

!============================== ɸ ==============================
  call read_netcdf_init( filename )
  allocate( x(nx), z(nz) )
  allocate ( temp(nx,nz), zeta(nx,nz), psi(nx,nz) )
  allocate ( enth(nx,nz), C(nx,nz), fs(nx,nz), Cl(nx,nz) )

  call read_netcdf_axis

!===============================  ==============================
  call sgpwsn
  read ( 5, * ) iws
  call output_dcl_init(iws)

!============================== ǡ =============================
  do istep = 1, nt
     call read_netcdf_data(istep)
     call output_dcl_data
  enddo

!================================= λ ================================
  call read_netcdf_close
  call output_dcl_close

end program convcont

